/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.mtwizard;

import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.web.tv.sec.nacl.mtgenerator.CompositeMessageData;
import org.tizen.web.tv.sec.nacl.mtgenerator.JsMessage;
import org.tizen.web.tv.sec.nacl.mtgenerator.Message;
import org.tizen.web.tv.sec.nacl.mtgenerator.MessageData;
import org.tizen.web.tv.sec.nacl.mtgenerator.NaClMessage;
import org.tizen.web.tv.sec.nacl.mtgenerator.SimpleMessageData;
import org.tizen.web.tv.sec.nacl.mtwizard.AddMessageDialog;
import org.tizen.web.tv.sec.nacl.mtwizard.Helpers;
import org.tizen.web.tv.sec.nacl.mtwizard.Messages;

public class MessageDialog
extends Dialog {
    protected int result;
    protected Shell shlNaClMessageProperties;
    private Text messageName;
    private Tree paramTree;
    private Text msgDataName;
    private Combo msgDataType;
    private Text msgDataDescription;
    private TreeItem treeItemUnderEditing;
    private Combo messageType;
    private final Set<String> dictNamesUsed = new HashSet<String>();
    private static final Color COLOR_FAIL = new Color((Device)Display.getCurrent(), 255, 0, 0);
    static final String varDictionaryMessageType = "Dictionary";
    static final String dictDefaultChildName = "---";
    static final String dictDefaultChildType = "---";
    static final String dictDefaultChildDesc = Messages.MessageDialogAddDictionaryEntry;
    private TableItem editedMsgTableItem;
    private static final String JS_TYPE_NAME = Message.Type.JavaScript.toString();
    private static final String NACL_TYPE_NAME = Message.Type.NaCl.toString();
    private static final String INVALID_NAME = Messages.MessageDialogInvalid;
    private static final int NAME_IDX = 0;
    private static final int TYPE_IDX = 1;
    private static final int DESC_IDX = 2;
    private static final float[] COLUMNS_RELATIVE_WIDTH = new float[]{0.1f, 0.1f, 0.8f};
    private static final int INITIAL_COLUMN_WIDTH = 100;
    private static final int INITIAL_DESCRIPTION_COLUMN_WIDTH = 300;
    private static final String MATCH_ALLOWED_NAME = "^[a-zA-Z][a-zA-Z0-9_]*$";
    private FormData fdbtnDelete;
    private FormData fdmsgDataName;
    private FormData fdmsgDataType;
    private FormData fdtable;
    private static final int MIN_DIALOG_WIDTH = 630;
    private static final int MIN_DIALOG_HEIGHT = 550;
    private static final int WIDGETS_CLEARANCE = 6;
    private static final Logger logger = Logger.getLogger(MessageDialog.class.getPackage().getName());
    private Label lblDataName;
    private final SelectionListener btnCancelHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            MessageDialog.this.shlNaClMessageProperties.dispose();
        }
    };
    private final SelectionListener btnOkHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            NaClMessage msg;
            if (MessageDialog.this.messageName.getText().isEmpty() || MessageDialog.this.messageType.getText().isEmpty()) {
                Helpers.errorMessage(MessageDialog.this.shlNaClMessageProperties, Messages.MessageDialogNameOrTypeEmpty);
                return;
            }
            logger.finest("Adding message: " + MessageDialog.this.messageName.getText());
            if (MessageDialog.this.messageType.getText().equals(NACL_TYPE_NAME)) {
                msg = new NaClMessage(MessageDialog.this.messageName.getText());
            } else if (MessageDialog.this.messageType.getText().equals(JS_TYPE_NAME)) {
                msg = new JsMessage(MessageDialog.this.messageName.getText(), false);
            } else {
                Helpers.errorMessage(MessageDialog.this.shlNaClMessageProperties, Messages.MessageDialogMsgTypeInvalid);
                return;
            }
            TreeItem[] treeItemArray = MessageDialog.this.paramTree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean ret;
                TreeItem ti = treeItemArray[n2];
                String name = ti.getText(0);
                String type = ti.getText(1);
                String description = ti.getText(2);
                if (type.equals(MessageDialog.varDictionaryMessageType)) {
                    CompositeMessageData data = new CompositeMessageData(name, description);
                    this.addCompositeMessageData(data, ti);
                    ret = msg.addData((MessageData)data);
                } else {
                    ret = msg.addData((MessageData)new SimpleMessageData(name, type, description));
                }
                logger.finest("MessageType " + ti.getText(0) + (ret ? " added" : "NOT added"));
                ++n2;
            }
            boolean msgUpdated = AddMessageDialog.sourceGeneratorRunner.addMessage((Message)msg);
            logger.finest("Message " + MessageDialog.this.messageName.getText() + (msgUpdated ? " updated." : " added."));
            int size = AddMessageDialog.sourceGeneratorRunner.getMessages().size();
            logger.finest("Number of messages: " + size);
            MessageDialog.this.result = 32;
            MessageDialog.this.shlNaClMessageProperties.dispose();
        }

        private void addCompositeMessageData(CompositeMessageData data, TreeItem item) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                String name = child.getText(0);
                String type = child.getText(1);
                String description = child.getText(2);
                if (!MessageDialog.isDefaultChild(child)) {
                    if (child.getText(1).equals(MessageDialog.varDictionaryMessageType)) {
                        CompositeMessageData newData = new CompositeMessageData(name, description);
                        this.addCompositeMessageData(newData, child);
                        data.add((MessageData)newData);
                    } else {
                        data.add((MessageData)new SimpleMessageData(name, type, description));
                    }
                }
                ++n2;
            }
        }
    };
    private final ControlAdapter tableResizeHandler = new ControlAdapter(){

        public void controlResized(ControlEvent ev) {
            int colWidthIndex = 0;
            TreeColumn[] treeColumnArray = MessageDialog.this.paramTree.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn tc = treeColumnArray[n2];
                if (colWidthIndex >= COLUMNS_RELATIVE_WIDTH.length) {
                    logger.warning("Could not set the column no. " + colWidthIndex + " width. The index is out of the " + "COLUMN_RELATIVE_WIDTH array's bounds.");
                    break;
                }
                tc.setWidth((int)((float)((MessageDialog)MessageDialog.this).paramTree.getSize().x * COLUMNS_RELATIVE_WIDTH[colWidthIndex++]) - 1);
                ++n2;
            }
        }
    };
    private final KeyAdapter tableKeyHandler = new KeyAdapter(){

        public void keyPressed(KeyEvent ev) {
            if (ev.character == '\u007f' && MessageDialog.this.treeItemUnderEditing != null) {
                MessageDialog.this.treeItemUnderEditing.dispose();
            }
        }
    };
    private final SelectionListener tableDblClickHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            logger.finest("MessageData item selected in the table");
            MessageDialog.this.treeItemUnderEditing = (TreeItem)ev.item;
            boolean defaultChild = MessageDialog.isDefaultChild(MessageDialog.this.treeItemUnderEditing);
            if (!defaultChild) {
                MessageDialog.this.msgDataType.setText(MessageDialog.this.treeItemUnderEditing.getText(1));
                MessageDialog.this.msgDataName.setText(MessageDialog.this.treeItemUnderEditing.getText(0));
            } else {
                MessageDialog.this.msgDataName.setText("");
            }
            MessageDialog.this.btnDelete.setEnabled(!defaultChild);
            MessageDialog.this.btnUpdate.setEnabled(!defaultChild);
            MessageDialog.this.msgDataDescription.setText(MessageDialog.this.treeItemUnderEditing.getText(2));
        }
    };
    private final ModifyListener msgDataNameModifiedHandler = new ModifyListener(){

        public void modifyText(ModifyEvent ev) {
            MessageDialog.this.msgDataName.setForeground(null);
            MessageDialog.this.msgDataName.setToolTipText("");
            if (MessageDialog.this.msgDataName.getText().equals("messageID")) {
                MessageDialog.eraseLastTextControlCharacter(MessageDialog.this.msgDataName);
                Helpers.errorMessage(MessageDialog.this.shlNaClMessageProperties, MessageFormat.format(Messages.MessageDialogParameterNameInvalid, "messageID"));
            }
        }
    };
    private final SelectionListener msgTypeSelectedHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
        }
    };
    private final SelectionListener btnAddSelectedHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            if (!MessageDialog.this.msgDataName.getText().isEmpty() && !MessageDialog.this.msgDataType.getText().isEmpty()) {
                TreeItem[] itemsToCheck;
                boolean itsVarArrayBuffer = MessageDialog.this.msgDataType.getText().equals(SimpleMessageData.Type.ArrayBuffer.toString());
                String varArrayBufferSizeParam = itsVarArrayBuffer ? String.valueOf(MessageDialog.this.msgDataName.getText()) + "Size" : "";
                boolean itsVarDictionary = MessageDialog.this.msgDataType.getText().equals(MessageDialog.varDictionaryMessageType);
                if (itsVarDictionary && MessageDialog.this.dictNamesUsed.contains(MessageDialog.this.msgDataName.getText())) {
                    MessageDialog.this.dictWithSameNameExists();
                    return;
                }
                TreeItem parent = MessageDialog.this.treeItemUnderEditing == null ? null : MessageDialog.this.treeItemUnderEditing.getParentItem();
                TreeItem[] treeItemArray = itemsToCheck = parent == null ? MessageDialog.this.paramTree.getItems() : parent.getItems();
                if (!Helpers.isItemContainedIn(itemsToCheck, MessageDialog.this.msgDataName.getText()) && !Helpers.isItemContainedIn(itemsToCheck, varArrayBufferSizeParam)) {
                    TreeItem newItem = parent == null ? Helpers.addTreeItem(MessageDialog.this.paramTree, null, MessageDialog.this.msgDataName.getText(), MessageDialog.this.msgDataType.getText(), MessageDialog.this.msgDataDescription.getText()) : Helpers.addTreeItem(parent, null, MessageDialog.this.msgDataName.getText(), MessageDialog.this.msgDataType.getText(), MessageDialog.this.msgDataDescription.getText());
                    if (itsVarDictionary) {
                        Helpers.addTreeItem(newItem, null, "---", "---", dictDefaultChildDesc);
                        MessageDialog.this.dictNamesUsed.add(MessageDialog.this.msgDataName.getText());
                    }
                } else {
                    MessageDialog.this.paramWithSameNameExists();
                }
            }
        }
    };
    private final SelectionListener btnUpdateSelectedHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            logger.finest("Update button handler fired");
            if (MessageDialog.this.treeItemUnderEditing != null) {
                boolean nameChanged = !MessageDialog.this.treeItemUnderEditing.getText(0).contentEquals(MessageDialog.this.msgDataName.getText());
                TreeItem[] itemsToCheck = MessageDialog.this.treeItemUnderEditing.getParentItem() != null ? MessageDialog.this.treeItemUnderEditing.getParentItem().getItems() : MessageDialog.this.paramTree.getItems();
                if (!nameChanged || !Helpers.isItemContainedIn(itemsToCheck, MessageDialog.this.msgDataName.getText())) {
                    logger.finest("Updating table item: " + MessageDialog.this.treeItemUnderEditing.getText(0));
                    boolean typeChanged = !MessageDialog.this.treeItemUnderEditing.getText(1).equals(MessageDialog.this.msgDataType.getText());
                    boolean isVarDictionary = MessageDialog.this.msgDataType.getText().equals(MessageDialog.varDictionaryMessageType);
                    boolean wasVarDictionary = MessageDialog.this.treeItemUnderEditing.getText(1).equals(MessageDialog.varDictionaryMessageType);
                    if (typeChanged && wasVarDictionary) {
                        TreeItem[] treeItemArray = MessageDialog.this.treeItemUnderEditing.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem child = treeItemArray[n2];
                            child.dispose();
                            ++n2;
                        }
                        MessageDialog.this.dictNamesUsed.remove(MessageDialog.this.treeItemUnderEditing.getText(0));
                    } else if (typeChanged && isVarDictionary) {
                        if (MessageDialog.this.dictNamesUsed.contains(MessageDialog.this.msgDataName.getText())) {
                            MessageDialog.this.dictWithSameNameExists();
                            return;
                        }
                        Helpers.addTreeItem(MessageDialog.this.treeItemUnderEditing, null, "---", "---", dictDefaultChildDesc);
                    } else if (nameChanged && isVarDictionary) {
                        if (MessageDialog.this.dictNamesUsed.contains(MessageDialog.this.msgDataName.getText())) {
                            MessageDialog.this.dictWithSameNameExists();
                            return;
                        }
                        MessageDialog.this.dictNamesUsed.remove(MessageDialog.this.treeItemUnderEditing.getText(0));
                        MessageDialog.this.dictNamesUsed.add(MessageDialog.this.msgDataName.getText());
                    }
                    MessageDialog.this.treeItemUnderEditing.setText(0, MessageDialog.this.msgDataName.getText());
                    MessageDialog.this.treeItemUnderEditing.setText(1, MessageDialog.this.msgDataType.getText());
                    MessageDialog.this.treeItemUnderEditing.setText(2, MessageDialog.this.msgDataDescription.getText());
                } else {
                    MessageDialog.this.paramWithSameNameExists();
                }
            }
        }
    };
    private final SelectionListener btnDeleteSelectedHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            if (MessageDialog.this.treeItemUnderEditing != null) {
                if (MessageDialog.this.treeItemUnderEditing.getText(1).equals(MessageDialog.varDictionaryMessageType)) {
                    MessageDialog.this.dictNamesUsed.remove(MessageDialog.this.treeItemUnderEditing.getText(0));
                }
                MessageDialog.this.treeItemUnderEditing.dispose();
            }
        }
    };
    private final Listener messageNameModifyHandler = new Listener(){

        public void handleEvent(Event event) {
            if (!MessageDialog.this.validateInputText(MessageDialog.this.messageName, MessageDialog.MATCH_ALLOWED_NAME)) {
                Helpers.errorMessage(MessageDialog.this.shlNaClMessageProperties, String.valueOf(Messages.MessageDialogErrorMessageNamePattern) + MessageDialog.MATCH_ALLOWED_NAME);
            }
        }
    };
    private final Listener msgDataNameModifyHandler = new Listener(){

        public void handleEvent(Event event) {
            if (!MessageDialog.this.validateInputText(MessageDialog.this.msgDataName, MessageDialog.MATCH_ALLOWED_NAME)) {
                Helpers.errorMessage(MessageDialog.this.shlNaClMessageProperties, String.valueOf(Messages.MessageDialogErrorParameterNamePattern) + MessageDialog.MATCH_ALLOWED_NAME);
            }
        }
    };
    private Button btnUpdate;
    private Button btnDelete;

    public void setEditedMsgTableItem(TableItem editedMessageTableItem) {
        this.editedMsgTableItem = editedMessageTableItem;
    }

    private void updateFieldsFromEditedMessage() {
        if (this.editedMsgTableItem == null) {
            return;
        }
        Message editedMessage = AddMessageDialog.sourceGeneratorRunner.getMessage(this.editedMsgTableItem.getText(0));
        this.messageName.setText(editedMessage.getName());
        if (editedMessage instanceof JsMessage) {
            logger.finest("updateFieldsFromEditeMessage(): JsMessage");
            this.messageType.setText(JS_TYPE_NAME);
        } else if (editedMessage instanceof NaClMessage) {
            logger.finest("updateFieldsFromEditeMessage(): NaClMessage");
            this.messageType.setText(NACL_TYPE_NAME);
        } else {
            logger.log(Level.WARNING, "updateFieldsFromEditeMessage(): Unknown message type");
            this.messageType.setText(INVALID_NAME);
        }
        Helpers.fillTreeWithMessageData(this.paramTree, editedMessage);
    }

    public MessageDialog(Shell parent, int style) {
        super(parent, style);
        this.setText(Messages.CommonStringsMsgProps);
    }

    public int open() {
        this.result = 256;
        this.createContents();
        this.updateFieldsFromEditedMessage();
        this.shlNaClMessageProperties.open();
        this.shlNaClMessageProperties.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shlNaClMessageProperties.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private static boolean isDefaultChild(TreeItem item) {
        return Helpers.equals(item, 0, "---", "---", dictDefaultChildDesc);
    }

    private static void eraseLastTextControlCharacter(Text textControl) {
        int orgCarretPos = textControl.getCaretPosition();
        if (orgCarretPos == 0) {
            return;
        }
        StringBuilder trimText = new StringBuilder(textControl.getText());
        trimText.deleteCharAt(orgCarretPos - 1);
        textControl.setText(trimText.toString());
        textControl.setSelection(orgCarretPos - 1);
        logger.finest("Input text after removing improper character: " + trimText);
    }

    private void paramWithSameNameExists() {
        logger.warning("Parameter with same name already exists: " + this.msgDataName.getText());
        this.paramNameError(Messages.MessageDialogMsgDataAlreadyExists);
    }

    private void dictWithSameNameExists() {
        logger.warning("A dictionary with same name already exists: " + this.msgDataName.getText());
        this.paramNameError(Messages.MessageDialogDictAlreadyExists);
    }

    private void paramNameError(String message) {
        this.msgDataName.setForeground(COLOR_FAIL);
        this.msgDataName.setToolTipText(message);
    }

    private boolean validateInputText(Text textControl, String regexMatch) {
        String text = textControl.getText();
        if (text.isEmpty()) {
            return true;
        }
        if (!text.matches(regexMatch)) {
            Toolkit.getDefaultToolkit().beep();
            MessageDialog.eraseLastTextControlCharacter(textControl);
            return false;
        }
        return true;
    }

    private void createContents() {
        this.shlNaClMessageProperties = new Shell(this.getParent(), 67696);
        this.shlNaClMessageProperties.setSize(630, 550);
        this.shlNaClMessageProperties.setMinimumSize(630, 550);
        Helpers.centerShellRelativeToParent(this.getParent(), this.shlNaClMessageProperties);
        this.shlNaClMessageProperties.setText(Messages.CommonStringsMsgProps);
        this.shlNaClMessageProperties.setLayout((Layout)new FormLayout());
        Button btnCancel = new Button((Composite)this.shlNaClMessageProperties, 0);
        btnCancel.addSelectionListener(this.btnCancelHandler);
        btnCancel.setText(Messages.CommonStringsCancel);
        FormData fdbtnCancel = new FormData();
        fdbtnCancel.top = new FormAttachment((Control)btnCancel, 0, 0x1000000);
        fdbtnCancel.right = new FormAttachment((Control)btnCancel, -6);
        Button btnOk = new Button((Composite)this.shlNaClMessageProperties, 0);
        btnOk.addSelectionListener(this.btnOkHandler);
        btnOk.setLayoutData((Object)fdbtnCancel);
        btnOk.setText(Messages.CommonStringsOk);
        FormData fdbtnOk = new FormData();
        fdbtnOk.bottom = new FormAttachment(100, -10);
        fdbtnOk.right = new FormAttachment(100, -10);
        btnCancel.setLayoutData((Object)fdbtnOk);
        Label lblMessageName = new Label((Composite)this.shlNaClMessageProperties, 0);
        FormData fdlblMessageName = new FormData();
        fdlblMessageName.top = new FormAttachment(0, 10);
        fdlblMessageName.left = new FormAttachment(0, 10);
        lblMessageName.setLayoutData((Object)fdlblMessageName);
        lblMessageName.setText(Messages.MessageDialogMsgName);
        this.messageName = new Text((Composite)this.shlNaClMessageProperties, 2048);
        this.messageName.addListener(24, this.messageNameModifyHandler);
        FormData fdmessageNameText = new FormData();
        fdmessageNameText.left = new FormAttachment((Control)lblMessageName, 6);
        fdmessageNameText.width = 150;
        fdmessageNameText.top = new FormAttachment((Control)lblMessageName, 0, 0x1000000);
        this.messageName.setLayoutData((Object)fdmessageNameText);
        Group grpMessageDataArray = new Group((Composite)this.shlNaClMessageProperties, 0);
        grpMessageDataArray.setText(Messages.MessageDialogMsgDataArray);
        grpMessageDataArray.setLayout((Layout)new FormLayout());
        FormData fdgrpMessageDataArray = new FormData();
        fdgrpMessageDataArray.bottom = new FormAttachment((Control)btnCancel, -6);
        fdgrpMessageDataArray.right = new FormAttachment(100, -10);
        fdgrpMessageDataArray.left = new FormAttachment((Control)lblMessageName, 0, 16384);
        fdgrpMessageDataArray.width = 450;
        grpMessageDataArray.setLayoutData((Object)fdgrpMessageDataArray);
        this.paramTree = new Tree((Composite)grpMessageDataArray, 67584);
        this.paramTree.addControlListener((ControlListener)this.tableResizeHandler);
        this.paramTree.setToolTipText("");
        this.paramTree.addKeyListener((KeyListener)this.tableKeyHandler);
        this.paramTree.addSelectionListener(this.tableDblClickHandler);
        this.paramTree.setHeaderVisible(true);
        this.paramTree.setLinesVisible(true);
        this.fdtable = new FormData();
        this.fdtable.left = new FormAttachment(0, 6);
        this.fdtable.right = new FormAttachment(100, -6);
        this.fdtable.top = new FormAttachment(0, 9);
        this.paramTree.setLayoutData((Object)this.fdtable);
        TreeColumn tblclmnName = new TreeColumn(this.paramTree, 0);
        tblclmnName.setWidth(100);
        tblclmnName.setToolTipText(Messages.MessageDialogMsgDataName);
        tblclmnName.setText(Messages.CommonStringsName);
        TreeColumn tblclmnType = new TreeColumn(this.paramTree, 0);
        tblclmnType.setWidth(100);
        tblclmnType.setToolTipText(String.valueOf(Messages.MessageDialogTypeTooltip1) + Messages.MessageDialogTypeTooltip2 + Messages.MessageDialogTypeTooltip3);
        tblclmnType.setText(Messages.CommonStringsType);
        TreeColumn tblclmnDescription = new TreeColumn(this.paramTree, 0);
        tblclmnDescription.setToolTipText(Messages.MessageDialogDescriptionTooltip);
        tblclmnDescription.setWidth(300);
        tblclmnDescription.setText(Messages.MessageDialogDescription);
        this.msgDataName = new Text((Composite)grpMessageDataArray, 2048);
        this.msgDataName.addListener(24, this.msgDataNameModifyHandler);
        this.fdmsgDataName = new FormData();
        this.msgDataName.setLayoutData((Object)this.fdmsgDataName);
        this.msgDataName.addModifyListener(this.msgDataNameModifiedHandler);
        this.msgDataType = new Combo((Composite)grpMessageDataArray, 8);
        this.fdmsgDataType = new FormData();
        this.fdmsgDataType.top = new FormAttachment((Control)this.msgDataName, 0, 0x1000000);
        this.fdmsgDataType.left = new FormAttachment((Control)this.msgDataName, 6);
        this.msgDataType.setLayoutData((Object)this.fdmsgDataType);
        this.msgDataDescription = new Text((Composite)grpMessageDataArray, 2048);
        FormData fdmsgDataDescription = new FormData();
        fdmsgDataDescription.right = new FormAttachment(100);
        fdmsgDataDescription.top = new FormAttachment((Control)this.msgDataName, 0, 0x1000000);
        fdmsgDataDescription.left = new FormAttachment((Control)this.msgDataType, 6);
        this.msgDataDescription.setLayoutData((Object)fdmsgDataDescription);
        int index = 0;
        while (index < SimpleMessageData.Type.values().length - 1) {
            this.msgDataType.add(SimpleMessageData.Type.values()[index].toString());
            ++index;
        }
        this.msgDataType.add(varDictionaryMessageType);
        Label lblMessageType = new Label((Composite)this.shlNaClMessageProperties, 0);
        fdmessageNameText.right = new FormAttachment((Control)lblMessageType, -6);
        FormData fdlblMessageType = new FormData();
        fdlblMessageType.top = new FormAttachment((Control)lblMessageName, 0, 0x1000000);
        lblMessageType.setLayoutData((Object)fdlblMessageType);
        lblMessageType.setText(Messages.MessageDialogMsgType);
        this.messageType = new Combo((Composite)this.shlNaClMessageProperties, 8);
        fdlblMessageType.right = new FormAttachment((Control)this.messageType, -6);
        fdgrpMessageDataArray.top = new FormAttachment((Control)this.messageType, 5);
        this.messageType.addSelectionListener(this.msgTypeSelectedHandler);
        this.messageType.setItems(new String[]{NACL_TYPE_NAME, JS_TYPE_NAME});
        FormData fdmessageType = new FormData();
        fdmessageType.top = new FormAttachment((Control)lblMessageName, 0, 0x1000000);
        fdmessageType.right = new FormAttachment((Control)btnCancel, 0, 131072);
        this.messageType.setLayoutData((Object)fdmessageType);
        this.messageType.select(0);
        Button btnAdd = new Button((Composite)grpMessageDataArray, 0);
        this.fdmsgDataName.bottom = new FormAttachment((Control)btnAdd, -6);
        FormData fdbtnAdd = new FormData();
        fdbtnAdd.bottom = new FormAttachment(100, -6);
        fdbtnAdd.left = new FormAttachment(0, 6);
        btnAdd.setLayoutData((Object)fdbtnAdd);
        btnAdd.addSelectionListener(this.btnAddSelectedHandler);
        btnAdd.setText(Messages.CommonStringsAdd);
        this.btnUpdate = new Button((Composite)grpMessageDataArray, 0);
        this.btnUpdate.addSelectionListener(this.btnUpdateSelectedHandler);
        this.btnUpdate.setText(Messages.CommonStringsUpdate);
        FormData fdbtnUpdate = new FormData();
        fdbtnUpdate.top = new FormAttachment((Control)btnAdd, 0, 0x1000000);
        fdbtnUpdate.left = new FormAttachment((Control)btnAdd, 6);
        this.btnUpdate.setLayoutData((Object)fdbtnUpdate);
        this.btnDelete = new Button((Composite)grpMessageDataArray, 0);
        this.btnDelete.addSelectionListener(this.btnDeleteSelectedHandler);
        this.btnDelete.setToolTipText(Messages.MessageDialogRemoveTooltip);
        this.btnDelete.setText(Messages.CommonStringsDelete);
        this.fdbtnDelete = new FormData();
        this.fdbtnDelete.top = new FormAttachment((Control)btnAdd, 0, 0x1000000);
        this.fdbtnDelete.left = new FormAttachment((Control)this.btnUpdate, 6);
        this.btnDelete.setLayoutData((Object)this.fdbtnDelete);
        this.lblDataName = new Label((Composite)grpMessageDataArray, 0);
        FormData fdlblDataName = new FormData();
        fdlblDataName.left = new FormAttachment(0, 6);
        fdlblDataName.bottom = new FormAttachment((Control)this.msgDataName, -6);
        this.lblDataName.setLayoutData((Object)fdlblDataName);
        this.lblDataName.setText(Messages.MessageDialogDataName);
        this.fdtable.bottom = new FormAttachment((Control)this.lblDataName, -6);
        this.fdmsgDataName.left = new FormAttachment((Control)this.lblDataName, 0, 16384);
        this.fdmsgDataName.right = new FormAttachment((Control)this.lblDataName, 0, 131072);
        Label lblDataType = new Label((Composite)grpMessageDataArray, 0);
        FormData fdlblDataType = new FormData();
        fdlblDataType.left = new FormAttachment((Control)this.lblDataName, 6);
        fdlblDataType.top = new FormAttachment((Control)this.lblDataName, 0, 0x1000000);
        lblDataType.setLayoutData((Object)fdlblDataType);
        lblDataType.setText(Messages.MessageDialogDataType);
        Label lblDataDescription = new Label((Composite)grpMessageDataArray, 0);
        FormData fdlblDataDescription = new FormData();
        fdlblDataDescription.top = new FormAttachment((Control)lblDataType, 0, 0x1000000);
        fdlblDataDescription.left = new FormAttachment((Control)this.msgDataDescription, 0, 16384);
        lblDataDescription.setLayoutData((Object)fdlblDataDescription);
        lblDataDescription.setText(Messages.MessageDialogDataDescription);
    }
}

