/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.export;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;
import org.tizen.web.tv.sec.nacl.builder.export.Messages;
import org.tizen.web.tv.sec.nacl.builder.export.WidgetExportPage;
import org.tizen.web.tv.sec.nacl.builder.export.WidgetExporter;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;

public class WidgetExportWizard
extends Wizard
implements IExportWizard {
    private final WidgetExportPage exportPage = new WidgetExportPage(Messages.WidgetExportWizard_exportPageTitle);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IWorkbenchPage page;
        this.addPage((IWizardPage)this.exportPage);
        IProject project = ProjectUtils.getCurrentProject((ISelection)selection);
        if (project == null && (page = workbench.getActiveWorkbenchWindow().getActivePage()) != null) {
            IEditorPart part = page.getActiveEditor();
            project = ProjectUtils.getCurrentProject((IEditorPart)part);
        }
        if (project != null) {
            this.exportPage.setInitialSelection(project.getName());
        }
        this.setWindowTitle(Messages.WidgetExportWizard_exportWizardTitle);
    }

    public boolean performFinish() {
        final IProject project = this.exportPage.getProject();
        final String widgetPath = this.exportPage.getWidgetPath().endsWith(".wgt") ? this.exportPage.getWidgetPath() : String.valueOf(this.exportPage.getWidgetPath()) + ".wgt";
        UIJob job = new UIJob(Messages.WidgetExportWizard_JobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask(Messages.WidgetExportWizard_JobName, 100);
                try {
                    WidgetExporter.export(project, widgetPath, false);
                    MessageDialog.openInformation(null, (String)Messages.WidgetExportWizard_successMessage, (String)NLS.bind((String)Messages.WidgetExportWizard_widgetExportedMessage, (Object)widgetPath));
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException ex) {
                    MessageDialog.openError((Shell)WidgetExportWizard.this.getShell(), (String)Messages.WidgetExportWizard_errorMessage, (String)ex.getLocalizedMessage());
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }
}

