/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.privileges;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.tizen.web.tv.sec.nacl.builder.InterfaceMappingProvider;
import org.tizen.web.tv.sec.nacl.builder.Utils;
import org.tizen.web.tv.sec.nacl.builder.export.WidgetExporter;
import org.tizen.web.tv.sec.nacl.builder.privileges.Messages;
import org.tizen.web.tv.sec.nacl.common.TizenPrivileges;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;
import org.xml.sax.SAXException;

public class TizenPrivilegesPage
extends PropertyPage {
    private Table tableAutodetectedPriv;
    private Table tableManualPriv;
    private Text textCustomPriv;
    private Button btnAddCustomPriv;
    private Composite composite;
    private List<String> selectedPrivileges = null;
    private List<String> removedPrivileges = null;
    private List<String> autodetectedPrivileges = null;
    private List<String> restKnownPrivileges = null;

    protected Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gl_comp_1 = new GridLayout(2, false);
        this.composite.setLayout((Layout)gl_comp_1);
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        this.createPageControls(this.composite, project);
        return this.composite;
    }

    private void createPageControls(Composite comp, IProject project) {
        Label labelAutoPriv = new Label(comp, 0);
        labelAutoPriv.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        labelAutoPriv.setText(Messages.TizenPrivilegesPage_LabelAutoPrivileges);
        new Label(this.composite, 0);
        this.tableAutodetectedPriv = new Table(this.composite, 68130);
        GridData gd_table = new GridData(4, 4, true, true, 2, 1);
        gd_table.widthHint = 276;
        gd_table.heightHint = 73;
        this.tableAutodetectedPriv.setLayoutData((Object)gd_table);
        this.tableAutodetectedPriv.setHeaderVisible(true);
        this.tableAutodetectedPriv.setLinesVisible(true);
        Label labelManualPriv = new Label(comp, 0);
        GridData gd_labelManualPriv = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_labelManualPriv.widthHint = 163;
        labelManualPriv.setLayoutData((Object)gd_labelManualPriv);
        labelManualPriv.setText(Messages.TizenPrivilegesPage_LabelRestPrivileges);
        new Label(this.composite, 0);
        this.tableManualPriv = new Table(this.composite, 68130);
        GridData gd_table_1 = new GridData(4, 4, true, true, 2, 1);
        gd_table_1.heightHint = 63;
        this.tableManualPriv.setLayoutData((Object)gd_table_1);
        this.tableManualPriv.setHeaderVisible(true);
        this.tableManualPriv.setLinesVisible(true);
        this.textCustomPriv = new Text(this.composite, 2052);
        this.textCustomPriv.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textCustomPriv.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                TizenPrivilegesPage.this.updateApplyButton();
            }
        });
        this.textCustomPriv.addListener(31, new Listener(){

            public void handleEvent(Event ev) {
                if (ev.detail == 4) {
                    ev.doit = false;
                }
            }
        });
        this.textCustomPriv.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ev) {
                if (ev.keyCode == 13) {
                    TizenPrivilegesPage.this.addCustomPrivilege();
                }
            }

            public void keyReleased(KeyEvent ev) {
            }
        });
        this.btnAddCustomPriv = new Button(this.composite, 8);
        this.btnAddCustomPriv.setText(Messages.TizenPrivilegesPage_BtnAdd);
        this.btnAddCustomPriv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                TizenPrivilegesPage.this.addCustomPrivilege();
            }
        });
        this.setInitialValues(project);
        this.updateControls();
    }

    protected void performDefaults() {
        TableItem[] tableItemArray = this.tableManualPriv.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(false);
            ++n2;
        }
    }

    private void addCustomPrivilege() {
        if (this.textCustomPriv.getText() != null && !this.textCustomPriv.getText().isEmpty()) {
            TableItem item = this.findOrCreateItem(this.textCustomPriv.getText(), this.tableManualPriv);
            item.setChecked(true);
            this.tableManualPriv.showItem(item);
            this.textCustomPriv.setText("");
            this.updateApplyButton();
        }
    }

    private TableItem findOrCreateItem(String text, Table table) {
        TableItem item;
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = tableItemArray[n2];
            if (item.getText().equals(text)) {
                return item;
            }
            ++n2;
        }
        item = new TableItem(table, 0);
        item.setText(text);
        return item;
    }

    private void setInitialValues(IProject project) {
        INaclPreferences prefs = NaclPreferenceActivator.getDefault().getNaclPreferences();
        this.selectedPrivileges = new ArrayList<String>();
        this.removedPrivileges = new ArrayList<String>();
        this.autodetectedPrivileges = this.computePrivileges(project);
        this.restKnownPrivileges = new ArrayList<String>();
        this.restKnownPrivileges.addAll(TizenPrivileges.PRIVILEGES);
        if (prefs.getPrivilegesList(project, this.selectedPrivileges, this.removedPrivileges)) {
            IFile config = project.getFile("config.xml");
            try {
                Utils.loadPrivilegesFromConfigXml(config.getLocation().toString(), this.selectedPrivileges);
                HashSet<String> uniqueSelectedPrivileges = new HashSet<String>();
                uniqueSelectedPrivileges.addAll(this.selectedPrivileges);
                this.selectedPrivileges.clear();
                this.selectedPrivileges.addAll(uniqueSelectedPrivileges);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
            this.tableAutodetectedPriv(this.autodetectedPrivileges, this.removedPrivileges, this.restKnownPrivileges);
            this.fillTableManualPriv(this.restKnownPrivileges, this.selectedPrivileges);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TizenPrivilegesPage_Error, (String)Messages.TizenPrivilegesPage_FailedLoadPrivileges);
        }
    }

    private void tableAutodetectedPriv(List<String> autodetectedPriv, List<String> removedPriv, List<String> restKnownPriv) {
        if (!autodetectedPriv.isEmpty()) {
            for (String priv : autodetectedPriv) {
                restKnownPriv.remove(priv);
                TableItem item = new TableItem(this.tableAutodetectedPriv, 0);
                item.setText(priv);
                item.setChecked(!removedPriv.contains(priv));
            }
        }
    }

    private void fillTableManualPriv(List<String> allPriv, List<String> selectedPriv) {
        TableItem item;
        ArrayList<String> addPriv = new ArrayList<String>();
        addPriv.addAll(selectedPriv);
        for (String priv : allPriv) {
            item = new TableItem(this.tableManualPriv, 0);
            item.setText(priv);
            item.setChecked(selectedPriv.contains(priv));
        }
        addPriv.removeAll(allPriv);
        for (String priv : addPriv) {
            item = new TableItem(this.tableManualPriv, 0);
            item.setText(priv);
            item.setChecked(true);
        }
    }

    private void getModifiedPriviligesList(List<String> addPriv, List<String> removedPriv) {
        TableItem item;
        TableItem[] tableItemArray = this.tableAutodetectedPriv.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = tableItemArray[n2];
            if (!item.getChecked()) {
                removedPriv.add(item.getText());
            }
            ++n2;
        }
        tableItemArray = this.tableManualPriv.getItems();
        n = tableItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = tableItemArray[n2];
            if (item.getChecked()) {
                addPriv.add(item.getText());
            }
            ++n2;
        }
    }

    private List<String> computePrivileges(IProject project) {
        Set<String> permissions;
        try {
            permissions = Utils.gatherPermissionsFromSources(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        List<String> privileges = this.getTizenPrivileges(permissions);
        return privileges;
    }

    private List<String> getTizenPrivileges(Set<String> permissions) {
        ArrayList<String> privilegeSet = new ArrayList<String>();
        Map<String, List<String>> privilegeMap = InterfaceMappingProvider.getInstance().getPrivilegesMapping();
        for (String permission : permissions) {
            List<String> privileges = privilegeMap.get(permission);
            if (privileges == null) continue;
            privilegeSet.addAll(privileges);
        }
        return privilegeSet;
    }

    private void updateControls() {
        this.updateApplyButton();
    }

    public boolean isValid() {
        this.setErrorMessage(null);
        return true;
    }

    public boolean performOk() {
        final IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        INaclPreferences prefs = NaclPreferenceActivator.getDefault().getNaclPreferences();
        ArrayList<String> addPriv = new ArrayList<String>();
        ArrayList<String> removedPriv = new ArrayList<String>();
        this.getModifiedPriviligesList(addPriv, removedPriv);
        prefs.setPrivilegesList(project, addPriv, removedPriv);
        Job job = new Job(Messages.TizenPrivilegesPage_JobName){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    project.build(10, monitor);
                    WidgetExporter.updateConfigXml("config.xml", project, !project.getActiveBuildConfig().getName().toLowerCase().contains("release"));
                }
                catch (CoreException ex) {
                    Logger.getGlobal().log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }
}

