/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.toolchain;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCommandGenerator;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildfileMacroSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;

public class LibraryPathGenerator
implements IOptionCommandGenerator {
    private static final String PATTERN_TO_REPLACE = "${ConfigName}";
    private static final String PREFIX = "-L";
    private static final String DEBUG_CONFIG = "Debug";
    private static final String RELEASE_CONFIG = "Release";

    public String generateCommand(IOption option, IVariableSubstitutor macroSubstitutor) {
        if (option == null || macroSubstitutor == null) {
            return null;
        }
        if (macroSubstitutor instanceof BuildfileMacroSubstitutor) {
            String configType;
            BuildfileMacroSubstitutor bfms = (BuildfileMacroSubstitutor)macroSubstitutor;
            IConfiguration config = bfms.getConfiguration();
            if (config == null) {
                return null;
            }
            IBuildObjectProperties props = config.getBuildProperties();
            if (props == null) {
                return null;
            }
            IBuildProperty buildType = props.getProperty("org.eclipse.cdt.build.core.buildType");
            if (buildType == null) {
                return null;
            }
            String buildTypeString = buildType.getValue().getName();
            if (buildTypeString == null) {
                return null;
            }
            StringBuilder cmd = new StringBuilder();
            if (buildTypeString.toLowerCase().contains("debug")) {
                configType = DEBUG_CONFIG;
            } else if (buildTypeString.toLowerCase().contains("release")) {
                configType = RELEASE_CONFIG;
            } else {
                return null;
            }
            if (option.getValue() instanceof ArrayList) {
                ArrayList list = (ArrayList)option.getValue();
                for (Object elem : list) {
                    if (!(elem instanceof String)) continue;
                    String dir = (String)elem;
                    cmd.append(PREFIX);
                    cmd.append('\"');
                    cmd.append(dir.replace(PATTERN_TO_REPLACE, configType));
                    cmd.append('\"');
                    cmd.append(' ');
                }
            }
            return cmd.toString();
        }
        return null;
    }
}

