/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.privileges;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.web.tv.sec.nacl.builder.Utils;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;
import org.xml.sax.SAXException;

public class ConfigXmlChangeReporter
implements IResourceChangeListener {
    private final String fileNameToWatch;

    public ConfigXmlChangeReporter(String fileNameToWatch) {
        this.fileNameToWatch = fileNameToWatch;
    }

    public void resourceChanged(IResourceChangeEvent changeEvt) {
        try {
            changeEvt.getDelta().accept((IResourceDeltaVisitor)new ConfigXmlChangeHandler(this.fileNameToWatch));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static class ConfigXmlChangeHandler
    implements IResourceDeltaVisitor {
        private final String fileToWatch;

        ConfigXmlChangeHandler(String fileName) {
            this.fileToWatch = fileName;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getName().equals(this.fileToWatch)) {
                IProject project = resource.getProject();
                TreeSet<String> privileges = new TreeSet<String>();
                try {
                    Utils.loadPrivilegesFromConfigXml(project.getFile(resource.getName()).getLocation().toString(), privileges);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    e.printStackTrace();
                    throw new CoreException((IStatus)new Status(2, "org.tizen.web.tv.sec.nacl.builder", e.getMessage()));
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
                INaclPreferences prefs = NaclPreferenceActivator.getDefault().getNaclPreferences();
                prefs.setPrivilegesList(project, privileges, new ArrayList());
                return false;
            }
            return true;
        }
    }
}

