/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.debug;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.tizen.web.tv.sec.nacl.debug.Messages;
import org.tizen.web.tv.sec.nacl.launch.Utils;

public class NaclDebugLaunchDelegate
extends GdbLaunchDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String host = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.HOST", "localhost");
        int port = Integer.parseInt(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "4014"));
        this.waitForServer(host, port, monitor);
        super.launch(configuration, mode, launch, monitor);
    }

    private static boolean isServerAvailable(String host, int port) {
        try {
            Socket sock = new Socket(host, port);
            sock.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleepFor(int miliseconds) {
        Object mutex;
        Object object = mutex = new Object();
        synchronized (object) {
            try {
                mutex.wait(miliseconds);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void waitForServer(String host, int port, IProgressMonitor monitor) {
        MessageConsole console = Utils.getConsole((String)org.tizen.web.tv.sec.nacl.launch.Messages.Common_launchConsoleLabel);
        MessageConsoleStream out = console.newMessageStream();
        out.println(Messages.NaclDebugLaunchDelegate_Waiting);
        while (!monitor.isCanceled() && !NaclDebugLaunchDelegate.isServerAvailable(host, port)) {
            NaclDebugLaunchDelegate.sleepFor(1000);
            out.println(NLS.bind((String)Messages.NaclDebugLaunchDelegate_Retrying, (Object)host, (Object)port));
        }
        out.println(Messages.NaclDebugLaunchDelegate_Started);
        NaclDebugLaunchDelegate.sleepFor(1000);
    }
}

