/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.adapter.launch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.Version;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.common.sdb.command.receiver.CommandOutputReceiver;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.service.ISyncProgressMonitor;
import org.tizen.sdblib.service.NullSyncProgressMonitor;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;
import org.tizen.web.tv.sec.launch.util.SecTVWRTCommandUtil;
import org.tizen.web.tv.sec.nacl.adapter.launch.Messages;
import org.tizen.web.zimlaunch.resource.TizenDeviceInfo;
import org.tizen.web.zimlaunch.resource.TizenWebAppInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.util.CommandLauncher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Emulator {
    private IDevice device = null;
    private CommandLauncher launcher = null;
    private final SecTVWRTCommandUtil util = new SecTVWRTCommandUtil();
    private final ConsoleManager console = new ConsoleManager(Messages.Emulator_launchConsole, true);
    private final CommandOutputReceiver receiver = new PkgCmdReceiver((ITizenConsoleManager)this.console);
    private SdbCommand sdbCommand = null;

    public static List<EmulatorInfo> list() {
        IDevice[] sdbDevices;
        ArrayList<EmulatorInfo> devices = new ArrayList<EmulatorInfo>();
        IDevice[] iDeviceArray = sdbDevices = SmartDevelopmentBridge.getBridge().getDevices();
        int n = sdbDevices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            String name = device.getDeviceName();
            String serial = device.getSerialNumber();
            devices.add(new EmulatorInfo(serial, name));
            ++n2;
        }
        return devices;
    }

    public static EmulatorInfo getSelectedEmulator() {
        IDevice dev = ConnectionPlugin.getDefault().getCurrentDevice();
        if (dev != null) {
            return new EmulatorInfo(dev.getSerialNumber(), dev.getDeviceName());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getWidgetId(File widget) throws IOException, SAXException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            String string;
            ZipInputStream zis = new ZipInputStream(new FileInputStream(widget));
            try {
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.getName().equals("config.xml")) break;
                }
                if (entry == null) {
                    throw new IOException(Messages.Emulator_configNotFoundError);
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                try {
                    Document doc = factory.newDocumentBuilder().parse(zis);
                    Element root = doc.getDocumentElement();
                    NodeList nodes = root.getElementsByTagNameNS("http://tizen.org/ns/widgets", "application");
                    int len = nodes.getLength();
                    int i = 0;
                    while (i < len) {
                        NamedNodeMap attrs = nodes.item(i).getAttributes();
                        Node idNode = attrs.getNamedItem("id");
                        if (idNode != null) {
                            string = idNode.getNodeValue();
                            return string;
                        }
                        ++i;
                    }
                    throw new IOException(Messages.Emulator_idNotFoundError);
                }
                catch (ParserConfigurationException ex) {
                    Logger.getGlobal().log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                    throw new IOException(Messages.Emulator_idNotFoundError);
                }
            }
            finally {
                if (zis == null) return string;
                zis.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private ZimLaunchResource resourceFromWidget(File widget) throws IOException, SAXException {
        TizenDeviceInfo devInfo = new TizenDeviceInfo(this.device);
        TizenWebAppInfo appInfo = new TizenWebAppInfo(null);
        appInfo.setAppFile(widget);
        String id = Emulator.getWidgetId(widget);
        int dotPos = id.indexOf(".");
        if (dotPos < 0) {
            dotPos = id.length();
        }
        String packageId = id.substring(0, dotPos);
        appInfo.setAppID(id);
        appInfo.setAppPackageID(packageId);
        ZimLaunchResource resource = new ZimLaunchResource(devInfo, appInfo, "run");
        return resource;
    }

    public Emulator() throws Exception {
        this.initialize(ConnectionPlugin.getDefault().getCurrentDevice());
    }

    public Emulator(String serial) throws Exception {
        IDevice[] devices;
        IDevice[] iDeviceArray = devices = SmartDevelopmentBridge.getBridge().getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice dev = iDeviceArray[n2];
            if (dev.getSerialNumber().equals(serial)) {
                this.initialize(dev);
                return;
            }
            ++n2;
        }
        throw new Exception(Messages.Emulator_errorConnecting);
    }

    private void initialize(IDevice dev) throws Exception {
        this.device = dev;
        this.launcher = new CommandLauncher(dev);
        this.sdbCommand = new SdbCommand(dev, (ITizenConsoleManager)this.console, this.receiver);
        String versionStr = this.device.getPlatformInfo().getPlatformVersion();
        Logger.getGlobal().fine("Platform version: " + versionStr);
    }

    public boolean push(File source, String desc) throws Exception {
        if (!source.exists()) {
            throw new FileNotFoundException();
        }
        ZimLaunchResource resource = this.resourceFromWidget(source);
        String cmd = this.util.getCommand("MK_DIR_COMMAND", desc, resource);
        this.sdbCommand.runCommand(cmd);
        this.console.print(Messages.Emulator_uploadingWidget);
        SyncService service = this.device.getSyncService();
        SyncResult result = service.push(new File[]{source}, this.device.getFileEntry(desc), (ISyncProgressMonitor)NullSyncProgressMonitor.getInstance(), this.launcher.getTimeout());
        if (!result.isOk()) {
            this.console.println(Messages.Emulator_failed);
            return false;
        }
        this.console.println(Messages.Emulator_success);
        return true;
    }

    public String install(File file) throws Exception {
        String cmd;
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        String destDir = TizenPlatformConstants.getAppTmpDirectory((IDevice)this.device);
        String id = Emulator.getWidgetId(file);
        if (!this.push(file, destDir)) {
            throw new Exception(NLS.bind((String)Messages.Emulator_widgetTransferError, (Object)this.device.getDeviceName()));
        }
        ZimLaunchResource resource = this.resourceFromWidget(file);
        if (this.isInstalled(resource)) {
            cmd = this.util.getCommand("UNINSTALL_COMMAND", "", resource);
            this.sdbCommand.runCommand(cmd);
        }
        cmd = this.util.getCommand("INSTALL_COMMAND", "", resource);
        this.sdbCommand.runCommand(cmd);
        String widgetFilePath = String.valueOf(destDir) + File.separator + file.getName();
        String rmcmd = this.util.getCommand("RM_FILE_COMMAND", widgetFilePath, resource);
        this.console.println("Removing the widget file: " + widgetFilePath);
        this.sdbCommand.runCommand(rmcmd);
        if (!this.isInstalled(resource)) {
            throw new Exception(Messages.Emulator_installFailedError);
        }
        return id;
    }

    private String getQueryCommand(ZimLaunchResource resource) throws Exception {
        return this.util.getCommand("QUERY_COMMAND", "", resource);
    }

    private String getAppId(ZimLaunchResource resource) throws Exception {
        Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)this.device));
        if (version.isSameOrBiggerThanVersion3()) {
            return "'" + resource.getAppinfo().getAppID() + "'";
        }
        return resource.getAppinfo().getAppPackageID();
    }

    private boolean isInstalled(ZimLaunchResource resource) throws Exception {
        String cmd = this.getQueryCommand(resource);
        this.launcher.runCommand(cmd, false);
        String result = this.launcher.getResultString();
        String[] parts = result.split("\\s+");
        String appId = this.getAppId(resource);
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (appId.equals(str)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void launch(File widget) throws Exception {
        String cmd;
        ZimLaunchResource resource = this.resourceFromWidget(widget);
        if (this.isRunning(resource)) {
            cmd = this.util.getCommand("KILL_COMMAND", "", resource);
            this.sdbCommand.runCommand(cmd);
        }
        cmd = this.util.getCommand("VD_RUN_LAUNCH_COMMAND", "", resource);
        this.sdbCommand.runCommand(cmd);
    }

    private boolean isRunning(ZimLaunchResource resource) throws Exception {
        String cmd = this.util.getCommand("RUN_CHECK_COMMAND", null, resource);
        this.launcher.runCommand(cmd, false);
        String output = this.launcher.getResultString();
        String str = String.valueOf(resource.getAppinfo().getAppPackageID()) + " is Running";
        return output.contains(str);
    }

    public void setDebugMode(boolean enabled) throws Exception {
        Logger.getGlobal().info("Running, setting nacl debug flag to " + enabled);
        String cmd = "0 naclDebug" + (enabled ? "On" : "Off");
        this.launcher.runCommand(cmd, false);
    }

    public void createForward(File widget, int localPort, int remotePort) throws IOException, SAXException, Exception {
        ZimLaunchResource resource = this.resourceFromWidget(widget);
        String appId = this.getAppId(resource);
        this.launcher.createForward(appId, localPort, remotePort);
    }

    public void removeForward(File widget, int localPort, int remotePort) throws Exception {
        ZimLaunchResource resource = this.resourceFromWidget(widget);
        String appId = this.getAppId(resource);
        this.launcher.removeForward(appId, localPort, remotePort);
    }

    public static class EmulatorInfo {
        public final String serial;
        public final String name;

        private EmulatorInfo(String serial, String name) {
            this.serial = serial;
            this.name = name;
        }
    }
}

