/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.preferences;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.tizen.web.tv.sec.nacl.common.SystemInfo;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;

class NaclPreferences
implements INaclPreferences {
    private static final String NACL_PREFERENCES_NODE = "org.tizen.web.tv.sec.nacl";
    private static final String PRIVILEGES_DELIMITER = ",";

    NaclPreferences() {
    }

    @Override
    public String getNaClToolchain(IProject project) {
        Preferences prefs = this.getProjectPreferences(project);
        return prefs.get("pepperVersion", "");
    }

    @Override
    public String[] getNaClToolchains() {
        INaclPreferences naclPreferences = NaclPreferenceActivator.getDefault().getNaclPreferences();
        Map<String, Path> pepperVersions = naclPreferences.getPepperVersions();
        if (pepperVersions != null && !pepperVersions.isEmpty()) {
            return pepperVersions.keySet().toArray(new String[0]);
        }
        return new String[0];
    }

    @Override
    public Map<String, Path> getPepperVersions() {
        String naclRootPath = NaclPreferenceActivator.getDefault().getPreferenceStore().getString("nacl.sdk_root");
        HashMap<String, Path> versions = new HashMap<String, Path>();
        File[] fileArray = NaclPreferenceActivator.listPepperDirectories(naclRootPath);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            versions.put(dir.getName(), dir.toPath());
            ++n2;
        }
        return versions;
    }

    @Override
    public boolean getPrivilegesList(IProject project, List<String> selectedPrivileges, List<String> removedPrivileges) {
        Preferences preferences = this.getProjectPreferences(project);
        if (preferences != null) {
            String privileges = preferences.get("addPrivileges", "");
            selectedPrivileges.addAll(Arrays.asList(StringUtils.split((String)privileges, (String)PRIVILEGES_DELIMITER)));
            privileges = preferences.get("removePrivileges", "");
            removedPrivileges.addAll(Arrays.asList(StringUtils.split((String)privileges, (String)PRIVILEGES_DELIMITER)));
            return true;
        }
        return false;
    }

    @Override
    public Preferences getProjectPreferences(IProject project) {
        if (project == null) {
            return null;
        }
        ProjectScope projectScope = new ProjectScope(project);
        return projectScope.getNode(NACL_PREFERENCES_NODE);
    }

    @Override
    public Preferences getProjectPreferences(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return this.getProjectPreferences(project);
    }

    @Override
    public Path getToolchainBinPath(Path pepperDir, String toolchainVariant) {
        StringBuilder sb = new StringBuilder();
        sb.append(SystemInfo.getOsName());
        sb.append("_" + toolchainVariant + "/bin");
        return Paths.get(pepperDir.toString(), "toolchain", sb.toString());
    }

    @Override
    public boolean isCustomNaClToolchainSet(IProject project) {
        Preferences prefs = this.getProjectPreferences(project);
        return prefs.getBoolean("customPepperPath", false);
    }

    @Override
    public boolean isNaClToolchainPathSet(IProject project) {
        Preferences prefs = this.getProjectPreferences(project);
        String toolchainPath = prefs.get("pepperVersion", "");
        return toolchainPath != null && !toolchainPath.equals("");
    }

    @Override
    public boolean isValidPNaClToolchainFolder(String stringPath) {
        Path path;
        try {
            path = Paths.get(stringPath, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            Logger.getGlobal().severe("failed to convert " + stringPath + " to path");
            return false;
        }
        Path fileName = path.getFileName();
        if (fileName == null) {
            Logger.getGlobal().severe("cannot convert path: " + stringPath + " to a file");
            return false;
        }
        return fileName.toString().toLowerCase().startsWith("pepper_");
    }

    @Override
    public void setNaClToolchain(IProject project, String pepperVersion, boolean isCustomToolchainSet) {
        Preferences prefs = this.getProjectPreferences(project);
        prefs.put("pepperVersion", pepperVersion);
        prefs.putBoolean("customPepperPath", isCustomToolchainSet);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getGlobal().severe("failed to set NaCl toolchain in project");
        }
    }

    @Override
    public boolean setPrivilegesList(IProject project, Collection<String> selectedPrivileges, Collection<String> removedPrivileges) {
        Preferences preferences = this.getProjectPreferences(project);
        if (preferences != null) {
            String priv = StringUtils.join(selectedPrivileges, (String)PRIVILEGES_DELIMITER);
            preferences.put("addPrivileges", priv);
            priv = StringUtils.join(removedPrivileges, (String)PRIVILEGES_DELIMITER);
            preferences.put("removePrivileges", priv);
            try {
                preferences.flush();
            }
            catch (BackingStoreException ex) {
                Logger.getGlobal().log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                ex.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }
}

