/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.preferences.toolchainmgr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.tizen.web.tv.sec.nacl.common.SystemInfo;
import org.tizen.web.tv.sec.nacl.common.plugin.UiUtils;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.DownloadManager;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.IToolchain;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.Messages;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.ToolchainVerifier;

public class NaClToolchain
implements IToolchain {
    private final String name;
    private URL url;
    private String version;
    private String hash = "";
    private File toolchainsRootDirectory;
    private File compressedToolchainFile;
    private boolean installing;
    private boolean verifying;
    private boolean removing;
    private boolean modified;
    private static Runnable onStatusChange = null;
    private IProgressMonitor currentOperationMonitor = null;

    public String toString() {
        return String.format("Name: %s\nURL: %s\nVersion: %s\nLocation: %s\nStatus: %s\nMD5 sum: %s", new Object[]{this.name, this.url, this.version, this.toolchainsRootDirectory, this.getStatus(), this.hash});
    }

    public NaClToolchain(String name, String url, String version, String location, String hash) {
        this.name = name;
        this.installing = false;
        this.removing = false;
        this.modified = false;
        this.verifying = false;
        try {
            this.update(url, version, location, hash);
        }
        catch (UpdateFailure updateFailure) {
            return;
        }
    }

    public void update(String url, String version, String location, String hash) throws UpdateFailure {
        URL newUrl;
        try {
            newUrl = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            newUrl = null;
        }
        if (this.installing && this.updated(this.url, newUrl)) {
            throw new UpdateFailure("The URL cannot be updated while the toolchain is being installed.");
        }
        this.url = newUrl;
        this.version = version;
        File newToolchainsRootDir = new File(location);
        if ((this.installing || this.removing) && !newToolchainsRootDir.equals(this.toolchainsRootDirectory)) {
            throw new UpdateFailure("The root installation directory cannot be updated while the toolchain is being installed or removed.");
        }
        this.toolchainsRootDirectory = newToolchainsRootDir;
        this.compressedToolchainFile = newUrl != null ? new File(String.valueOf(this.toolchainsRootDirectory.getAbsolutePath()) + File.separator + new File(newUrl.getFile()).getName()) : null;
        if (this.installing && !hash.equals(this.hash)) {
            throw new UpdateFailure("The hash cannot be updated while the toolchain is being installed.");
        }
        this.hash = hash;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public File getLocation() {
        return this.toolchainsRootDirectory;
    }

    @Override
    public File getPath() {
        return new File(this.getLocation() + File.separator + this.getName());
    }

    @Override
    public Status getStatus() {
        if (this.isRemoving()) {
            return Status.REMOVING;
        }
        if (this.isInstalling()) {
            return Status.INSTALLING;
        }
        if (this.isVeryfing()) {
            return Status.VERYFING;
        }
        if (this.isInstalled() && this.isModified()) {
            if (!this.isUpdateAvailable()) {
                return Status.MODIFIED;
            }
            return Status.MODIFIED_UPDATE_AVAILABLE;
        }
        if (this.isUpdateAvailable()) {
            return Status.UPDATE_AVAILABLE;
        }
        if (this.isInstalled()) {
            return Status.INSTALLED;
        }
        return Status.NOT_INSTALLED;
    }

    public static String getInstalledVersion(String toolchainName, File toolchainsDirectory) {
        File[] versionFile = toolchainsDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.getName().equals(".version");
            }
        });
        if (versionFile != null && versionFile.length == 1 && versionFile[0].isFile() && versionFile[0].canRead()) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(versionFile[0]));){
                    return reader.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public static void setOnStatusChange(Runnable onStatusChangeCb) {
        onStatusChange = onStatusChangeCb;
    }

    private static void callOnStatusChange() {
        if (onStatusChange != null) {
            Display.getDefault().asyncExec(onStatusChange);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public IStatus install(IProgressMonitor monitor, boolean redownload, boolean reinstall) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 9[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void saveVersionFile() {
        File destination = null;
        if (this.version != null && !this.version.isEmpty()) {
            destination = new File(this.getToolchainDirectory().getAbsoluteFile() + File.separator + ".version");
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(destination));){
                    writer.write(this.version);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                System.err.println("Could not write to file " + destination);
                e.printStackTrace();
            }
        } else {
            System.err.println("Could not write to file " + destination);
        }
    }

    @Override
    public File getTargetFile() {
        return this.compressedToolchainFile;
    }

    @Override
    public IStatus remove(IProgressMonitor monitor) {
        IStatus status;
        if (this.removing || this.installing) {
            return org.eclipse.core.runtime.Status.CANCEL_STATUS;
        }
        Throwable throwable = null;
        Object var4_4 = null;
        try (OperationGuide guide = new OperationGuide(OperationStatus.OperationType.REMOVE, monitor);){
            status = DownloadManager.remove(this.getPath(), monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return status;
    }

    private boolean isInstalling() {
        return this.installing;
    }

    private boolean isRemoving() {
        return this.removing;
    }

    private boolean isModified() {
        assert (!this.installing);
        assert (!this.removing);
        assert (!this.verifying);
        return this.modified;
    }

    private boolean isVeryfing() {
        return this.verifying;
    }

    @Override
    public boolean isInstalled() {
        File toolchainDir = this.getToolchainDirectory();
        if (toolchainDir != null) {
            String compilerBinaryName = "pnacl-clang++" + (SystemInfo.isWindowsOs() ? ".bat" : "");
            Path compilerPath = Paths.get(INaclPreferences.getPnaclToolchainBinPath(toolchainDir.toPath()).toAbsolutePath().toString(), compilerBinaryName);
            return compilerPath.toFile().canRead();
        }
        return false;
    }

    @Override
    public IStatus verify(IProgressMonitor monitor) throws IOException, NoSuchAlgorithmException {
        if (!this.isInstalled() || this.isVeryfing() || this.isInstalling() || this.isRemoving() || this.hash == null || this.hash.isEmpty()) {
            return org.eclipse.core.runtime.Status.CANCEL_STATUS;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (OperationGuide guide = new OperationGuide(OperationStatus.OperationType.VERIFY, monitor);){
                ToolchainVerifier verifier = new ToolchainVerifier();
                this.modified = !verifier.verify(this.hash, this.getToolchainDirectory(), monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
        return org.eclipse.core.runtime.Status.OK_STATUS;
    }

    private boolean isUpdateAvailable() {
        if (!this.isInstalled()) {
            return false;
        }
        File toolchainDir = this.getToolchainDirectory();
        if (toolchainDir == null) {
            return false;
        }
        String installedVersion = NaClToolchain.getInstalledVersion(this.name, toolchainDir);
        return installedVersion != null && this.version.compareTo(installedVersion) > 0;
    }

    private File getToolchainDirectory() {
        File[] dirsFound = this.toolchainsRootDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory() && path.getName().equals(NaClToolchain.this.name);
            }
        });
        if (dirsFound != null && dirsFound.length == 1) {
            return dirsFound[0];
        }
        return null;
    }

    private boolean updated(Object oldObj, Object newObj) {
        if (oldObj == null && newObj != null) {
            return true;
        }
        if (oldObj != null && newObj == null) {
            return true;
        }
        if (oldObj == null && newObj == null) {
            return false;
        }
        return !oldObj.equals(newObj);
    }

    @Override
    public void cancelOperation() {
        if (this.currentOperationMonitor != null) {
            this.currentOperationMonitor.setCanceled(true);
        }
    }

    @Override
    public int compareTo(IToolchain other) {
        return this.getName().compareTo(other.getName());
    }

    public static class MsgDialogCaller
    implements UiUtils.VarArgFunction<String, Object> {
        private boolean response = false;
        private final int messageType;

        public MsgDialogCaller(int messageType) {
            this.messageType = messageType;
        }

        public boolean getResponse() {
            return this.response;
        }

        public Object function(String ... params) {
            if (params.length != 2) {
                return null;
            }
            switch (this.messageType) {
                case 5: {
                    this.response = MessageDialog.openConfirm(null, (String)params[0], (String)params[1]);
                    break;
                }
                case 1: {
                    MessageDialog.openError(null, (String)params[0], (String)params[1]);
                    this.response = true;
                    break;
                }
                case 2: {
                    MessageDialog.openInformation(null, (String)params[0], (String)params[1]);
                    this.response = true;
                    break;
                }
                case 3: {
                    this.response = MessageDialog.openQuestion(null, (String)params[0], (String)params[1]);
                    break;
                }
                case 4: {
                    MessageDialog.openWarning(null, (String)params[0], (String)params[1]);
                    this.response = true;
                    break;
                }
                default: {
                    this.response = MessageDialog.open((int)2, null, (String)params[0], (String)params[1], (int)0);
                }
            }
            return this.response;
        }
    }

    private class OperationGuide
    implements AutoCloseable {
        private final OperationStatus.OperationType operationType;

        public OperationGuide(OperationStatus.OperationType operationType, IProgressMonitor monitor) {
            this.operationType = operationType;
            NaClToolchain.this.currentOperationMonitor = monitor;
            switch (operationType) {
                case DOWNLOAD: {
                    NaClToolchain.this.installing = true;
                    break;
                }
                case REMOVE: {
                    NaClToolchain.this.removing = true;
                    break;
                }
                case VERIFY: {
                    NaClToolchain.this.verifying = true;
                }
            }
            NaClToolchain.callOnStatusChange();
        }

        @Override
        public void close() {
            NaClToolchain.this.currentOperationMonitor = null;
            switch (this.operationType) {
                case DOWNLOAD: {
                    NaClToolchain.this.installing = false;
                    break;
                }
                case REMOVE: {
                    NaClToolchain.this.removing = false;
                    break;
                }
                case VERIFY: {
                    NaClToolchain.this.verifying = false;
                }
            }
            NaClToolchain.callOnStatusChange();
        }
    }

    public static class OperationStatus
    extends org.eclipse.core.runtime.Status {
        private final OperationType operationType;

        public OperationStatus(int severity, String message, OperationType operationType) {
            super(severity, "org.tizen.web.tv.sec.nacl.preferences", message);
            this.operationType = operationType;
        }

        public OperationType getOperationType() {
            return this.operationType;
        }

        public static enum OperationType {
            DOWNLOAD,
            UNZIP,
            REMOVE,
            VERIFY;

        }
    }

    public static enum Status {
        NOT_INSTALLED(Messages.NaClToolchain_NotInstalled),
        INSTALLING(Messages.NaClToolchain_BackgroundInstallation),
        INSTALLED(Messages.NaClToolchain_ReadyToUse),
        UPDATE_AVAILABLE(Messages.NaClToolchain_UpdateAvailable),
        REMOVING(Messages.NaClToolchain_Removing),
        VERYFING(Messages.NaClToolchain_Verification),
        MODIFIED(Messages.NaClToolchain_Modified),
        MODIFIED_UPDATE_AVAILABLE(Messages.NaClToolchain_ModifiedUpdateAvailable);

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }

    public static class UpdateFailure
    extends Exception {
        private static final long serialVersionUID = 8323276409411623449L;

        public UpdateFailure(String message) {
            super(message);
        }
    }
}

