/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.supportenabler;

import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.tizen.web.tv.sec.nacl.common.plugin.UiUtils;
import org.tizen.web.tv.sec.nacl.supportenabler.Messages;
import org.tizen.web.tv.sec.nacl.supportenabler.NaclToolchainContent;

public class NaClToolchainDialog
extends TitleAreaDialog {
    private static final String SET_NACL_TOOLCHAIN_FOR_ALL_MODULES_TEXT = Messages.NaClToolchainDialog_SET_NACL_TOOLCHAIN_TEXT;
    private Composite naclToolchainContainer;
    private Button okButton;
    private final NaclToolchainContent content = new NaclToolchainContent();

    public NaClToolchainDialog(Shell parentShell) {
        super(parentShell);
        this.content.setEnableToolchainConfirmation(new Consumer<Boolean>(){

            @Override
            public void accept(Boolean shouldEnableOk) {
                try {
                    if (NaClToolchainDialog.this.okButton != null) {
                        NaClToolchainDialog.this.okButton.setEnabled(shouldEnableOk.booleanValue());
                    }
                }
                catch (IllegalArgumentException | SWTException throwable) {
                    return;
                }
            }
        });
        this.setHelpAvailable(false);
    }

    protected void cancelPressed() {
        try {
            this.content.cancelVerification();
        }
        catch (InterruptedException | OperationCanceledException e) {
            System.err.println("Failed to cancel the toolchain's verification: " + e.getMessage());
        }
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(SET_NACL_TOOLCHAIN_FOR_ALL_MODULES_TEXT);
        this.naclToolchainContainer = (Composite)super.createDialogArea(parent);
        this.content.implementContent(this.naclToolchainContainer);
        return this.naclToolchainContainer;
    }

    protected Point getInitialSize() {
        return new Point(650, 525);
    }

    public String getSelectedToolchain() {
        return this.content.getSelectedToolchain();
    }

    public boolean isCustomToolchainSet() {
        return this.content.isCustomToolchainSet();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        try {
            this.content.cancelVerification();
        }
        catch (InterruptedException | OperationCanceledException e) {
            System.err.println("Failed to cancel the toolchain's verification: " + e.getMessage());
        }
        super.okPressed();
    }

    public class NaClToolchainDialogErrorChecker
    implements UiUtils.IErrorChecker {
        private final LinkedHashSet<String> errorSet = new LinkedHashSet();
        private boolean okButtonEnabled = false;

        public boolean checkForError(String errorString, boolean statement) {
            if (statement) {
                this.errorSet.add(errorString);
            } else {
                this.errorSet.remove(errorString);
            }
            if (!this.errorSet.isEmpty()) {
                String error = statement ? errorString : (String)this.errorSet.iterator().next();
                NaClToolchainDialog.this.setMessage(error, 3);
                this.okButtonEnabled = false;
                if (NaClToolchainDialog.this.okButton != null) {
                    NaClToolchainDialog.this.okButton.setEnabled(this.okButtonEnabled);
                }
                return statement;
            }
            NaClToolchainDialog.this.setMessage(null);
            this.okButtonEnabled = true;
            if (NaClToolchainDialog.this.okButton != null) {
                NaClToolchainDialog.this.okButton.setEnabled(this.okButtonEnabled);
            }
            return statement;
        }
    }
}

