/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.project_wizards;

import java.awt.Point;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.nacl.project_wizards.PluginConfig;

public class ProjectData {
    public BasicInfo basicProjectInfo = new BasicInfo();
    public ContentData contentData = new ContentData();
    public ConfigurationData configurationData = new ConfigurationData();

    public class BasicInfo {
        public String projectName;
        public String projectPath;
        public boolean itsDefaultPath;
        public NativeLanguage language = NativeLanguage.UNKNOWN;
        public String toolchain;
        public boolean hasToolchainPath;
    }

    public static enum CompilerType {
        PNACL_C("pnacl_c", "org.tizen.web.tv.sec.nacl.builder.toolchain.compiler.c.other"),
        PNACL_CPP("pnacl_cpp", "org.tizen.web.tv.sec.nacl.builder.toolchain.compiler.cpp.other"),
        GLIBC_C("glibc_c", "org.tizen.web.tv.sec.nacl.builder.toolchain.compiler.c.glibc.other"),
        GLIBC_CPP("glibc_cpp", "org.tizen.web.tv.sec.nacl.builder.toolchain.compiler.cpp.glibc.other");

        private final String name;
        private final String flagsOptionsId;

        private CompilerType(String name, String flagsOptionsId) {
            this.name = name;
            this.flagsOptionsId = flagsOptionsId;
        }

        public String getId() {
            return this.flagsOptionsId;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class CompilersOptions
    extends TreeMap<CompilerType, Set<String>> {
        private static final long serialVersionUID = -2561056636554764863L;
        private String lastStoredString = null;

        CompilersOptions() {
        }

        public String add(CompilerType key, String value) {
            if (!this.containsKey((Object)key)) {
                TreeSet<String> set = new TreeSet<String>();
                set.add(value);
                this.lastStoredString = value;
                this.put(key, set);
                return null;
            }
            ((Set)this.get((Object)key)).add(value);
            return this.lastStoredString;
        }
    }

    public class ConfigurationData {
        public int screenResolutionIndex;
        public boolean isPluginHidden;
        public Point pluginPosition;
        public int pluginWidth;
        public int pluginHeight;
    }

    public class ContentData {
        public ProjectType projectType;
        public String projectSource;
        public String headerFilePath;
        public String sourceFilePath;
        public List<String> requiredLibraries;
        public List<PluginConfig.ETemplateInterfaces> listTemplates = null;
    }

    public static enum ProjectType {
        Empty,
        Template,
        Example;

    }
}

