/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.addnaclmodule.mergetools;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.tizen.web.tv.sec.nacl.common.XMLTools;
import org.tizen.web.tv.sec.nacl.common.plugin.NaClModuleUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TprojectFileEditor {
    public static void excludeNonBinPaths(IProject moduleProject, IProject tizenProject, Validator validator, FileFilter moduleArtifactsFilter) {
        if (!validator.validated(tizenProject, moduleProject)) {
            Logger.getGlobal().severe("Cannot update .tproject since the specified module project is not a module of the specified tizen project");
            return;
        }
        String tizenProjectPathWithSeparator = String.valueOf(NaClModuleUtils.getTizenProjectBasePath((IProject)tizenProject)) + File.separator;
        String tprojectFilePath = String.valueOf(tizenProjectPathWithSeparator) + ".tproject";
        Document document = XMLTools.parseFile((File)new File(tprojectFilePath));
        if (document == null) {
            Logger.getGlobal().severe("Cannot parse as xml " + tprojectFilePath);
            return;
        }
        NodeList nodeList = document.getElementsByTagName("blacklist");
        if (nodeList.getLength() != 1) {
            Logger.getGlobal().severe("Cannot get blacklist item from .tproject xml or the number of the elements is different than one");
            return;
        }
        String moduleBasePath = NaClModuleUtils.getNaClModuleBasePath((IProject)moduleProject);
        Node blackListNode = nodeList.item(0);
        try {
            Files.walk(Paths.get(moduleBasePath, new String[0]), FileVisitOption.FOLLOW_LINKS).forEach(filePath -> {
                File file = filePath.toFile();
                String absoluteFilePath = file.getAbsolutePath();
                String relativePath = absoluteFilePath.replace(tizenProjectPathWithSeparator, "");
                if (moduleArtifactsFilter.accept(file)) {
                    return;
                }
                Element element = document.createElement("path");
                element.setAttribute("value", relativePath);
                element.setAttribute("type", file.isDirectory() ? "dir" : "file");
                NodeList childNodes = blackListNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    if (childNodes.item(i).isEqualNode(element)) {
                        return;
                    }
                    ++i;
                }
                blackListNode.appendChild(element);
            });
        }
        catch (IOException iOException) {
            Logger.getGlobal().severe("File walking to get files for .tproject excludes failed. ");
            return;
        }
        if (!XMLTools.saveToFile((Document)document, (String)tprojectFilePath)) {
            Logger.getGlobal().severe("Saving the changed .tproject file failed");
        }
    }

    public static interface Validator {
        public boolean validated(IProject var1, IProject var2);
    }
}

