/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.addnaclmodule.wizards;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.web.tv.sec.nacl.addnaclmodule.wizards.Messages;
import org.tizen.web.tv.sec.nacl.addnaclmodule.wizards.NaclAddModuleWizardPage;
import org.tizen.web.tv.sec.nacl.common.GeneralTools;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;

public class NaclNameWizardPage
extends NaclAddModuleWizardPage {
    private static final int MODULE_NAME_MAX_LENGTH = 30;
    private static final String MODULE_NAME_REGEX = "[a-zA-Z0-9_]*";
    private static final String HEADER_EXT_C = "h";
    private static final String HEADER_EXT_CPP = "hpp";
    private static final String SOURCE_EXT_C = "c";
    private static final String SOURCE_EXT_CPP = "cpp";
    private static final Map<String, String> HEADER_EXTENSIONS = new TreeMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(NativeLanguage.CPP.toString(), NaclNameWizardPage.HEADER_EXT_CPP);
            this.put(NativeLanguage.C.toString(), NaclNameWizardPage.HEADER_EXT_C);
        }
    };
    private static final Map<String, String> SOURCE_EXTENSIONS = new TreeMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(NativeLanguage.CPP.toString(), NaclNameWizardPage.SOURCE_EXT_CPP);
            this.put(NativeLanguage.C.toString(), NaclNameWizardPage.SOURCE_EXT_C);
        }
    };
    private static final String DEFAULT_INC_DIR = "inc";
    private static final String DEFAULT_SRC_DIR = "src";
    private static final String DIALOG_CHOOSE_FILE_TEXT = Messages.NaclNameWizardPage_ChooseFile;
    private static final String SAMPLE_MODULE_NAME_TEXT = "module1";
    private static final String BROWSE_TEXT = Messages.NaclNameWizardPage_Browse;
    private static final String HEADER_FILE_TEXT = Messages.NaclNameWizardPage_HeaderFile;
    private static final String MODULE_NAME_TEXT = Messages.NaclNameWizardPage_ModuleName;
    private static final String SET_NEW_NACL_MODULE_NAME_TEXT = Messages.NaclNameWizardPage_SetUniqueModuleName;
    private static final String SET_NEW_NACL_MODULE_FILES_TEXT = Messages.NaclNameWizardPage_SetModuleSourceLocations;
    private static final String CHOOSE_NACL_MODULE_NAME_TEXT = Messages.NaclNameWizardPage_SetNameForModule;
    private static final String INCORRECT_MODULE_NAME_ERROR = String.valueOf(Messages.NaclNameWizardPage_ModuleNameMustOnlyContainCharacters) + "a-z, A-Z, 0-9, _" + Messages.NaclNameWizardPage_AndCantBeLongerThan + 30 + Messages.NaclNameWizardPage_Characters;
    private static final String HEADER_PATH_OUTSIDE_OF_PROJECT_ERROR = Messages.NaclNameWizardPage_HeaderPathOutsideOfProjectPath;
    private static final String SOURCE_PATH_OUTSIDE_OF_PROJECT_ERROR = Messages.NaclNameWizardPage_SourcePathOutsideOfProjectPath;
    private static final String NO_PROJECT_SELECTED_ERROR = Messages.NaclNameWizardPage_NoProjectSelectedSelectAndBrowse;
    private static final String MODULE_PROJECT_ALREADY_EXISTS = Messages.NaclNameWizardPage_NameAlreadyExists;
    private Shell shell;
    private IProject project = null;
    private String language = null;
    private Label lblHeaderFile;
    private Label lblSourceFile;
    private Button btnBrowserForHeader;
    private Button btnBrowseForSource;
    private Text txtModuleName;
    private Text txtHeaderFile;
    private Text txtSourceFile;

    public NaclNameWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(CHOOSE_NACL_MODULE_NAME_TEXT);
        this.setDescription(SET_NEW_NACL_MODULE_NAME_TEXT);
        this.project = ProjectUtils.getCurrentProject((ISelection)selection);
    }

    public Data getData() {
        return new Data(this.txtModuleName.getText(), this.txtHeaderFile.getText(), this.txtSourceFile.getText());
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(3, false);
        gl_container.verticalSpacing = 15;
        gl_container.marginHeight = 10;
        gl_container.marginRight = 20;
        gl_container.marginTop = 10;
        gl_container.marginLeft = 20;
        container.setLayout((Layout)gl_container);
        Label lblModuleName = new Label(container, 0);
        lblModuleName.setText(MODULE_NAME_TEXT);
        this.txtModuleName = new Text(container, 2048);
        GridData gd_txtModuleName = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_txtModuleName.widthHint = 217;
        this.txtModuleName.setLayoutData((Object)gd_txtModuleName);
        this.lblHeaderFile = new Label(container, 0);
        this.lblHeaderFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblHeaderFile.setText(HEADER_FILE_TEXT);
        this.txtHeaderFile = new Text(container, 2048);
        this.txtHeaderFile.setText(DEFAULT_INC_DIR + File.separator + SAMPLE_MODULE_NAME_TEXT);
        this.txtHeaderFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.shell = this.getShell();
        this.btnBrowserForHeader = new Button(container, 0);
        this.btnBrowserForHeader.setText(BROWSE_TEXT);
        this.lblSourceFile = new Label(container, 0);
        this.lblSourceFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblSourceFile.setText(Messages.NaclNameWizardPage_SourceFile);
        this.txtSourceFile = new Text(container, 2048);
        this.txtSourceFile.setText(DEFAULT_SRC_DIR + File.separator + SAMPLE_MODULE_NAME_TEXT);
        this.txtSourceFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnBrowseForSource = new Button(container, 0);
        this.btnBrowseForSource.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                String filePath = NaclNameWizardPage.this.selectFileInDialog(FileType.SOURCE);
                if (!filePath.isEmpty()) {
                    NaclNameWizardPage.this.txtSourceFile.setText(filePath);
                }
            }
        });
        this.btnBrowseForSource.setText(Messages.NaclNameWizardPage_Browse);
        this.txtModuleName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NaclNameWizardPage.this.updateModuleFilesPaths(NaclNameWizardPage.this.language, false);
            }
        });
        this.txtModuleName.setText(SAMPLE_MODULE_NAME_TEXT);
        this.btnBrowserForHeader.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                String filePath = NaclNameWizardPage.this.selectFileInDialog(FileType.HEADER);
                if (!filePath.isEmpty()) {
                    NaclNameWizardPage.this.txtHeaderFile.setText(filePath);
                }
            }
        });
    }

    public void updateModuleFilesPaths(String language, boolean forceExtensionsUpdate) {
        if (language == null) {
            return;
        }
        this.language = language;
        try {
            String moduleName = this.txtModuleName.getText();
            if (!moduleName.isEmpty()) {
                String headerExtension = GeneralTools.getFileExtension((String)this.txtHeaderFile.getText());
                if (headerExtension.isEmpty() || forceExtensionsUpdate) {
                    headerExtension = this.getHeaderExtension(language);
                }
                this.txtHeaderFile.setText(GeneralTools.replaceFileNameInPath((String)this.txtHeaderFile.getText(), (String)(String.valueOf(moduleName) + (headerExtension == null ? "" : "." + headerExtension))));
                String sourceExtension = GeneralTools.getFileExtension((String)this.txtSourceFile.getText());
                if (sourceExtension.isEmpty() || forceExtensionsUpdate) {
                    sourceExtension = this.getSourceExtension(language);
                }
                this.txtSourceFile.setText(GeneralTools.replaceFileNameInPath((String)this.txtSourceFile.getText(), (String)(String.valueOf(moduleName) + (sourceExtension == null ? "" : "." + sourceExtension))));
            }
            this.checkForError(MODULE_PROJECT_ALREADY_EXISTS, this.projectExists(moduleName));
            this.checkForError(INCORRECT_MODULE_NAME_ERROR, moduleName.equals("") || !moduleName.matches(MODULE_NAME_REGEX) || moduleName.length() > 30);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public void actionOnSampleChange(boolean isSample) {
        this.setDescription(String.valueOf(SET_NEW_NACL_MODULE_NAME_TEXT) + (isSample ? "" : SET_NEW_NACL_MODULE_FILES_TEXT));
        this.lblHeaderFile.setVisible(!isSample);
        this.lblSourceFile.setVisible(!isSample);
        this.txtHeaderFile.setVisible(!isSample);
        this.txtSourceFile.setVisible(!isSample);
        this.btnBrowserForHeader.setVisible(!isSample);
        this.btnBrowseForSource.setVisible(!isSample);
    }

    private boolean projectExists(String moduleName) {
        return ProjectUtils.existsProject((String)moduleName);
    }

    private String selectFileInDialog(FileType fileType) {
        String[] splitPaths;
        if (this.checkForError(NO_PROJECT_SELECTED_ERROR, this.project == null)) {
            return "";
        }
        String projectAbsolutePath = this.project.getLocation().toString();
        FileDialog dialog = new FileDialog(this.shell, 8192);
        dialog.setText(DIALOG_CHOOSE_FILE_TEXT);
        dialog.setFilterPath(projectAbsolutePath);
        dialog.setOverwrite(true);
        String dialogPath = dialog.open();
        if (dialogPath == null) {
            return "";
        }
        String errorMessage = fileType == FileType.HEADER ? HEADER_PATH_OUTSIDE_OF_PROJECT_ERROR : SOURCE_PATH_OUTSIDE_OF_PROJECT_ERROR;
        if (this.checkForError(errorMessage, (splitPaths = dialogPath.split(String.valueOf(projectAbsolutePath) + File.separator)).length != 2)) {
            return dialogPath;
        }
        return splitPaths[1];
    }

    private String getHeaderExtension(String language) {
        return HEADER_EXTENSIONS.get(language);
    }

    private String getSourceExtension(String language) {
        return SOURCE_EXTENSIONS.get(language);
    }

    public static class Data {
        public final String moduleName;
        public final String headerFilePath;
        public final String sourceFilePath;

        public Data(String moduleName, String headerFilePath, String sourceFilePath) {
            this.moduleName = moduleName;
            this.headerFilePath = headerFilePath;
            this.sourceFilePath = sourceFilePath;
        }
    }

    private static enum FileType {
        HEADER,
        SOURCE;

    }
}

