/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.project_wizards;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.osgi.service.prefs.Preferences;
import org.tizen.web.tv.sec.nacl.common.FileToCopy;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;
import org.tizen.web.tv.sec.nacl.project_wizards.Activator;
import org.tizen.web.tv.sec.nacl.project_wizards.PNaClHelper;
import org.tizen.web.tv.sec.nacl.project_wizards.ProjectData;

public class PluginConfig {
    private static PluginConfig pluginConfig;
    private static final String[] listSupportedPNaClLangs;
    private static final Point[] listScreenResolutionsInt;
    private static final String[] listScreenResolutions;
    private static final String bundleBaseFiles = "/templates/baseFiles/";
    private static final String bundleEmptyProject = "/templates/emptyProject/";
    private static final String bundleEmptyProjectCOnly = "/templates/emptyProjectCOnly/";
    private static final String bundleEmptyProjectCPPOnly = "/templates/emptyProjectCPPOnly/";
    public static final String bundleExamplesPath = "/templates/examples/";
    public static final String defaultNaClModuleName = "nacl_module";
    private static final String compilerSettingsFileName = "/settings";
    private static final String compilerNodeName = "compiler";
    private static final String compilerFlagsNodeName = "flags";
    private static final String librariesNodeName = "libraries";
    private final INaclPreferences naclPreferences = NaclPreferenceActivator.getDefault().getNaclPreferences();
    private String[] listExampleInC = null;
    private String[] listExampleInCpp = null;

    static {
        listSupportedPNaClLangs = new String[]{"C", "C++"};
        listScreenResolutionsInt = new Point[]{new Point(960, 540), new Point(1280, 720), new Point(1920, 1080)};
        listScreenResolutions = new String[listScreenResolutionsInt.length];
        int loop = 0;
        while (loop < listScreenResolutionsInt.length) {
            Point resolution = listScreenResolutionsInt[loop];
            PluginConfig.listScreenResolutions[loop] = String.valueOf(Integer.toString(resolution.x)) + "x" + Integer.toString(resolution.y);
            ++loop;
        }
    }

    public static PluginConfig getInstance() {
        if (pluginConfig == null) {
            pluginConfig = new PluginConfig();
        }
        return pluginConfig;
    }

    private PluginConfig() {
        ArrayList<String> tmpListExampleInC = new ArrayList<String>();
        ArrayList<String> tmpListExampleInCpp = new ArrayList<String>();
        if (!PNaClHelper.listDemos(bundleExamplesPath, tmpListExampleInC, tmpListExampleInCpp)) {
            Logger.getGlobal().severe("Failed to load example demo list from /templates/examples/");
        }
        this.listExampleInC = tmpListExampleInC.toArray(new String[tmpListExampleInC.size()]);
        Arrays.sort(this.listExampleInC);
        this.listExampleInCpp = tmpListExampleInCpp.toArray(new String[tmpListExampleInCpp.size()]);
        Arrays.sort(this.listExampleInCpp);
        Logger.getGlobal().fine("Loaded " + this.listExampleInC.length + " C demos and " + this.listExampleInCpp.length + " C++.");
    }

    public IFile findProjectFile(String namePath, IContainer projContainer) {
        try {
            IResource[] resources = projContainer.members();
            if (resources != null) {
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile retFile;
                    IResource res = iResourceArray[n2];
                    if (res.getType() == 1) {
                        if (res.toString().endsWith(namePath)) {
                            return (IFile)res;
                        }
                    } else if (res.getType() == 2 && (retFile = this.findProjectFile(namePath, (IContainer)res)) != null) {
                        return retFile;
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String[] getBuildConfigs() {
        return new String[]{"FakeBuildConfig"};
    }

    ProjectData.CompilersOptions getCompilersOptionsForExample(String exampleName) {
        ProjectData.CompilersOptions options = new ProjectData.CompilersOptions();
        URL url = Activator.getDefault().getBundle().getEntry(bundleExamplesPath + exampleName + compilerSettingsFileName);
        if (url == null) {
            return options;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode root = mapper.readTree(url.openStream());
            if (root == null) {
                return options;
            }
            JsonNode compilersNode = root.get(compilerNodeName);
            if (compilersNode == null) {
                return options;
            }
            ProjectData.CompilerType[] compilerTypeArray = ProjectData.CompilerType.values();
            int n = compilerTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                JsonNode flagsNode;
                ProjectData.CompilerType compilerType = compilerTypeArray[n2];
                JsonNode compilerNode = compilersNode.get(compilerType.toString());
                if (compilerNode != null && (flagsNode = compilerNode.get(compilerFlagsNodeName)) != null && flagsNode.isArray()) {
                    Iterator iterator = ((ArrayNode)flagsNode).elements();
                    while (iterator.hasNext()) {
                        options.add(compilerType, ((JsonNode)iterator.next()).asText());
                    }
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return options;
        }
        return options;
    }

    public List<String> getRequiredLibrariesForExample(String exampleName) {
        JsonNode librariesNode;
        block7: {
            JsonNode root;
            block6: {
                URL url = Activator.getDefault().getBundle().getEntry(bundleExamplesPath + exampleName + compilerSettingsFileName);
                if (url == null) {
                    return null;
                }
                ObjectMapper mapper = new ObjectMapper();
                root = mapper.readTree(url.openStream());
                if (root != null) break block6;
                return null;
            }
            librariesNode = root.get(librariesNodeName);
            if (librariesNode != null && librariesNode.isArray()) break block7;
            return null;
        }
        try {
            ArrayList<String> libraries = new ArrayList<String>();
            Iterator iterator = ((ArrayNode)librariesNode).elements();
            while (iterator.hasNext()) {
                libraries.add(((JsonNode)iterator.next()).asText());
            }
            return libraries;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getEmptyProjectFiles(NativeLanguage language, List<FileToCopy> filesOut) {
        boolean result = false;
        if (this.getFilesFromBundle(bundleBaseFiles, filesOut) <= 0) {
            Logger.getGlobal().severe("Failed to get base files!");
            return false;
        }
        if (this.getFilesFromBundle(bundleEmptyProject, filesOut) > 0) {
            switch (language) {
                case C: {
                    result = this.getFilesFromBundle(bundleEmptyProjectCOnly, filesOut) > 0;
                    break;
                }
                case CPP: {
                    result = this.getFilesFromBundle(bundleEmptyProjectCPPOnly, filesOut) > 0;
                    break;
                }
                default: {
                    Logger.getGlobal().severe("Not handled language " + language.toString() + ". Can't load base project files.");
                }
            }
        }
        return result;
    }

    public boolean getExampleFiles(String exampleName, List<FileToCopy> filesOut) {
        if (this.getFilesFromBundle(bundleBaseFiles, filesOut) <= 0) {
            Logger.getGlobal().severe("Failed to get base files!");
            return false;
        }
        return this.getFilesFromBundle(bundleExamplesPath + exampleName, filesOut) > 0;
    }

    public String[] getExampleProjects(NativeLanguage language) {
        switch (language) {
            case C: {
                return this.listExampleInC;
            }
            case CPP: {
                return this.listExampleInCpp;
            }
        }
        Logger.getGlobal().severe("Unhandled language: " + language);
        return null;
    }

    private int getFilesFromBundle(String bundlePath, List<FileToCopy> filesOut) {
        Logger.getGlobal().finer("Getting files for: " + bundlePath);
        int counter = 0;
        Enumeration filesEnum = Activator.getDefault().getBundle().findEntries(bundlePath, "*.*", true);
        while (filesEnum.hasMoreElements()) {
            URL url = (URL)filesEnum.nextElement();
            String destPath = url.getPath().toString();
            int found = destPath.indexOf(bundlePath);
            filesOut.add(new FileToCopy(url.getPath().toString(), destPath.substring(found + bundlePath.length())));
            ++counter;
        }
        return counter;
    }

    public String[] getNatureIDs(NativeLanguage language) {
        ArrayList<String> listNatures = new ArrayList<String>();
        listNatures.add("org.tizen.web.tv.sec.nacl.common.plugin.PNaClProjectNature");
        listNatures.add("org.eclipse.cdt.managedbuilder.core.managedBuildNature");
        listNatures.add("org.eclipse.cdt.managedbuilder.core.ScannerConfigNature");
        listNatures.add("org.eclipse.cdt.core.cnature");
        if (language == NativeLanguage.CPP) {
            listNatures.add("org.eclipse.cdt.core.ccnature");
        }
        return listNatures.toArray(new String[listNatures.size()]);
    }

    public Preferences getPreferences(IProject project) {
        return this.naclPreferences.getProjectPreferences(project);
    }

    public String[] getSupportedPNaClLangs() {
        return listSupportedPNaClLangs;
    }

    public String[] getToolchains() {
        String[] retVal = this.naclPreferences.getPepperVersions().keySet().toArray(new String[0]);
        Arrays.sort(retVal, Collections.reverseOrder());
        return retVal;
    }

    public Point getWidgetScreenResolution(int index) {
        return listScreenResolutionsInt[index];
    }

    public String[] getWidgetScreenResolutions() {
        return listScreenResolutions;
    }

    public String getWorkspaceFolder() {
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String strPath = path.toString();
        return strPath.replace("/", File.separator);
    }

    public static enum ETemplateInterfaces {
        NONE(""),
        AUDIO("Audio"),
        TCP_SOCKET("TCPSocket"),
        UDP_SOCKET("UDPSocket"),
        FILE_IO("FileIO"),
        MOUSE_CURSOR("MouseCursor"),
        MOUSE_LOCK("MouseLock");

        private final String value;

        public static ETemplateInterfaces toEnumValue(String value) {
            ETemplateInterfaces[] eTemplateInterfacesArray = ETemplateInterfaces.values();
            int n = eTemplateInterfacesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ETemplateInterfaces enumItem = eTemplateInterfacesArray[n2];
                if (value.equals(enumItem.toString())) {
                    return enumItem;
                }
                ++n2;
            }
            return NONE;
        }

        private ETemplateInterfaces(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

