/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.common.plugin;

import java.io.File;
import java.nio.file.Paths;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jsoup.nodes.Document;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.web.tv.sec.nacl.common.GeneralTools;
import org.tizen.web.tv.sec.nacl.common.SystemInfo;
import org.tizen.web.tv.sec.nacl.common.plugin.NaClModuleUtils;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.wasm.common.plugin.Messages;

public abstract class ProjectUtils {
    public static final String EM_CONFIG_VARIABLE_NAME = "EM_CONFIG";
    public static final String EM_CACHE_VARIABLE_NAME = "EM_CACHE";
    public static final String PATH_ENV_NAME = "PATH";
    public static final String TOOLS_PATH = ProjectUtils.getToolsPath().toString();

    public static boolean isWasmProject(IProject project) {
        boolean isWasmProject = false;
        try {
            isWasmProject = project.hasNature("org.tizen.web.tv.sec.wasm.common.plugin.WasmProjectNature");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isWasmProject;
    }

    public static IProject getTizenProject(IProject wasmProject) {
        IProject[] referencingProjects;
        if (wasmProject == null || !wasmProject.isOpen() || !ProjectUtils.isWasmProject(wasmProject)) {
            return null;
        }
        IProject[] iProjectArray = referencingProjects = wasmProject.getReferencingProjects();
        int n = referencingProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject referencingProject = iProjectArray[n2];
            if (org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils.isWebTvTizenProject((IProject)referencingProject) && ProjectUtils.isWasmModuleInsideProject(wasmProject, referencingProject)) {
                return referencingProject;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isWasmModuleInsideProject(IProject wasmProject, IProject project) {
        String wasmProjectPath = NaClModuleUtils.getProjectBasePath((IProject)wasmProject);
        String projectFullPath = NaClModuleUtils.getProjectBasePath((IProject)project);
        return wasmProjectPath.contains(projectFullPath);
    }

    public static void toggleTizenProjectWasmNature(IProject project, ProjectUtils.ActionOnProject action) throws CoreException {
        org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils.toggleNature((IProject)project, (ProjectUtils.ActionOnProject)action, (String)"org.tizen.web.tv.sec.wasm.common.plugin.TizenProjectWasmNature");
    }

    public static void saveContentToFile(String filePath, String content) {
        NaClModuleUtils.saveContentToFile((String)filePath, (String)content);
    }

    public static Document parseFile(File file) {
        return NaClModuleUtils.parseFile((File)file);
    }

    public static void resetEmscriptenConfig(ICConfigurationDescription configDescription, String emConfigPath, String emCachePath) throws CoreException {
        if (configDescription == null) {
            return;
        }
        if (emConfigPath == null || emConfigPath.isEmpty()) {
            return;
        }
        if (emCachePath == null || emCachePath.isEmpty()) {
            return;
        }
        IContributedEnvironment environment = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
        if (environment == null) {
            return;
        }
        String emscriptenPathContributions = GeneralTools.composePath((String[])GeneralTools.getPathContributionsSet((String)emConfigPath));
        if (emscriptenPathContributions == null) {
            throw new CoreException((IStatus)new Status(4, ProjectUtils.class.getPackage().getName(), String.valueOf(Messages.FailedToReadEmscriptenConfig) + emConfigPath));
        }
        environment.addVariable(EM_CONFIG_VARIABLE_NAME, emConfigPath, 1, null, configDescription);
        environment.addVariable(EM_CACHE_VARIABLE_NAME, emCachePath, 1, null, configDescription);
        String pathContribution = GeneralTools.composePath((String[])new String[]{TOOLS_PATH, emscriptenPathContributions});
        EnvironmentVariable pathVar = new EnvironmentVariable(PATH_ENV_NAME, pathContribution, 3, File.pathSeparator);
        environment.removeVariable(PATH_ENV_NAME, configDescription);
        environment.addVariable((IEnvironmentVariable)pathVar, configDescription);
    }

    public static void resetEmscriptenConfig(IProject project, IConfiguration configuration, String emConfigPath, String emCachePath) throws CoreException {
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project, true);
        if (description == null) {
            System.err.println("Failed to get project description for project " + project.getName());
            return;
        }
        ICConfigurationDescription config = description.getConfigurationById(configuration.getId());
        ProjectUtils.resetEmscriptenConfig(config, emConfigPath, emCachePath);
        try {
            CoreModel.getDefault().setProjectDescription(project, description);
        }
        catch (CoreException e) {
            System.err.println("Failed to reset build environment from Emscripten config file: " + emConfigPath);
            e.printStackTrace();
        }
    }

    public static File getToolsPath() {
        File msys2Path;
        if (SystemInfo.isWindowsOs() && (msys2Path = Paths.get(InstallPathConfig.getToolsPath(), "msys2", "usr", "bin").toFile()).exists()) {
            return msys2Path;
        }
        return new File("");
    }
}

