/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.tizen.web.tv.sec.nacl.launch.Messages;
import org.tizen.web.tv.sec.nacl.launch.Utils;

public class ChromeLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final String SERVER_PARAMS_FILE = ".python_server";
    private static final String PYTHON_SERVER_COMMAND = "import SimpleHTTPServer;import SocketServer;import time;httpd = SocketServer.TCPServer(('localhost', %d),SimpleHTTPServer.SimpleHTTPRequestHandler);host, port = httpd.server_address;f = open('.python_server', 'w');f.write(host + '\\n');f.write(str(port) + '\\n');f.close();print 'Server started at: ' + host + ':' + str(port); httpd.serve_forever()";
    private static final int WAIT_INTERVAL_MS = 50;
    private static final int WAIT_TIMEOUT_MS = 5000;
    public static final String SERVER_ATTR_HOST = "host";
    public static final String SERVER_ATTR_PORT = "port";
    public static final String CHROME_ATTR_DIR = "chrome_user_dir";
    private final Object mutex = new Object();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        MessageConsole console = Utils.getConsole(Messages.Common_launchConsoleLabel);
        PrintStream out = Utils.getStreamFromConsole(console);
        try {
            String serveDir = this.getServeDirectory(configuration);
            this.launchServer(launch, serveDir, 0);
            this.launchChrome(launch, configuration, out);
        }
        finally {
            Utils.closeStream(out);
        }
    }

    private String getServeDirectory(ILaunchConfiguration configuration) throws CoreException {
        Path serveDir = Paths.get(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.INDEX_HTML", ""), new String[0]).getParent();
        return serveDir.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchServer(ILaunch launch, String serveDir, int port) throws CoreException {
        try {
            File serverParams = new File(serveDir, SERVER_PARAMS_FILE);
            if (serverParams.exists()) {
                serverParams.delete();
            }
            ProcessBuilder pb = new ProcessBuilder("python", "-u", "-c", String.format(PYTHON_SERVER_COMMAND, port));
            pb.directory(new File(serveDir));
            Process process = pb.start();
            IProcess serverProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)Messages.ChromeLaunchDelegate_httpProcessLabel);
            Object object = this.mutex;
            synchronized (object) {
                for (int timeout = 5000; !serverParams.exists() && !serverProcess.isTerminated() && timeout > 0; timeout -= 50) {
                    this.mutex.wait(50L);
                }
            }
            Scanner sc = new Scanner(serverParams);
            String host = sc.nextLine();
            port = sc.nextInt();
            sc.close();
            serverParams.delete();
            serverProcess.setAttribute(SERVER_ATTR_HOST, host);
            serverProcess.setAttribute(SERVER_ATTR_PORT, Integer.toString(port));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", String.valueOf(Messages.ChromeLaunchDelegate_serverLaunchError) + " " + e.getMessage()));
        }
    }

    private void launchChrome(ILaunch launch, ILaunchConfiguration configuration, PrintStream out) throws CoreException {
        IProcess serverProcess = null;
        IProcess[] iProcessArray = launch.getProcesses();
        int n = iProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process = iProcessArray[n2];
            if (process.getLabel().equals(Messages.ChromeLaunchDelegate_httpProcessLabel)) {
                serverProcess = process;
                break;
            }
            ++n2;
        }
        if (serverProcess == null) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", Messages.ChromeLaunchDelegate_httpNotLaunched));
        }
        String index = Paths.get(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.INDEX_HTML", ""), new String[0]).getFileName().toString();
        try {
            URL url = new URL("http", serverProcess.getAttribute(SERVER_ATTR_HOST), Integer.valueOf(serverProcess.getAttribute(SERVER_ATTR_PORT)), "/" + index);
            out.println(NLS.bind((String)Messages.ChromeLaunchDelegate_launchingNaclApp, (Object)url.toString()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            List<String> command = this.constructChromeCommand(configuration, url, attributes);
            ProcessBuilder pb = new ProcessBuilder(command);
            DebugPlugin.newProcess((ILaunch)launch, (Process)pb.start(), (String)Messages.ChromeLaunchDelegate_chromeProcessLabel, attributes);
        }
        catch (IOException ex) {
            if (launch.canTerminate()) {
                launch.terminate();
            }
            ex.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", NLS.bind((String)Messages.ChromeLaunchDelegate_chromeLaunchError, (Object)ex.getMessage()), (Throwable)ex));
        }
    }

    private List<String> constructChromeCommand(ILaunchConfiguration configuration, URL url, Map<String, String> chromeAttributes) throws CoreException {
        ArrayList<String> command = new ArrayList<String>();
        String chromePath = configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_PATH", "");
        if (chromePath.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", Messages.ChromeLaunchDelegate_chromeNotFound));
        }
        command.add(chromePath);
        List chromeArgs = configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_ARGS", new ArrayList());
        if (!chromeArgs.isEmpty()) {
            command.addAll(chromeArgs);
        }
        try {
            this.addTempDirectory(command, chromeAttributes);
            command.add(url.toString());
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", NLS.bind((String)Messages.ChromeLaunchDelegate_chromeLaunchError, (Object)ex.getMessage()), (Throwable)ex));
        }
        return command;
    }

    private void addTempDirectory(List<String> command, Map<String, String> attributes) throws IOException {
        for (String str : command) {
            if (!str.startsWith("--user-data-dir")) continue;
            return;
        }
        String tempDir = Files.createTempDirectory("nacl-sdk", new FileAttribute[0]).toString();
        command.add("--user-data-dir=" + tempDir);
        attributes.put(CHROME_ATTR_DIR, tempDir);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        String projName = configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", "");
        if (projName.isEmpty()) {
            return null;
        }
        IProject[] projects = new IProject[]{ResourcesPlugin.getWorkspace().getRoot().getProject(projName)};
        return projects;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean canLaunch = super.finalLaunchCheck(configuration, mode, monitor);
        if (!canLaunch) {
            return false;
        }
        String projName = configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", "");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        List<String> samsungInterfaces = this.getSamsungInterfacesFromManifest(project);
        if (!samsungInterfaces.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.ChromeLaunchDelegate_samsungInterfacesMessage);
            for (String iface : samsungInterfaces) {
                sb.append(iface).append("\n");
            }
            sb.append(Messages.ChromeLaunchDelegate_functionalityWarning);
            sb.append("\n");
            sb.append(Messages.ChromeLaunchDelegate_doProceed);
            final class Prompter
            implements Runnable {
                private final String title;
                private final String message;
                private boolean result = false;

                public Prompter(String title, String message) {
                    this.title = title;
                    this.message = message;
                }

                public boolean open() {
                    Display.getDefault().syncExec((Runnable)this);
                    return this.result;
                }

                @Override
                public void run() {
                    this.result = MessageDialog.openQuestion(null, (String)this.title, (String)this.message);
                }
            }
            Prompter prompter = new Prompter(Messages.ChromeLaunchDelegate_samsungInterfacesTitle, sb.toString());
            canLaunch = prompter.open();
        }
        return canLaunch;
    }

    private List<String> getSamsungInterfacesFromManifest(IProject project) throws CoreException {
        ArrayList<String> interfaces = new ArrayList<String>();
        ManifestVisitor visitor = new ManifestVisitor();
        project.getFolder("CurrentBin").accept((IResourceProxyVisitor)visitor, 1, 0);
        IPath manifestPath = visitor.getManifestPath();
        if (manifestPath == null) {
            return interfaces;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode root = mapper.readTree(manifestPath.toFile());
            for (JsonNode permission : root.path("permissions")) {
                String str = permission.asText();
                if (!str.contains("Samsung")) continue;
                interfaces.add(str);
            }
        }
        catch (IOException ex) {
            Logger.getGlobal().log(Level.SEVERE, ex.getMessage(), ex);
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", Messages.ChromeLaunchDelegate_manifestReadError, (Throwable)ex));
        }
        return interfaces;
    }

    private static class ManifestVisitor
    implements IResourceProxyVisitor {
        private IResource manifest = null;

        private ManifestVisitor() {
        }

        IPath getManifestPath() {
            if (this.manifest == null) {
                return null;
            }
            return this.manifest.getLocation();
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (proxy.getType() == 1 && proxy.getName().endsWith(".nmf")) {
                IResource resource = proxy.requestResource();
                if (this.manifest == null || this.manifest.getLocalTimeStamp() < resource.getLocalTimeStamp()) {
                    this.manifest = resource;
                    return false;
                }
            }
            return true;
        }
    }
}

