/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.tizen.web.tv.sec.nacl.launch.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ChromeLaunchInitializer {
    private static final String[] DEFAULT_CHROME_CMDS_WIN = new String[]{"C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe", "C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe"};
    private static final String DEFAULT_CHROME_CMD_UNIX = "google-chrome";
    private static final String DEFAULT_CHROME_CMD_MAC = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
    private static final String HTML_TAG_NAME = "content";
    private static final String HTML_ATTR_NAME = "src";
    protected final IProject project;

    public ChromeLaunchInitializer(IProject project) {
        this.project = project;
    }

    public void setDefaultChromeArguments(ILaunchConfigurationWorkingCopy wc) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--enable-nacl");
        arguments.add("--no-first-run");
        arguments.add("--no-sandbox");
        arguments.add("--allow-nacl-socket-api=localhost");
        arguments.add("--allow-nacl-socket-api=127.0.0.1");
        wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_ARGS", arguments);
    }

    public void setDefaultChromeCommand(ILaunchConfigurationWorkingCopy wc) {
        String command = "";
        if (SystemUtils.IS_OS_WINDOWS) {
            String[] stringArray = DEFAULT_CHROME_CMDS_WIN;
            int n = DEFAULT_CHROME_CMDS_WIN.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate = stringArray[n2];
                if (Files.exists(Paths.get(candidate, new String[0]), new LinkOption[0])) {
                    command = candidate;
                    break;
                }
                ++n2;
            }
        } else {
            command = SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX ? DEFAULT_CHROME_CMD_MAC : DEFAULT_CHROME_CMD_UNIX;
        }
        wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_PATH", command);
    }

    public boolean setDefaultHtmlFile(ILaunchConfigurationWorkingCopy wc) {
        String indexHtml = this.getHtmlFromConfigXml();
        wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.INDEX_HTML", indexHtml);
        return !indexHtml.isEmpty();
    }

    private String getHtmlFromConfigXml() {
        Node srcAttribute;
        String relativePath;
        block10: {
            NodeList contentList;
            block9: {
                if (this.project == null) {
                    return "";
                }
                IFile configFile = this.project.getFile("config.xml");
                if (!configFile.exists()) {
                    return "";
                }
                relativePath = "";
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(configFile.getLocation().toFile());
                Element root = doc.getDocumentElement();
                contentList = root.getElementsByTagName(HTML_TAG_NAME);
                if (contentList.getLength() > 0) break block9;
                return "";
            }
            srcAttribute = contentList.item(0).getAttributes().getNamedItem(HTML_ATTR_NAME);
            if (srcAttribute != null) break block10;
            return "";
        }
        try {
            relativePath = srcAttribute.getNodeValue();
        }
        catch (IOException | SAXException ex) {
            Logger.getGlobal().log(Level.SEVERE, Messages.ChromeLaunchInitializer_configXmlError, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getGlobal().log(Level.SEVERE, Messages.ChromeLaunchInitializer_parserEror, ex);
        }
        if (relativePath == null || relativePath.isEmpty()) {
            return "";
        }
        File htmlFile = this.project.getLocation().append(relativePath).toFile();
        if (!htmlFile.exists()) {
            return "";
        }
        return htmlFile.getAbsolutePath();
    }

    public void setProjectName(ILaunchConfigurationWorkingCopy wc) {
        String projectName = this.project == null ? "" : this.project.getName();
        wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", projectName);
    }
}

