/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.web.tv.sec.nacl.adapter.launch.Emulator;
import org.tizen.web.tv.sec.nacl.launch.DeviceSelectionDialog;
import org.tizen.web.tv.sec.nacl.launch.Messages;
import org.tizen.web.tv.sec.nacl.launch.NaclMainTab;

public class DeviceMainTab
extends NaclMainTab {
    private static final String[] WIDGET_EXTENSIONS = new String[]{"*.wgt"};
    private Text widgetFile;
    private Text targetEmulator;
    private Button generateWidget;

    @Override
    public void createControl(Composite parent, ModifyListener listener) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(3, false);
        comp.setLayout((Layout)layout);
        this.createProjectNameControls(comp, listener);
        this.createWidgetFileControls(comp, listener);
        this.createEmulatorInstanceControls(comp, listener);
    }

    private void createWidgetFileControls(Composite comp, ModifyListener listener) {
        Label label = new Label(comp, 0);
        label.setText(Messages.DeviceMainTab_widgetFile);
        this.widgetFile = new Text(comp, 2052);
        this.widgetFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.widgetFile.addModifyListener(listener);
        Button browseButton = new Button(comp, 0);
        browseButton.setText(Messages.ChromeMainTab_browseButtonLabel);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                FileDialog dialog = new FileDialog(DeviceMainTab.this.getShell());
                dialog.setFilterExtensions(WIDGET_EXTENSIONS);
                String widget = dialog.open();
                if (widget != null) {
                    DeviceMainTab.this.widgetFile.setText(widget);
                }
            }
        });
        new Label(comp, 0);
        this.generateWidget = new Button(comp, 32);
        this.generateWidget.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.generateWidget.setText(Messages.DeviceMainTab_generateWidget);
        this.generateWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                DeviceMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createEmulatorInstanceControls(Composite comp, ModifyListener listener) {
        Label label = new Label(comp, 0);
        label.setText(Messages.DeviceMainTab_target);
        this.targetEmulator = new Text(comp, 2052);
        this.targetEmulator.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.targetEmulator.addModifyListener(listener);
        Button selectButton = new Button(comp, 0);
        selectButton.setText(Messages.General_select);
        selectButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                DeviceSelectionDialog dialog = new DeviceSelectionDialog(DeviceMainTab.this.getShell());
                DeviceMainTab.this.targetEmulator.setText(dialog.openDialog());
                DeviceMainTab.this.notifyTargetChanged(DeviceMainTab.this.targetEmulator.getText());
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.EMULATOR_INSTANCE", this.guessEmulatorInstance());
    }

    private String guessEmulatorInstance() {
        List emulators = Emulator.list();
        if (emulators.size() == 1) {
            return ((Emulator.EmulatorInfo)emulators.get((int)0)).serial;
        }
        return "";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projName.setText(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", ""));
            this.widgetFile.setText(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.WIDGET_PATH", ""));
            this.targetEmulator.setText(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.EMULATOR_INSTANCE", ""));
            this.generateWidget.setSelection(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.GENERATE_WIDGET", false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", this.projName.getText());
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.WIDGET_PATH", this.widgetFile.getText());
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.EMULATOR_INSTANCE", this.targetEmulator.getText());
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.GENERATE_WIDGET", this.generateWidget.getSelection());
    }

    public boolean isValid(ILaunchConfiguration config) {
        block8: {
            String widgetPath;
            block7: {
                block6: {
                    this.setErrorMessage(null);
                    try {
                        if (this.isProjectNameValid(config)) break block6;
                        return false;
                    }
                    catch (CoreException e) {
                        this.setErrorMessage(Messages.ChromeMainTab_unknownError);
                        e.printStackTrace();
                        return false;
                    }
                }
                widgetPath = config.getAttribute("org.tizen.web.tv.sec.nacl.launch.WIDGET_PATH", "");
                if (!widgetPath.isEmpty()) break block7;
                this.setErrorMessage(Messages.DeviceMainTab_widgetPathEmpty);
                return false;
            }
            if (Files.exists(Paths.get(widgetPath, new String[0]), new LinkOption[0]) || config.getAttribute("org.tizen.web.tv.sec.nacl.launch.GENERATE_WIDGET", false)) break block8;
            this.setErrorMessage(Messages.DeviceMainTab_invalidWidgetError);
            return false;
        }
        if (config.getAttribute("org.tizen.web.tv.sec.nacl.launch.EMULATOR_INSTANCE", "").isEmpty()) {
            this.setErrorMessage(Messages.DeviceMainTab_noEmulatorError);
            return false;
        }
        return true;
    }
}

