/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.nacl.common.plugin.UiUtils;
import org.tizen.web.tv.sec.nacl.launch.Messages;

public abstract class NaclLaunchShortcut
implements ILaunchShortcut2 {
    protected void showError(String message, String reason) {
        Shell shell = UiUtils.getShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)Messages.NaclLaunchShortcut_launchError, (String)message, (IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", reason));
        }
    }

    protected BuildConfigData getCurrentBuildConfigData(IProject project) {
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
        if (projectDescription != null) {
            IBuildPropertyValue value;
            IBuildObjectProperties properties;
            IBuildProperty property;
            ICConfigurationDescription activeConfig = projectDescription.getActiveConfiguration();
            boolean isDebug = false;
            IConfiguration config = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)activeConfig);
            if (config != null && (property = (properties = config.getBuildProperties()).getProperty("org.eclipse.cdt.build.core.buildType")) != null && "org.eclipse.cdt.build.core.buildType.debug".equals((value = property.getValue()).getId())) {
                isDebug = true;
            }
            BuildConfigData.ToolchainType toolchainType = null;
            String buildConfigId = activeConfig.getId();
            toolchainType = buildConfigId.contains("glibc") ? BuildConfigData.ToolchainType.GLIBC : BuildConfigData.ToolchainType.PNACL;
            if (toolchainType != null) {
                return new BuildConfigData(activeConfig.getName(), toolchainType, isDebug);
            }
        }
        return null;
    }

    public void launch(ISelection selection, String mode) {
        IResource resource = this.getLaunchableResource(selection);
        if (resource instanceof IProject) {
            this.launch((IProject)resource, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        editor.getSite().getWorkbenchWindow().getShell();
        IResource resource = this.getLaunchableResource(editor);
        if (resource instanceof IProject) {
            this.launch((IProject)resource, mode);
        }
    }

    protected void launch(IProject project, String mode) {
        block4: {
            Shell shell = UiUtils.getShell();
            try {
                if (!ProjectUtils.isNaClProject((IProject)project)) {
                    throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", Messages.NaclLaunchShortcut_notNaclProjectError));
                }
                ILaunchConfiguration configuration = this.getConfiguration(project, mode.equals("debug"));
                if (configuration == null) {
                    return;
                }
                DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
            }
            catch (CoreException ex) {
                Logger.getGlobal().log(Level.SEVERE, Messages.NaclLaunchShortcut_launchError, ex);
                if (shell == null) break block4;
                ErrorDialog.openError((Shell)shell, (String)Messages.NaclLaunchShortcut_launchError, (String)ex.getLocalizedMessage(), (IStatus)ex.getStatus());
            }
        }
    }

    protected ILaunchConfiguration getConfiguration(IProject project, boolean isDebug) throws CoreException {
        List<ILaunchConfiguration> candidates = this.findLaunchCandidates(project);
        int size = candidates.size();
        switch (size) {
            case 0: {
                return this.createLaunchConfiguration(project, isDebug);
            }
            case 1: {
                return candidates.get(0);
            }
        }
        return this.promptForConfigSelection(candidates.toArray(new ILaunchConfiguration[size]));
    }

    protected List<ILaunchConfiguration> findLaunchCandidates(IProject project) {
        ArrayList<ILaunchConfiguration> candidates = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getLaunchConfigurationType());
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (this.isLaunchCandidateValid(config, project)) {
                    candidates.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Logger.getGlobal().log(Level.SEVERE, Messages.NaclLaunchShortcut_configError, ex);
        }
        return candidates;
    }

    protected abstract ILaunchConfigurationType getLaunchConfigurationType();

    protected boolean isLaunchCandidateValid(ILaunchConfiguration candidate, IProject project) {
        try {
            return project.getName().equals(candidate.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", ""));
        }
        catch (CoreException ex) {
            Logger.getGlobal().log(Level.SEVERE, Messages.NaclLaunchShortcut_attributeError, ex);
            return false;
        }
    }

    protected abstract ILaunchConfiguration createLaunchConfiguration(IProject var1, boolean var2) throws CoreException;

    protected ILaunchConfiguration promptForConfigSelection(ILaunchConfiguration[] configs) {
        Shell shell = UiUtils.getShell();
        if (shell == null) {
            return null;
        }
        LabelProvider provider = new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ILaunchConfiguration) {
                    return ((ILaunchConfiguration)element).getName();
                }
                return element.toString();
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)provider);
        dialog.setElements((Object[])configs);
        dialog.setTitle(Messages.NaclLaunchShortcut_selectConfTitle);
        dialog.setMessage(Messages.NaclLaunchShortcut_selectConfMessage);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        provider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        return ProjectUtils.getCurrentProject((ISelection)selection);
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return ProjectUtils.getCurrentProject((IEditorPart)editorpart);
    }

    public static class BuildConfigData {
        private final String name;
        private final ToolchainType toolchainType;
        private final boolean debug;

        public BuildConfigData(String name, ToolchainType toolchainType, boolean isDebug) {
            this.name = name;
            this.toolchainType = toolchainType;
            this.debug = isDebug;
        }

        public String getName() {
            return this.name;
        }

        public ToolchainType getToolchainType() {
            return this.toolchainType;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public static enum ToolchainType {
            PNACL,
            GLIBC;

        }
    }
}

