#include "ppapi/cpp/instance.h"
#include "ppapi/cpp/module.h"
#include "ppapi/cpp/var.h"
#include "ppapi/cpp/var_array_buffer.h"
#include "ppapi/cpp/var_dictionary.h"
#include <cstring>

/**
 * This is a base of your NaCl application. There is one instance of
 * <code>pp::Instance</code> class object per <embed> element on a web page.
 */
class NaClInstance : public pp::Instance {
 public:

  explicit NaClInstance(PP_Instance instance);

  virtual ~NaClInstance();

  /**
   * Handles messages from JS sent by <code>nacl_module.postMessage(...)</code>.
   * @see <code>HandleMessage</code> in <toolchain>/ppapi/cpp/instance.h file for more details.
   */
  virtual void HandleMessage(const pp::Var& message);

  /**
   * Initializes this instance with provided arguments listed in the <embed>
   * tag.
   * @see <code>Init()</code> in <toolchain>/ppapi/cpp/instance.h file for more details.
   */
  virtual bool Init(uint32_t argc, const char* argn[], const char* argv[]);
};

/**
 * A NaCl app must have one class that implements <code>pp::Module</code>.
 */
class NaClModule : public pp::Module {
 public:
  NaClModule();

  virtual ~NaClModule();

  /**
   * This method is called every time a browser encounters an <embed> element
   * on a web page.
   */
  virtual pp::Instance* CreateInstance(PP_Instance instance);
};

namespace pp {

/**
 * This function is an entry point to a NaCl application.
 */
Module* CreateModule();

}  // namespace pp
