/**
 * Copyright (c) 2015, Samsung Electronics Co., Ltd
 * All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  * Neither the name of Samsung Electronics nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef THREADS_AND_CALLBACKS_THREADS_AND_CALLBACKS_H_
#define THREADS_AND_CALLBACKS_THREADS_AND_CALLBACKS_H_

#include <string>

#include "ppapi/cpp/instance.h"
#include "ppapi/cpp/module.h"
#include "ppapi/cpp/var.h"
#include "ppapi/cpp/url_request_info.h"
#include "ppapi/cpp/url_response_info.h"
#include "ppapi/cpp/message_loop.h"
#include "ppapi/utility/completion_callback_factory.h"
#include "ppapi/utility/threading/simple_thread.h"

#include "own_thread_url_loader.h"

class ThreadsAndCallbacksInstance : public pp::Instance {
 public:
  ThreadsAndCallbacksInstance(PP_Instance instance);
  virtual bool Init(uint32_t argc, const char* argn[], const char* argv[]);
  virtual void HandleMessage(const pp::Var& message);

 private:

  // CalculatePi() does math in background thread.
  void CalculatePi(int32_t result, int iterations);
  // DownloadUrl() runs download of data from URL in OwnThreadUrlLoader.
  void DownloadUrl(const std::string& url);
  // Callback for OwnThreadUrlLoader. Cleans after download.
  void CleanLoader(int32_t result, const std::string& message);

  // SimpleThread is PPAPI class providing simple threading functionalities.
  // For more information see simple_thread.h.
  // This SimpleThread is used for math calculations in CalculatePi.
  pp::SimpleThread simple_thread_pi_;

  // CompletionCallbackFactory is a PPAPI class providing a simple way to create
  // completion callbacks.
  pp::CompletionCallbackFactory<ThreadsAndCallbacksInstance> factory_;
  std::unique_ptr<OwnThreadUrlLoader> loader_;
};

class ThreadsAndCallbacksModule : public pp::Module {
 public:
  ThreadsAndCallbacksModule() : pp::Module() {}
  virtual ~ThreadsAndCallbacksModule() {}

  virtual pp::Instance* CreateInstance(PP_Instance instance) {
    return new ThreadsAndCallbacksInstance(instance);
  }
};

namespace pp {
Module* CreateModule() {
  return new ThreadsAndCallbacksModule();
}

}  // namespace pp

#endif /* THREADS_AND_CALLBACKS_H_ */
