/**
 * Copyright (c) 2015, Samsung Electronics Co., Ltd
 * All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  * Neither the name of Samsung Electronics nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @file example.js
 * @brief Example specific UI configuration.
 * Variables below will configure this demo example for it needs after document
 * load finishes.
 * @see common.js for more details.
 */

var demo_name = "Audio";
var demo_description = "The Audio example demonstrates how to use " +
        "pp::Audio interface.<br> Four WAVE files can be loaded and played." +
        "<br>Also, there is a simple mixer implemented,<br>so loaded sounds can be " +
        "played simultaneously.<br>" +
        "Files are read from <i>sounds</i> folder in widget folder. " +
        "<br>In the text fields input file names and click appropriate <b>Load</b> button." +
        "<br>Sample rate is set based on the value in header of the audio file," +
        "<br>it can be changed via radio button." +
        "<br>Silence is added in order to check if internal audio buffer flushed properly." +
        "<br>Parameters are displayed when track stops playing, stop or pause button is pressed." +
        "<br>The last sound is meant for fast clicking in a row to test audio latency.";
var nmf_path_name = "<nmf_file>";
var nacl_width = 0;
var nacl_height = 0;
var uses_logging = true; // If "false" - hides logs area on the HTML page.

function exampleSpecificActionAfterNaclLoad() {
    domContentsLoaded();
}

const MAX_NUMBER_OF_FILES = 5;

/**
* Attach listeners to buttons and enable buttons loading sounds.
*/
function domContentsLoaded() {
  // enabling load buttons
  var number;
  for (number = 1; number <= MAX_NUMBER_OF_FILES; number++){
    document.getElementById("load" + number).disabled = false;
  }
  // attaching listeners to buttons
  attachListeners();
}

function onAudioButtonClick(e) {
  var id = e.target.id;
  // trim the "img" beginning, if clicked on button image
  if (id.substr(0,3) == "img")
    id = id.substr(3);
  // send appropriate message to NaCl module
  document.getElementById("nacl_module").postMessage(id);
}

function onLoadButtonClick(e) {
  var id = e.target.id.substr(0,5) + "name";
  var fileName = document.getElementById(id).value;
  var message = e.target.id.substr(0, e.target.id.length);
  document.getElementById("nacl_module").postMessage(message + " " + fileName);
}

function onChangeChannel(e) {
  var returnMessage = "-channel "+  e.target.id;
  document.getElementById("nacl_module").postMessage(returnMessage);
}

function onChangeSampleRate(e) {
  var returnMessage = "-rate "+  e.target.id;
  document.getElementById("nacl_module").postMessage(returnMessage);
}

function onSampleFrameCountChangeButtonClick() {
  document.getElementById("nacl_module").postMessage("change" +
                          document.getElementById("buffer_size").value);
}

function onVolumeChange() {
  document.getElementById("nacl_module").postMessage("volume" +
                          document.getElementById("volume").value);
}

/**
* Attach listeners to every button.
*/
function attachListeners() {
  var audioButtonNames = ["play1", "pause1", "stop1",
                          "play2", "pause2", "stop2",
                          "play3", "pause3", "stop3",
                          "play4", "pause4", "stop4",
                          "play5"];
  var loadButtonNames = ["load1", "load2", "load3", "load4", "load5"];
  var changeChannelNames = ["left", "right", "both"];
  var changeSampleRateNames = ["44100", "48000"];
  var index;
  for (index = 0; index < audioButtonNames.length; index++) {
    document.getElementById(audioButtonNames[index]).
        addEventListener("click", onAudioButtonClick);
  }
  for (index = 0; index < loadButtonNames.length; index++) {
    document.getElementById(loadButtonNames[index]).
        addEventListener("click", onLoadButtonClick);
  }
  for (index = 0; index < changeChannelNames.length; index++) {
    document.getElementById(changeChannelNames[index]).
        addEventListener("click", onChangeChannel);
  }
  for (index = 0; index < changeSampleRateNames.length; index++) {
    document.getElementById(changeSampleRateNames[index]).
        addEventListener("click", onChangeSampleRate);
  }
  document.getElementById("change_buffer_size").
    addEventListener("click", onSampleFrameCountChangeButtonClick);
  document.getElementById("volume").
    addEventListener("change", onVolumeChange);
}