/**
 * Copyright (c) 2015, Samsung Electronics Co., Ltd
 * All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  * Neither the name of Samsung Electronics nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

var demo_name = "threads_and_callbacks";
var demo_description = "This is an example of using threading and callbacks in a NaCl application.<br> It shows how to delegate tasks to background threads to avoid the main thread blocking.<br> It also shows calls to PPAPI from a background thread and how to dispatch calls to the main thread.";
var nmf_path_name = "<nmf_file>";
var nacl_width = 0;         // NaCl module view width and height in pixels.
var nacl_height = 0;
var uses_logging = true;   // If "false" - hides logs area on the HTML page.


function calculatePi() {
  var message = calculatePiCommand + document.getElementById("iterations").value;
  var nacl_module = document.getElementById("nacl_module");
  nacl_module.postMessage(message);
}

function downloadURL() {
  var message = downloadUrlCommand + document.getElementById("url").value;
  var nacl_module = document.getElementById("nacl_module");
  nacl_module.postMessage(message);
}

function attachListeners() {
  document.getElementById("calculate_pi").addEventListener("click", calculatePi);
  document.getElementById("download_url").addEventListener("click", downloadURL);
}

function exampleSpecificActionAfterNaclLoad() {
  attachListeners();
  /* Fill this function with your code (if needed). */
}

