#include <stdio.h>
#include <string.h>

#include "ppapi/c/pp_errors.h"
#include "ppapi/c/ppp.h"
#include "ppapi/c/ppp_instance.h"
#include "ppapi/c/ppp_messaging.h"
#include "ppapi/c/pp_bool.h"
#include "ppapi/c/ppb_var.h"
#include "ppapi/c/ppb_messaging.h"
#include "ppapi/c/pp_var.h"
#include "ppapi/c/ppb_var_array_buffer.h"

/* Global pointers to selected browser interfaces. */
const PPB_Messaging* g_messaging_interface;
const PPB_Var* g_var_interface;
const PPB_VarArrayBuffer* g_var_array_buffer_interface;


/**
 * This function is called by the browser when a new NaCl application instance
 * is created. Here your application starts it's action.
 * @see <code>DidCreate</code> in ppp_instance.h file.
 */
static PP_Bool Instance_DidCreate(PP_Instance instance, uint32_t argc,
                                  const char* argn[], const char* argv[]);

/**
 * Called when an instance is destroyed.
 * @see <code>DidDestroy</code> in ppp_instance.h file.
 */
static void Instance_DidDestroy(PP_Instance instance);

/**
 * Called when instance view attributes has changed.
 * @see <code>DidChangeView</code> in ppp_instance.h file.
 */
static void Instance_DidChangeView(PP_Instance pp_instance, PP_Resource view);

/**
 * Called when an instance gained or lost focus.
 * @see <code>DidChangeFocus</code> in ppp_instance.h file.
 */
static void Instance_DidChangeFocus(PP_Instance pp_instance, PP_Bool has_focus);

/**
 * @see <code>HandleDocumentLoad</code> in ppp_instance.h file.
 */
static PP_Bool Instance_HandleDocumentLoad(PP_Instance pp_instance,
                                           PP_Resource pp_url_loader);

/**
 * This is an entry point to this nacl module. It's called while module is being
 * initialized. It's better not to do much here but interface pointers initialization.
 * With <code>get_browser_interface</code> you can get browser interfaces.
 * Implementation of this method is obligatory.
 * @see <code>PPP_InitializeModule</code> in ppp.h file.
 */
PP_EXPORT int32_t PPP_InitializeModule(PP_Module module_id,
                                       PPB_GetInterface get_browser_interface);
/**
 * An implementation specific function for internal use only. It's better to
 * leave this method empty :)
 * Implementation of this method is obligatory.
 * @see <code>PPP_ShutdownModule</code> in ppp.h file.
 */
PP_EXPORT void PPP_ShutdownModule();

/**
 * Handles messages from JS sent by <code>nacl_module.postMessage(...)</code>.
 * @see <code>HandleMessage()</code> in ppp_messaging.h file.
 */
void Messaging_HandleMessage(PP_Instance instance, struct PP_Var message);

/**
 * Browser uses this method to get implementation of interfaces that this module
 * supports.
 * Implementation of this method is also obligatory.
 * @see <code>PPP_GetInterface</code> in ppp.h file.
 */
PP_EXPORT const void* PPP_GetInterface(const char* interface_name);
