/**
 * Copyright (c) 2015, Samsung Electronics Co., Ltd
 * All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  * Neither the name of Samsung Electronics nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @file example.js
 * @brief Example specific UI configuration.
 * Variables below will configure this demo example for it needs after document
 * load finishes.
 * @see common.js for more details.
 */

var nacl;
var demo_name = "Sockets";
var demo_description = "The socket example demonstrates how to use the TCP and UDP" +
    " socket API.</br>First, set a server address in the 'hostname:port' text field," +
    " then push the \"Connect\" button to establish a connection.</br>\"Send\" button" +
    " sends a message from the text area to the remote host. Any data received back" +
    " will be outputted to the status log.</br>For example, try connecting to a TCP" +
    " echo server that will reply with whatever bytes you send, or connect to a web" +
    " server and send a GET request.</br>\"Close\" button closes the connection.";
var nmf_path_name = "<nmf_file>";
var nacl_width = 0;         // NaCl module view width and height in pixels.
var nacl_height = 0;
var uses_logging = true;   // If "false" - hides logs area on the HTML page.

function exampleSpecificActionAfterNaclLoad() {
  attachListeners();
  nacl = document.getElementById('listener').getElementsByTagName('embed')[0];
}

function attachListeners() {
  document.getElementById('connectForm').addEventListener('submit', doConnect);
  document.getElementById('sendForm').addEventListener('submit', doSend);
  document.getElementById('listenForm').addEventListener('submit', doListen);
  document.getElementById('closeButton').addEventListener('click', doClose);
}
