/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.mtwizard;

import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.nacl.mtgenerator.ISourceGenerator;
import org.tizen.web.tv.sec.nacl.mtgenerator.Message;
import org.tizen.web.tv.sec.nacl.mtgenerator.NativeLanguageDetector;
import org.tizen.web.tv.sec.nacl.mtgenerator.PluginImplementationFileFinder;
import org.tizen.web.tv.sec.nacl.mtwizard.Helpers;
import org.tizen.web.tv.sec.nacl.mtwizard.IAddMessageDialog;
import org.tizen.web.tv.sec.nacl.mtwizard.MessageDialog;
import org.tizen.web.tv.sec.nacl.mtwizard.Messages;
import org.tizen.web.tv.sec.nacl.mtwizard.SourceGeneratorRunner;

public class AddMessageDialog
extends Dialog
implements IAddMessageDialog {
    protected Shell shlAddMessage;
    private Text javaScriptFilePath;
    private FileDialog sourceFileDialog;
    private Table messagesTable;
    private Text nativeLanguagefilePath;
    private FormData fdnativeLanguageFilePath;
    private Combo nativeLanguageCombo;
    private Text textNaClModuleName;
    private static final int NAME_IDX = 0;
    private static final int MIN_DIALOG_WIDTH = 780;
    private static final int MIN_DIALOG_HEIGHT = 500;
    private static final float[] COLUMNS_RELATIVE_WIDTH = new float[]{0.1f, 0.1f, 0.7f, 0.1f};
    private static final int INITIAL_COLUMN_WIDTH = 100;
    private static final int WIDGETS_CLEARANCE = 6;
    private static final String SCRIPTS_FOLDER = "scripts";
    private static final String JAVASCRIPT_DEFAULT_FILENAME = "communication.js";
    static SourceGeneratorRunner sourceGeneratorRunner = null;
    private static String jsFilePath;
    private static String cppFilePath;
    private FormData fdmessagesTable;
    private final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private final SelectionAdapter btnBrowseJsHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            String filePath = AddMessageDialog.this.prepareSourceFileDialog(jsFilePath);
            if (filePath != null) {
                AddMessageDialog.this.javaScriptFilePath.setText(filePath);
                jsFilePath = filePath;
            }
        }
    };
    private final SelectionAdapter btnBrowseNativeHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            String filePath = AddMessageDialog.this.prepareSourceFileDialog(cppFilePath);
            if (filePath != null) {
                AddMessageDialog.this.nativeLanguagefilePath.setText(filePath);
                AddMessageDialog.this.nativeLanguageCombo.setText(NativeLanguageDetector.detectLanguageFromFilePath((String)filePath).toString());
                cppFilePath = filePath;
            }
        }
    };
    private final ControlAdapter messagesTableResized = new ControlAdapter(){

        public void controlResized(ControlEvent ev) {
            int colWidthIndex = 0;
            TableColumn[] tableColumnArray = AddMessageDialog.this.messagesTable.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tc = tableColumnArray[n2];
                if (colWidthIndex >= COLUMNS_RELATIVE_WIDTH.length) {
                    AddMessageDialog.this.logger.warning("Could not set the column no. " + colWidthIndex + " width. The index is out of the " + "COLUMN_RELATIVE_WIDTH array's bounds.");
                    break;
                }
                tc.setWidth((int)((float)((AddMessageDialog)AddMessageDialog.this).messagesTable.getSize().x * COLUMNS_RELATIVE_WIDTH[colWidthIndex++]) - 1);
                ++n2;
            }
        }
    };
    private final MouseAdapter messagesTableDblClicked = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent ev) {
            TableItem ti = AddMessageDialog.this.messagesTable.getItem(new Point(ev.x, ev.y));
            if (ti != null) {
                MessageDialog naclMessageDialog = new MessageDialog(AddMessageDialog.this.shlAddMessage, 65536);
                naclMessageDialog.setEditedMsgTableItem(ti);
                int result = naclMessageDialog.open();
                AddMessageDialog.this.logger.log(Level.FINEST, "result: " + result);
                if (result == 32) {
                    Helpers.fillTableWithMessages(AddMessageDialog.this.messagesTable, sourceGeneratorRunner);
                }
            }
        }
    };
    private final SelectionAdapter btnAddNaClMessageClicked = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            MessageDialog naclMessageDialog = new MessageDialog(AddMessageDialog.this.shlAddMessage, 65536);
            int result = naclMessageDialog.open();
            AddMessageDialog.this.logger.log(Level.FINEST, "result: " + result);
            if (result == 32) {
                Helpers.fillTableWithMessages(AddMessageDialog.this.messagesTable, sourceGeneratorRunner);
            }
        }
    };
    private final SelectionAdapter btnGenerateClicked = new SelectionAdapter(){
        ISourceGenerator.Result genResult;

        public void widgetSelected(SelectionEvent ev) {
            final Display display = Display.getCurrent();
            if (display == null) {
                Helpers.errorMessage(AddMessageDialog.this.shlAddMessage, Messages.AddMessageDialogCouldNotGetCurrentDisplay);
            }
            if (AddMessageDialog.this.getLanguage() == NativeLanguage.UNKNOWN) {
                Helpers.errorMessage(AddMessageDialog.this.shlAddMessage, Messages.AddMessageDialogCantGenerateWithUnknownLanguage);
                return;
            }
            Job job = new Job(Messages.AddMessageDialogGeneratorJobName){

                public IStatus run(IProgressMonitor monitor) {
                    AddMessageDialog.this.logger.finest("Job started.");
                    genResult = sourceGeneratorRunner.parseAddMessageDialogData(AddMessageDialog.this, display, monitor);
                    AddMessageDialog.this.logger.finest("Job exiting, result: " + genResult);
                    return Status.OK_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    class ResultReporter
                    implements Runnable {
                        private final Shell shell;
                        private final ISourceGenerator.Result result;

                        public ResultReporter(Shell shell, ISourceGenerator.Result result) {
                            this.shell = shell;
                            this.result = result;
                        }

                        private void refreshProject() {
                            IProject project = ProjectUtils.getCurrentProject();
                            if (project != null) {
                                try {
                                    AddMessageDialog.this.logger.finest("Got project: " + project.getName() + ", refreshing.");
                                    project.refreshLocal(2, null);
                                }
                                catch (CoreException e) {
                                    AddMessageDialog.this.logger.log(Level.WARNING, "Could not refresh the project.", e);
                                }
                            }
                        }

                        @Override
                        public void run() {
                            if (this.result == ISourceGenerator.Result.Success) {
                                Helpers.informationMessage(this.shell, Messages.AddMessageDialogGenerationSucceeded);
                                this.shell.close();
                                this.refreshProject();
                                sourceGeneratorRunner.clearMessages();
                            } else if (this.result != ISourceGenerator.Result.CancelledByUser) {
                                String message = this.result.toString();
                                String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
                                if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0) {
                                    message = Helpers.breakMessageIntoLines(message, 72);
                                }
                                Helpers.errorMessage(this.shell, String.valueOf(Messages.AddMessageDialogGenerationFailedWithResult) + message);
                                this.refreshProject();
                            }
                        }
                    }
                    display.asyncExec((Runnable)new ResultReporter((this).AddMessageDialog.this.shlAddMessage, genResult));
                }
            });
            job.setUser(true);
            job.schedule();
        }
    };
    private final SelectionAdapter btnDeleteClicked = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent ev) {
            TableItem[] tableItemArray = AddMessageDialog.this.messagesTable.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem ti = tableItemArray[n2];
                boolean msgDeleted = sourceGeneratorRunner.deleteMessage(ti.getText(0));
                if (!msgDeleted) {
                    AddMessageDialog.this.logger.info("Message: " + ti.getText(0) + " not found, delete failed.");
                }
                ti.dispose();
                ++n2;
            }
        }
    };

    public AddMessageDialog(Shell parent, int style) {
        super(parent, style);
        this.setText(Messages.CommonStringsAddMessages);
        if (sourceGeneratorRunner == null) {
            sourceGeneratorRunner = new SourceGeneratorRunner();
        }
    }

    public void open() {
        this.createContents();
        this.shlAddMessage.open();
        this.shlAddMessage.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shlAddMessage.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void resizeDialogAsNeeded() {
        Point proposedSizeNative = this.nativeLanguagefilePath.computeSize(-1, this.nativeLanguagefilePath.getSize().y, true);
        Point proposedSizeJavaScript = this.javaScriptFilePath.computeSize(-1, this.javaScriptFilePath.getSize().y, true);
        int proposedWidth = Math.max(proposedSizeNative.x, proposedSizeJavaScript.x);
        int delta = proposedWidth - this.nativeLanguagefilePath.getSize().x;
        if (delta > 0) {
            Monitor[] monitors = Display.getCurrent().getMonitors();
            int maxMonitorWidth = -1;
            Monitor[] monitorArray = monitors;
            int n = monitors.length;
            int n2 = 0;
            while (n2 < n) {
                Monitor monitor = monitorArray[n2];
                if (monitor.getBounds().contains(this.shlAddMessage.getLocation())) {
                    maxMonitorWidth = monitor.getBounds().width;
                }
                ++n2;
            }
            int newWidth = Math.min(delta + this.shlAddMessage.getSize().x, maxMonitorWidth);
            this.shlAddMessage.setSize(newWidth, this.shlAddMessage.getSize().y);
            Helpers.centerShellRelativeToParent(this.getParent(), this.shlAddMessage);
        }
    }

    private void createContents() {
        this.shlAddMessage = new Shell(this.getParent(), 67696);
        this.shlAddMessage.setSize(780, 500);
        this.shlAddMessage.setMinimumSize(780, 500);
        Helpers.centerShellRelativeToParent(this.getParent(), this.shlAddMessage);
        this.shlAddMessage.setText(Messages.CommonStringsAddMessages);
        this.shlAddMessage.setLayout((Layout)new FormLayout());
        Label lblJavascriptFile = new Label((Composite)this.shlAddMessage, 0);
        FormData fdlblJavascriptFile = new FormData();
        fdlblJavascriptFile.left = new FormAttachment(0, 10);
        lblJavascriptFile.setLayoutData((Object)fdlblJavascriptFile);
        lblJavascriptFile.setText(Messages.AddMessageDialogJsFile);
        this.javaScriptFilePath = new Text((Composite)this.shlAddMessage, 2048);
        this.javaScriptFilePath.setEditable(false);
        FormData fdjsFileText = new FormData();
        fdjsFileText.top = new FormAttachment((Control)lblJavascriptFile, 0, 0x1000000);
        fdjsFileText.left = new FormAttachment((Control)lblJavascriptFile, 6);
        this.javaScriptFilePath.setLayoutData((Object)fdjsFileText);
        Button btnBrowseJs = new Button((Composite)this.shlAddMessage, 0);
        fdjsFileText.right = new FormAttachment((Control)btnBrowseJs, -6);
        btnBrowseJs.addSelectionListener((SelectionListener)this.btnBrowseJsHandler);
        FormData fdbtnBrowseJs = new FormData();
        fdbtnBrowseJs.right = new FormAttachment(100, -10);
        fdbtnBrowseJs.top = new FormAttachment((Control)lblJavascriptFile, 0, 0x1000000);
        btnBrowseJs.setLayoutData((Object)fdbtnBrowseJs);
        btnBrowseJs.setText(Messages.CommonStringsBrowse);
        this.sourceFileDialog = new FileDialog(this.shlAddMessage, 8192);
        Label lblCSourceCode = new Label((Composite)this.shlAddMessage, 0);
        fdlblJavascriptFile.top = new FormAttachment((Control)lblCSourceCode, 20);
        FormData fdlblCSourceCode = new FormData();
        fdlblCSourceCode.left = new FormAttachment(0, 10);
        lblCSourceCode.setLayoutData((Object)fdlblCSourceCode);
        lblCSourceCode.setText(Messages.AddMessageDialogNativeFile);
        this.nativeLanguagefilePath = new Text((Composite)this.shlAddMessage, 2048);
        this.nativeLanguagefilePath.setEditable(false);
        this.fdnativeLanguageFilePath = new FormData();
        this.fdnativeLanguageFilePath.left = new FormAttachment((Control)lblCSourceCode, 6);
        this.fdnativeLanguageFilePath.top = new FormAttachment(0, 6);
        this.nativeLanguagefilePath.setLayoutData((Object)this.fdnativeLanguageFilePath);
        fdlblCSourceCode.top = new FormAttachment((Control)this.nativeLanguagefilePath, 0, 0x1000000);
        this.nativeLanguageCombo = new Combo((Composite)this.shlAddMessage, 8);
        this.nativeLanguageCombo.setToolTipText(Messages.AddMessageDialogNativeLanguageComboToolTipText);
        this.nativeLanguageCombo.add(NativeLanguage.CPP.toString());
        this.nativeLanguageCombo.add(NativeLanguage.C.toString());
        this.nativeLanguageCombo.add(NativeLanguage.UNKNOWN.toString());
        FormData fdNativeLanguageCombo = new FormData();
        fdNativeLanguageCombo.top = new FormAttachment((Control)lblCSourceCode, 0, 0x1000000);
        this.nativeLanguageCombo.setLayoutData((Object)fdNativeLanguageCombo);
        this.nativeLanguageCombo.select(0);
        IProject currentProject = ProjectUtils.getCurrentProject();
        if (currentProject != null && currentProject.isAccessible()) {
            String filePath;
            String projectPath = Helpers.getCurrentProjectPath();
            try {
                PluginImplementationFileFinder pluginFinder = new PluginImplementationFileFinder(currentProject);
                filePath = pluginFinder.findPluginTranslationUnitPath();
                if (filePath != null) {
                    this.nativeLanguagefilePath.setText(filePath);
                    this.nativeLanguageCombo.setText(NativeLanguageDetector.detectLanguageFromFilePath((String)filePath).toString());
                    cppFilePath = filePath;
                } else {
                    cppFilePath = "";
                    this.nativeLanguagefilePath.setText(cppFilePath);
                    this.nativeLanguageCombo.setText(NativeLanguage.UNKNOWN.toString());
                    this.logger.warning("Could not find the plugin implementation.");
                }
            }
            catch (CoreException e) {
                this.logger.log(Level.WARNING, "Could not find the plugin implementation.", e);
            }
            filePath = String.valueOf(projectPath) + File.separator + SCRIPTS_FOLDER + File.separator + JAVASCRIPT_DEFAULT_FILENAME;
            this.javaScriptFilePath.setText(filePath);
            jsFilePath = filePath;
        } else {
            this.logger.warning("Could not find the current project or it is not available.");
            cppFilePath = "";
            this.nativeLanguagefilePath.setText(cppFilePath);
            this.nativeLanguageCombo.setText(NativeLanguage.UNKNOWN.toString());
            jsFilePath = "";
            this.javaScriptFilePath.setText(jsFilePath);
        }
        this.resizeDialogAsNeeded();
        Button btnBrowseNative = new Button((Composite)this.shlAddMessage, 0);
        this.fdnativeLanguageFilePath.right = new FormAttachment((Control)btnBrowseNative, -6);
        btnBrowseNative.addSelectionListener((SelectionListener)this.btnBrowseNativeHandler);
        FormData fdbtnBrowseNative = new FormData();
        fdbtnBrowseNative.top = new FormAttachment((Control)lblCSourceCode, 0, 0x1000000);
        fdbtnBrowseNative.right = new FormAttachment((Control)this.nativeLanguageCombo, -6);
        btnBrowseNative.setLayoutData((Object)fdbtnBrowseNative);
        btnBrowseNative.setText(Messages.CommonStringsBrowse);
        Group grpNaclMessages = new Group((Composite)this.shlAddMessage, 0);
        grpNaclMessages.setText(Messages.AddMessageDialogMessages);
        grpNaclMessages.setLayout((Layout)new FormLayout());
        FormData fdgrpNaclMessages = new FormData();
        fdgrpNaclMessages.top = new FormAttachment((Control)btnBrowseJs, 5);
        fdgrpNaclMessages.right = new FormAttachment(100, -10);
        fdgrpNaclMessages.left = new FormAttachment(0, 10);
        grpNaclMessages.setLayoutData((Object)fdgrpNaclMessages);
        this.messagesTable = new Table((Composite)grpNaclMessages, 68096);
        this.messagesTable.addControlListener((ControlListener)this.messagesTableResized);
        this.fdmessagesTable = new FormData();
        this.fdmessagesTable.right = new FormAttachment(100, -6);
        this.fdmessagesTable.top = new FormAttachment(0, 7);
        this.fdmessagesTable.left = new FormAttachment(0, 7);
        this.messagesTable.setLayoutData((Object)this.fdmessagesTable);
        this.messagesTable.setToolTipText(Messages.AddMessageDialogDblClickToEditMsg);
        this.messagesTable.addMouseListener((MouseListener)this.messagesTableDblClicked);
        this.messagesTable.setHeaderVisible(true);
        this.messagesTable.setLinesVisible(true);
        TableColumn tblclmnName = new TableColumn(this.messagesTable, 0);
        tblclmnName.setWidth(100);
        tblclmnName.setText(Messages.CommonStringsName);
        TableColumn tblclmnFrom = new TableColumn(this.messagesTable, 0);
        tblclmnFrom.setWidth(100);
        tblclmnFrom.setText(Messages.AddMessageDialogFrom);
        TableColumn tblclmnData = new TableColumn(this.messagesTable, 0);
        tblclmnData.setWidth(100);
        tblclmnData.setText(Messages.CommonStringsData);
        TableColumn tblclmnSync = new TableColumn(this.messagesTable, 0);
        tblclmnSync.setWidth(100);
        tblclmnSync.setText(Messages.CommonStringsSynchronous);
        Helpers.fillTableWithMessages(this.messagesTable, sourceGeneratorRunner);
        Button btnAddNaclMessage = new Button((Composite)grpNaclMessages, 0);
        this.fdmessagesTable.bottom = new FormAttachment((Control)btnAddNaclMessage, -6);
        FormData fdbtnAddNaclMessage = new FormData();
        fdbtnAddNaclMessage.bottom = new FormAttachment(100, -6);
        fdbtnAddNaclMessage.left = new FormAttachment(0, 10);
        btnAddNaclMessage.setLayoutData((Object)fdbtnAddNaclMessage);
        btnAddNaclMessage.addSelectionListener((SelectionListener)this.btnAddNaClMessageClicked);
        btnAddNaclMessage.setText(Messages.CommonStringsAdd);
        Button btnGenerate = new Button((Composite)this.shlAddMessage, 0x800000);
        btnGenerate.addSelectionListener((SelectionListener)this.btnGenerateClicked);
        FormData fdbtnGenerate = new FormData();
        fdbtnGenerate.top = new FormAttachment((Control)grpNaclMessages, 6);
        btnGenerate.setLayoutData((Object)fdbtnGenerate);
        btnGenerate.setText(Messages.AddMessageDialogGenerate);
        Button btnDelete = new Button((Composite)grpNaclMessages, 0);
        btnDelete.addSelectionListener((SelectionListener)this.btnDeleteClicked);
        btnDelete.setText(Messages.CommonStringsDelete);
        FormData fdbtnDelete = new FormData();
        fdbtnDelete.top = new FormAttachment((Control)btnAddNaclMessage, 0, 0x1000000);
        fdbtnDelete.left = new FormAttachment((Control)btnAddNaclMessage, 6);
        btnDelete.setLayoutData((Object)fdbtnDelete);
        Label lblNaclModuleName = new Label((Composite)this.shlAddMessage, 0);
        fdNativeLanguageCombo.right = new FormAttachment((Control)lblNaclModuleName, -6);
        FormData fdlblNaclModuleName = new FormData();
        fdlblNaclModuleName.top = new FormAttachment((Control)lblCSourceCode, 0, 0x1000000);
        lblNaclModuleName.setLayoutData((Object)fdlblNaclModuleName);
        lblNaclModuleName.setText(Messages.AddMessageDialog_lblNaclModuleName_text);
        this.textNaClModuleName = new Text((Composite)this.shlAddMessage, 2048);
        fdlblNaclModuleName.right = new FormAttachment((Control)this.textNaClModuleName, -6);
        FormData fdnaClModuleName = new FormData();
        fdnaClModuleName.top = new FormAttachment((Control)lblCSourceCode, 0, 0x1000000);
        fdnaClModuleName.right = new FormAttachment((Control)btnBrowseJs, 0, 131072);
        this.textNaClModuleName.setLayoutData((Object)fdnaClModuleName);
        this.textNaClModuleName.setText("nacl_module");
        this.textNaClModuleName.setToolTipText(Messages.AddMessageDialogModuleNameInputTooltip);
        Button btnCancel = new Button((Composite)this.shlAddMessage, 0);
        fdbtnGenerate.right = new FormAttachment((Control)btnCancel, -6);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AddMessageDialog.this.shlAddMessage.dispose();
            }
        });
        FormData fdbtnCancel = new FormData();
        fdbtnCancel.right = new FormAttachment((Control)btnBrowseJs, 0, 131072);
        fdbtnCancel.bottom = new FormAttachment(100, -6);
        btnCancel.setLayoutData((Object)fdbtnCancel);
        btnCancel.setText(Messages.AddMessageDialog_btnCancel_text);
        fdgrpNaclMessages.bottom = new FormAttachment((Control)btnCancel, -6);
    }

    @Override
    public String getJsFilePath() {
        return this.javaScriptFilePath.getText();
    }

    @Override
    public String getCFilePath() {
        return this.nativeLanguagefilePath.getText();
    }

    @Override
    public Collection<Message> getMessages() {
        return sourceGeneratorRunner.getMessages().values();
    }

    @Override
    public NativeLanguage getLanguage() {
        if (this.nativeLanguageCombo.getText().equals(NativeLanguage.CPP.toString())) {
            return NativeLanguage.CPP;
        }
        if (this.nativeLanguageCombo.getText().equals(NativeLanguage.C.toString())) {
            return NativeLanguage.C;
        }
        return NativeLanguage.UNKNOWN;
    }

    @Override
    public Shell getShell() {
        return this.shlAddMessage;
    }

    @Override
    public String getNaClModuleName() {
        return this.textNaClModuleName.getText();
    }

    private String prepareSourceFileDialog(String sourceFilePath) {
        String sourceFileDir = null;
        if (sourceFilePath != null && !sourceFilePath.isEmpty()) {
            this.sourceFileDialog.setFileName(sourceFilePath);
            sourceFileDir = new File(sourceFilePath).getParent();
        }
        if (sourceFileDir != null && new File(sourceFileDir).exists()) {
            this.sourceFileDialog.setFilterPath(sourceFileDir);
        } else {
            IProject project = ProjectUtils.getCurrentProject();
            if (project != null) {
                this.sourceFileDialog.setFilterPath(project.getLocation().toString());
            }
        }
        String filePath = this.sourceFileDialog.open();
        return filePath;
    }
}

