/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.mtwizard;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.nacl.mtgenerator.ISourceGenerator;
import org.tizen.web.tv.sec.nacl.mtgenerator.Message;
import org.tizen.web.tv.sec.nacl.mtgenerator.SourceGenerator;
import org.tizen.web.tv.sec.nacl.mtwizard.Helpers;
import org.tizen.web.tv.sec.nacl.mtwizard.IAddMessageDialog;
import org.tizen.web.tv.sec.nacl.mtwizard.Messages;

class SourceGeneratorRunner {
    private HashMap<String, Message> messages = new HashMap();

    SourceGeneratorRunner() {
    }

    private ISourceGenerator.Result generateSourceCode(String jsFilePath, String cppFilePath, NativeLanguage nativeLanguage, String naClModuleName, Collection<Message> messages, IProgressMonitor progressMonitor) {
        SourceGenerator sourceGenerator = new SourceGenerator();
        return sourceGenerator.addMessages(jsFilePath, cppFilePath, nativeLanguage, naClModuleName, messages, progressMonitor);
    }

    public ISourceGenerator.Result parseAddMessageDialogData(IAddMessageDialog dialog, Display display, IProgressMonitor progressMonitor) {
        String[] filePaths;
        class DialogDataRetriever
        implements Runnable {
            public IAddMessageDialog dialog;
            public String jsFilePath;
            public String cppFilePath;
            public NativeLanguage language;
            public String naClModuleName;
            public Collection<Message> messages;

            public DialogDataRetriever(IAddMessageDialog dialog) {
                this.dialog = dialog;
            }

            @Override
            public void run() {
                this.jsFilePath = this.dialog.getJsFilePath();
                this.cppFilePath = this.dialog.getCFilePath();
                this.language = this.dialog.getLanguage();
                this.naClModuleName = this.dialog.getNaClModuleName();
                this.messages = this.dialog.getMessages();
            }
        }
        DialogDataRetriever ddr = new DialogDataRetriever(dialog);
        display.syncExec((Runnable)ddr);
        if (ddr.jsFilePath.isEmpty()) {
            return ISourceGenerator.Result.JsFileNameEmpty;
        }
        if (ddr.cppFilePath.isEmpty()) {
            return ISourceGenerator.Result.CppFileNameEmpty;
        }
        if (ddr.cppFilePath.equals(ddr.jsFilePath)) {
            return ISourceGenerator.Result.JsAndCppFilesPathIsTheSame;
        }
        String[] stringArray = filePaths = new String[]{ddr.cppFilePath, ddr.jsFilePath};
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            if (!new File(filePath).exists()) {
                class Messenger
                implements Runnable {
                    private final Shell shell;
                    private final String filePath;
                    public int userResponse;

                    public Messenger(Shell shell, String filePath) {
                        this.shell = shell;
                        this.filePath = filePath;
                    }

                    @Override
                    public void run() {
                        this.userResponse = Helpers.confirmationMessage(this.shell, String.valueOf(Messages.SourceGeneratorRunnerTheFile) + this.filePath + Messages.SourceGeneratorRunnerDoesNotExistWillBeGenerated);
                    }
                }
                Messenger msger = new Messenger(dialog.getShell(), filePath);
                display.syncExec((Runnable)msger);
                if (msger.userResponse != 64) {
                    return ISourceGenerator.Result.CancelledByUser;
                }
            }
            ++n2;
        }
        return this.generateSourceCode(ddr.jsFilePath, ddr.cppFilePath, ddr.language, ddr.naClModuleName, ddr.messages, progressMonitor);
    }

    public boolean addMessage(Message msg) {
        boolean messageAlreadyExists = this.messages.containsKey(msg.getName());
        this.messages.put(msg.getName(), msg);
        return messageAlreadyExists;
    }

    public boolean deleteMessage(String name) {
        return this.messages.remove(name) != null;
    }

    public void clearMessages() {
        this.messages.clear();
    }

    public Message getMessage(String name) {
        return this.messages.get(name);
    }

    public Map<String, Message> getMessages() {
        return this.messages;
    }
}

