/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.project_wizards;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.tizen.web.tv.sec.nacl.common.FileToCopy;
import org.tizen.web.tv.sec.nacl.common.GeneralTools;
import org.tizen.web.tv.sec.nacl.project_wizards.Messages;
import org.tizen.web.tv.sec.nacl.project_wizards.PNaClProjectProvider;
import org.tizen.web.tv.sec.nacl.project_wizards.PluginConfig;
import org.tizen.web.tv.sec.nacl.project_wizards.ProjectData;

public class CreateProjectExample
extends PNaClProjectProvider {
    public CreateProjectExample(IProgressMonitor monitor) {
        this.progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating example project", (int)100);
    }

    @Override
    protected boolean getFilesToCopy(ProjectData projectData, List<FileToCopy> filesOut) {
        return PluginConfig.getInstance().getExampleFiles(projectData.contentData.projectSource, filesOut);
    }

    @Override
    protected String prepareForProjectType(ProjectData projectData) {
        String jsPath = String.valueOf(projectData.basicProjectInfo.projectPath) + File.separator + "scripts" + File.separator + "example.js";
        boolean retVal = this.prepareProjectJs(projectData, this.getNmfPath(projectData), jsPath);
        if (retVal) {
            retVal = this.prepareIndexHtml(projectData, this.getNmfPath(projectData));
        }
        if (!retVal) {
            return Messages.CreateProjectTemplate_FailedToGenJS;
        }
        return "";
    }

    private boolean prepareIndexHtml(ProjectData projectData, String nmfPath) {
        String filePath = String.valueOf(projectData.basicProjectInfo.projectPath) + File.separator + "index.html";
        String[][] toFindAndReplace = new String[][]{{"<nmf_file>", nmfPath}};
        return GeneralTools.replaceStringsInFile((String)filePath, (String[][])toFindAndReplace);
    }
}

