/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.project_wizards;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.internal.core.CodanPreferencesLoader;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionWorkspacePreferences;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuiltinSpecsDetector;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.tizen.web.tv.sec.nacl.common.EditXML;
import org.tizen.web.tv.sec.nacl.common.FileToCopy;
import org.tizen.web.tv.sec.nacl.common.GeneralTools;
import org.tizen.web.tv.sec.nacl.common.LoggerInitializer;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.nacl.mtgenerator.CodeGeneratorHelper;
import org.tizen.web.tv.sec.nacl.mtgenerator.PluginImplementationFileFinder;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;
import org.tizen.web.tv.sec.nacl.project_wizards.Activator;
import org.tizen.web.tv.sec.nacl.project_wizards.CreateProjectEmpty;
import org.tizen.web.tv.sec.nacl.project_wizards.CreateProjectExample;
import org.tizen.web.tv.sec.nacl.project_wizards.CreateProjectTemplate;
import org.tizen.web.tv.sec.nacl.project_wizards.Messages;
import org.tizen.web.tv.sec.nacl.project_wizards.PluginConfig;
import org.tizen.web.tv.sec.nacl.project_wizards.ProjectData;

public abstract class PNaClProjectProvider {
    public static final String NACL_PLUGIN_DEFAULT_HEADER_PATH_C = "inc/plugin.h";
    public static final String NACL_PLUGIN_DEFAULT_HEADER_PATH_CPP = "inc/plugin.hpp";
    public static final String NACL_PLUGIN_DEFAULT_SOURCE_PATH_C = "src/plugin.c";
    public static final String NACL_PLUGIN_DEFAULT_SOURCE_PATH_CPP = "src/plugin.cpp";
    private static final String LINKER_NACL_C_CPP_ID = "toolchain.linker.c";
    private static final String[] LINKER_LIBS = new String[]{"org.tizen.web.tv.sec.nacl.builder.toolchain.linker.cpp.glibc.libs", "org.tizen.web.tv.sec.nacl.builder.toolchain.linker.cpp.libs", "org.tizen.web.tv.sec.nacl.builder.toolchain.linker.c.glibc.libs", "org.tizen.web.tv.sec.nacl.builder.toolchain.linker.c.libs"};
    private static final String GCC_BUILTIN_SPECS_DETECTOR_NAME = "org.eclipse.cdt.managedbuilder.core.GCCBuiltinSpecsDetector";
    private static final String BUILTIN_COMPILER_SETTINGS_COMMAND_PNACL = "${COMMAND}${PNACL_TOOLS_POSTFIX} ${FLAGS} -E -v -dD -xc++ \"${INPUTS}\"";
    private static final String INCLUDE_OPTION_ID = "org.tizen.web.tv.sec.nacl.builder.toolchain.compiler.include";
    protected SubMonitor progress;
    private static final Logger logger = PNaClProjectProvider.initializeLogger();
    private final String buildDir = "CurrentBin";
    protected final String scriptsDir = "scripts";

    public static PNaClProjectProvider create(ProjectData.ProjectType projectType, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create project", (int)100);
        PNaClProjectProvider retObject = null;
        switch (projectType) {
            case Empty: {
                retObject = new CreateProjectEmpty((IProgressMonitor)progress.newChild(100));
                break;
            }
            case Example: {
                retObject = new CreateProjectExample((IProgressMonitor)progress.newChild(100));
                break;
            }
            case Template: {
                retObject = new CreateProjectTemplate((IProgressMonitor)progress.newChild(100));
                break;
            }
            default: {
                Logger.getGlobal().severe("Unknown project type. Can't create project. " + (Object)((Object)projectType));
            }
        }
        return retObject;
    }

    private static String generatePackageId() {
        char[] charset = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
        char[] result = new char[10];
        SecureRandom rand = new SecureRandom();
        int loop = 0;
        while (loop < result.length) {
            int randomCharIndex = rand.nextInt(charset.length);
            result[loop] = charset[randomCharIndex];
            ++loop;
        }
        return new String(result);
    }

    private static int getPepperVersion(IProject project) throws IllegalArgumentException {
        if (project == null) {
            throw new IllegalArgumentException("Null value passed");
        }
        INaclPreferences preferences = NaclPreferenceActivator.getDefault().getNaclPreferences();
        Preferences node = preferences.getProjectPreferences(project);
        if (node == null) {
            return -1;
        }
        String pepperVersionStr = node.get("pepperVersion", "");
        return GeneralTools.parseLastInt((String)pepperVersionStr);
    }

    private static Logger initializeLogger() {
        try {
            LoggerInitializer.initialize((String)"%t/pnacl_project_provider%u.log", (Level)Level.INFO);
        }
        catch (IOException | SecurityException ex) {
            System.err.println("Could not initialize the logger");
            ex.printStackTrace();
        }
        return Logger.getLogger(PNaClProjectProvider.class.getClass().getPackage().getName());
    }

    private void addAdditionalLibsToLink(IProject project, List<String> requiredLibraries) {
        boolean modified = false;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] configs = info.getManagedProject().getConfigurations();
        if (configs == null) {
            return;
        }
        try {
            IConfiguration[] iConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration conf = iConfigurationArray[n2];
                ITool[] tools = conf.getTools();
                int j = 0;
                while (j < tools.length) {
                    String tmpToolId = tools[j].getId();
                    if (tmpToolId.contains(LINKER_NACL_C_CPP_ID) && this.addLinkIncludeInConfig(conf, tools[j].getOptions(), tools[j], requiredLibraries)) {
                        modified = true;
                    }
                    ++j;
                }
                ++n2;
            }
        }
        catch (BuildException be) {
            System.out.println(be.toString());
        }
        if (modified) {
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
    }

    private void addBuiltinSpecsDetectorProvider(ICConfigurationDescription cfgDes) {
        if (!(cfgDes instanceof ILanguageSettingsProvidersKeeper)) {
            logger.log(Level.WARNING, "Passed configuration description is not of ILanguageSettingsProvidersKeeper instance");
            return;
        }
        boolean isPnaclConfiguration = cfgDes.getName().toLowerCase().contains("pnacl");
        ILanguageSettingsProvider builtinProvider = LanguageSettingsManager.getWorkspaceProvider((String)GCC_BUILTIN_SPECS_DETECTOR_NAME);
        if (builtinProvider == null) {
            logger.log(Level.WARNING, "Could not find the language settings provider: org.eclipse.cdt.managedbuilder.core.GCCBuiltinSpecsDetector");
            return;
        }
        AbstractBuiltinSpecsDetector rawProvider = (AbstractBuiltinSpecsDetector)LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)builtinProvider);
        AbstractBuiltinSpecsDetector editableProvider = (AbstractBuiltinSpecsDetector)LanguageSettingsManager.getProviderCopy((ILanguageSettingsEditableProvider)((ILanguageSettingsEditableProvider)rawProvider), (boolean)false);
        if (editableProvider == null) {
            logger.log(Level.WARNING, "Copying of the language settings provider is not allowed: org.eclipse.cdt.managedbuilder.core.GCCBuiltinSpecsDetector");
            return;
        }
        if (isPnaclConfiguration) {
            editableProvider.setCommand(BUILTIN_COMPILER_SETTINGS_COMMAND_PNACL);
        }
        String[] defaultIds = ScannerDiscoveryLegacySupport.getDefaultProviderIdsLegacy((ICConfigurationDescription)cfgDes);
        ((ILanguageSettingsProvidersKeeper)cfgDes).setDefaultLanguageSettingsProvidersIds(defaultIds);
        List providers = LanguageSettingsManager.createLanguageSettingsProviders((String[])defaultIds);
        if (providers.contains(editableProvider)) {
            editableProvider = (AbstractBuiltinSpecsDetector)providers.get(providers.indexOf(editableProvider));
            if (isPnaclConfiguration) {
                editableProvider.setCommand(BUILTIN_COMPILER_SETTINGS_COMMAND_PNACL);
            }
        } else {
            providers.add(editableProvider);
        }
        ((ILanguageSettingsProvidersKeeper)cfgDes).setLanguageSettingProviders(providers);
    }

    private boolean addLinkIncludeInConfig(IConfiguration conf, IOption[] options, ITool tool, List<String> requiredLibraries) throws BuildException {
        boolean added = false;
        int i = 0;
        while (i < options.length) {
            IOption option = options[i];
            String tmpOptionName = option.getId();
            if (Arrays.stream(LINKER_LIBS).anyMatch(libsOptId -> tmpOptionName.equals(libsOptId))) {
                String[] libraries = option.getBasicStringListValue();
                String[] newLibs = new String[requiredLibraries.size()];
                newLibs = requiredLibraries.toArray(newLibs);
                String[] updatedLibs = new String[libraries.length + newLibs.length];
                System.arraycopy(libraries, 0, updatedLibs, 0, libraries.length);
                System.arraycopy(newLibs, 0, updatedLibs, libraries.length, newLibs.length);
                ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)tool, (IOption)option, (String[])updatedLibs);
                added = true;
            }
            ++i;
        }
        return added;
    }

    private boolean addManagedBuilder(IProject project) {
        ICProjectDescription des;
        try {
            des = CoreModel.getDefault().createProjectDescription(project, true);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            return false;
        }
        IProjectType projType = ManagedBuildManager.getExtensionProjectType((String)"org.tizen.web.tv.sec.nacl.builder.toolchain");
        ManagedBuildManager.createBuildInfo((IResource)project);
        IManagedProject managedProject = null;
        try {
            managedProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        }
        catch (BuildException e) {
            e.printStackTrace();
            return false;
        }
        IConfiguration[] buildConfigs = projType.getConfigurations();
        int pepperVersion = -1;
        try {
            pepperVersion = PNaClProjectProvider.getPepperVersion(project);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        IConfiguration[] iConfigurationArray = buildConfigs;
        int n = buildConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration icf = iConfigurationArray[n2];
            if (pepperVersion >= 47 || !icf.getName().toLowerCase().contains("glibc")) {
                String id = ManagedBuildManager.calculateChildId((String)icf.getId(), null);
                IConfiguration config = managedProject.createConfiguration(icf, id);
                config.setArtifactName("${ProjName}");
                IBuilder builder = config.getEditableBuilder();
                try {
                    if (builder != null) {
                        builder.setManagedBuildOn(true);
                    }
                    ICConfigurationDescription cfgDes = des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", config.getConfigurationData());
                    this.addBuiltinSpecsDetectorProvider(cfgDes);
                }
                catch (WriteAccessException | CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            ++n2;
        }
        try {
            ICProjectDescriptionManager mgr = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescriptionWorkspacePreferences prefs = mgr.getProjectDescriptionWorkspacePreferences(true);
            prefs.setConfigurationRelations(2);
            mgr.setProjectDescriptionWorkspacePreferences(prefs, true, null);
            CoreModel.getDefault().setProjectDescription(project, des);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void addToolchainsOptions(IProject newProject, ProjectData projectData) {
        if (projectData.contentData.projectType == ProjectData.ProjectType.Example) {
            ProjectData.CompilersOptions options = PluginConfig.getInstance().getCompilersOptionsForExample(projectData.contentData.projectSource);
            if (options.isEmpty()) {
                return;
            }
            ProjectData.CompilerType[] compilerTypeArray = ProjectData.CompilerType.values();
            int n = compilerTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectData.CompilerType compilerType = compilerTypeArray[n2];
                if (options.containsKey((Object)compilerType)) {
                    this.addToolOption(newProject, compilerType.getId(), (Collection)options.get((Object)compilerType));
                }
                ++n2;
            }
        } else {
            if (projectData.contentData.headerFilePath == null || projectData.contentData.headerFilePath.isEmpty()) {
                return;
            }
            StringBuilder includePathForPluginHeader = new StringBuilder().append("${workspace_loc:/").append(newProject.getName()).append("/").append(new File(projectData.contentData.headerFilePath).getParent().toString()).append("}");
            this.addToolOption(newProject, INCLUDE_OPTION_ID, new ArrayList<String>(Arrays.asList(includePathForPluginHeader.toString())));
        }
    }

    private void addToolOption(IProject newProject, String optionId, Collection<String> optionString) {
        if (newProject == null || optionId == null || optionString == null) {
            return;
        }
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)newProject);
        if (buildInfo == null) {
            return;
        }
        if (optionString.isEmpty()) {
            return;
        }
        boolean needsUpdate = false;
        IConfiguration[] iConfigurationArray = buildInfo.getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITool[] tools;
            IConfiguration config = iConfigurationArray[n2];
            ITool[] iToolArray = tools = config.getTools();
            int n3 = tools.length;
            int n4 = 0;
            while (n4 < n3) {
                block13: {
                    ITool tool = iToolArray[n4];
                    IOption option = tool.getOptionById(optionId);
                    if (option != null) {
                        try {
                            List<String> existingOptions;
                            switch (option.getValueType()) {
                                case 4: {
                                    existingOptions = Arrays.asList(option.getIncludePaths());
                                    break;
                                }
                                case 3: {
                                    existingOptions = Arrays.asList(option.getStringListValue());
                                    break;
                                }
                                default: {
                                    break block13;
                                }
                            }
                            ArrayList<String> newOptions = new ArrayList<String>(existingOptions);
                            newOptions.addAll(optionString);
                            String[] newOptionsArray = new String[existingOptions.size()];
                            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)tool, (IOption)option, (String[])newOptions.toArray(newOptionsArray));
                            needsUpdate = true;
                        }
                        catch (BuildException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (needsUpdate) {
            ManagedBuildManager.saveBuildInfo((IProject)newProject, (boolean)true);
        }
    }

    private boolean copyFilesToProject(ProjectData projectData) {
        boolean result = true;
        ArrayList<FileToCopy> filesToCopy = new ArrayList<FileToCopy>();
        this.getFilesToCopy(projectData, filesToCopy);
        for (FileToCopy currentFile : filesToCopy) {
            boolean isPluginSource = false;
            FileToCopy fileToCopy = currentFile;
            if (projectData.contentData.projectType != ProjectData.ProjectType.Example) {
                if (currentFile.getDestination().startsWith(NACL_PLUGIN_DEFAULT_SOURCE_PATH_C)) {
                    fileToCopy = new FileToCopy(currentFile.getSource(), projectData.contentData.sourceFilePath);
                    isPluginSource = true;
                }
                if (currentFile.getDestination().startsWith(NACL_PLUGIN_DEFAULT_HEADER_PATH_C)) {
                    fileToCopy = new FileToCopy(currentFile.getSource(), projectData.contentData.headerFilePath);
                }
            }
            String destPathName = String.valueOf(projectData.basicProjectInfo.projectPath) + File.separator + fileToCopy.getDestination();
            long bytesCopied = 0L;
            try {
                URL temp = Activator.getDefault().getBundle().getEntry(fileToCopy.getSource());
                InputStream srcStream = temp.openStream();
                Files.createDirectories(Paths.get(destPathName, new String[0]), new FileAttribute[0]);
                bytesCopied = Files.copy(srcStream, Paths.get(destPathName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                if (isPluginSource) {
                    CodeGeneratorHelper.insertTextIntoFile((String)destPathName, (long)0L, (String)("#include \"" + new File(projectData.contentData.headerFilePath).getName() + "\"" + System.lineSeparator()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Logger.getGlobal().finer("Copied file: " + fileToCopy.getDestination() + ", bytes " + bytesCopied);
            boolean bl = result = bytesCopied >= 0L;
        }
        return result;
    }

    private IProject createBaseProject(String projectName, String projectPath, NativeLanguage language) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        Assert.isNotNull((Object)newProject);
        if (!newProject.exists()) {
            URI uriWorkspaceRoot;
            IProjectDescription desc = newProject.getWorkspace().newProjectDescription(newProject.getName());
            URI uriProjectLocation = null;
            if (projectPath != null && Objects.equals(uriProjectLocation = Paths.get(projectPath, new String[0]).toUri(), uriWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocationURI())) {
                uriProjectLocation = null;
            }
            desc.setLocationURI(uriProjectLocation);
            desc.setNatureIds(PluginConfig.getInstance().getNatureIDs(language));
            desc.setBuildConfigs(PluginConfig.getInstance().getBuildConfigs());
            this.setBuildSpec(desc);
            try {
                newProject.create(desc, null);
                if (!newProject.isOpen()) {
                    newProject.open(null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            Logger.getGlobal().log(Level.SEVERE, "Can't create project. Project with name " + projectName + " is already in workspace.");
            return null;
        }
        return newProject;
    }

    public IProject createProject(ProjectData projectData) throws CoreException {
        Assert.isNotNull((Object)projectData.basicProjectInfo.projectName);
        Assert.isTrue((!projectData.basicProjectInfo.projectName.trim().isEmpty() ? 1 : 0) != 0);
        String projPath = projectData.basicProjectInfo.itsDefaultPath ? null : projectData.basicProjectInfo.projectPath;
        IProject newProject = this.createBaseProject(projectData.basicProjectInfo.projectName, projPath, projectData.basicProjectInfo.language);
        this.progress.setWorkRemaining(90);
        if (newProject == null) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.project_wizards", Messages.PNaClProjectProvider_FailedToCopyFiles));
        }
        Preferences preferences = PluginConfig.getInstance().getPreferences(newProject);
        preferences.put("pepperVersion", projectData.basicProjectInfo.toolchain);
        preferences.putBoolean("customPepperPath", projectData.basicProjectInfo.hasToolchainPath);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        this.addManagedBuilder(newProject);
        this.progress.setWorkRemaining(80);
        this.addToolchainsOptions(newProject, projectData);
        this.progress.setWorkRemaining(70);
        if (!this.copyFilesToProject(projectData)) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.project_wizards", Messages.PNaClProjectProvider_FailedToCopyFiles));
        }
        this.prepareConfigXml(projectData);
        this.progress.setWorkRemaining(60);
        String error = this.prepareForProjectType(projectData);
        this.progress.setWorkRemaining(50);
        newProject.refreshLocal(2, (IProgressMonitor)this.progress.newChild(5));
        if (!error.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.project_wizards", error));
        }
        if (projectData.contentData.requiredLibraries != null && !projectData.contentData.requiredLibraries.isEmpty()) {
            this.addAdditionalLibsToLink(newProject, projectData.contentData.requiredLibraries);
        }
        this.openFileInEditor(this.getPluginImplFile(newProject));
        this.progress.done();
        return newProject;
    }

    private void disableCodan(IProject project) {
        IProblem[] problems;
        ProjectScope ps = new ProjectScope(project);
        ScopedPreferenceStore sps = new ScopedPreferenceStore((IScopeContext)ps, "org.eclipse.cdt.codan.core");
        sps.setValue("useParentScope", false);
        ICheckersRegistry registry = CodanRuntime.getInstance().getCheckersRegistry();
        CodanPreferencesLoader defaults = new CodanPreferencesLoader(registry.getDefaultProfile());
        IProblem[] iProblemArray = problems = defaults.getProblems();
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            String id = problem.getId();
            String val = defaults.getProperty(id);
            if (!val.startsWith("-")) {
                val = "-" + val;
            }
            sps.setValue(id, val);
            ++n2;
        }
        try {
            sps.save();
        }
        catch (IOException ex) {
            Logger.getGlobal().log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    protected abstract boolean getFilesToCopy(ProjectData var1, List<FileToCopy> var2);

    protected String getNmfPath(ProjectData projectData) {
        return "CurrentBin/" + projectData.basicProjectInfo.projectName + ".nmf";
    }

    private IFile getPluginImplFile(IProject project) {
        try {
            PluginImplementationFileFinder pluginFinder = new PluginImplementationFileFinder(project);
            String strFilePath = pluginFinder.findPluginTranslationUnitPath();
            if (!strFilePath.isEmpty()) {
                String projFolder = PluginConfig.getInstance().getWorkspaceFolder();
                strFilePath = strFilePath.replace(projFolder, "");
                strFilePath = strFilePath.replace(File.separator, "/");
                return PluginConfig.getInstance().findProjectFile(strFilePath, (IContainer)project);
            }
        }
        catch (CoreException coreException) {
            Logger.getGlobal().severe(String.format("File with plugin implementation not found", new Object[0]));
        }
        return null;
    }

    private String normalizeToPackageName(String name) {
        return name.replaceAll("[^A-Za-z0-9]", "");
    }

    private boolean openFileInEditor(IFile projectFileToOpen) {
        IWorkbenchPage page;
        if (projectFileToOpen == null || !projectFileToOpen.exists()) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(projectFileToOpen.getName());
            try {
                page.openEditor((IEditorInput)new FileEditorInput(projectFileToOpen), desc.getId());
                return true;
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean prepareConfigXml(ProjectData projectData) {
        EditXML editXml = new EditXML();
        Point resulution = PluginConfig.getInstance().getWidgetScreenResolution(projectData.configurationData.screenResolutionIndex);
        if (editXml.openFile(String.valueOf(projectData.basicProjectInfo.projectPath) + File.separator + "config.xml", false)) {
            String packageName = PNaClProjectProvider.generatePackageId();
            editXml.edit("id", String.valueOf(packageName) + "." + this.normalizeToPackageName(projectData.basicProjectInfo.projectName), "tizen:application");
            editXml.edit("package", packageName, "tizen:application");
            editXml.edit("name", projectData.basicProjectInfo.projectName, null);
            editXml.edit("width", Integer.toString(resulution.x), "widget");
            editXml.edit("height", Integer.toString(resulution.y), "widget");
            return editXml.closeFile();
        }
        return false;
    }

    protected abstract String prepareForProjectType(ProjectData var1);

    protected boolean prepareProjectJs(ProjectData projectData, String nmfPath, String jsPath) {
        File file = new File(jsPath);
        if (file.exists() && !file.isDirectory()) {
            String[][] toFindAndReplace = new String[][]{{"<nmf_file>", nmfPath}, {"<left>", Integer.toString(projectData.configurationData.pluginPosition.x)}, {"<top>", Integer.toString(projectData.configurationData.pluginPosition.y)}, {"<width>", Integer.toString(projectData.configurationData.pluginWidth)}, {"<height>", Integer.toString(projectData.configurationData.pluginHeight)}};
            return GeneralTools.replaceStringsInFile((String)jsPath, (String[][])toFindAndReplace);
        }
        return true;
    }

    private boolean setBuildSpec(IProjectDescription desc) {
        int requiredCmd;
        String[] buildCommands = new String[]{"org.eclipse.cdt.managedbuilder.core.genmakebuilder"};
        boolean[] foundCommand = new boolean[buildCommands.length];
        Arrays.fill(foundCommand, false);
        int missingCommands = buildCommands.length;
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            requiredCmd = 0;
            while (requiredCmd < buildCommands.length) {
                if (commands[i].getBuilderName().equals(buildCommands[requiredCmd])) {
                    foundCommand[requiredCmd] = true;
                    --missingCommands;
                    break;
                }
                ++requiredCmd;
            }
            ++i;
        }
        if (missingCommands > 0) {
            ICommand[] newCommands = new ICommand[commands.length + missingCommands];
            if (commands.length > 0) {
                System.arraycopy(commands, 0, newCommands, missingCommands, commands.length);
            }
            requiredCmd = 0;
            while (requiredCmd < buildCommands.length) {
                if (!foundCommand[requiredCmd]) {
                    ICommand command = desc.newCommand();
                    command.setBuilderName(buildCommands[requiredCmd]);
                    command.setBuilding(15, buildCommands[requiredCmd].equals("org.eclipse.cdt.managedbuilder.core.genmakebuilder"));
                    command.setBuilding(6, true);
                    command.setBuilding(10, true);
                    command.setBuilding(9, false);
                    newCommands[requiredCmd] = command;
                }
                ++requiredCmd;
            }
            desc.setBuildSpec(newCommands);
        }
        return true;
    }
}

