/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.tizenwizardadditions;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.tv.sec.nacl.tizenwizardadditions.IToolchainPageSettings;
import org.tizen.web.tv.sec.nacl.tizenwizardadditions.Messages;

public class TVSupportContainer {
    private static final String WASM_LABEL = Messages.TVSupportContainer_WASM_CHECKBOX_TEXT;
    private static final String NACL_LABEL = Messages.TVSupportContainer_NACL_CHECKBOX_TEXT;
    private final IToolchainPageSettings settings;
    private final boolean naclAvailable;
    private final boolean wasmAvailable;
    private boolean naclSelected;
    private boolean wasmSelected;
    private final Composite tvContainer;
    private Button naclButton;
    private Button wasmButton;

    public TVSupportContainer(Composite container, IToolchainPageSettings settings, boolean naclAvailable, boolean wasmAvailable) {
        this.tvContainer = container;
        this.settings = settings;
        this.naclAvailable = naclAvailable;
        this.wasmAvailable = wasmAvailable;
        this.naclButton = null;
        this.wasmButton = null;
        this.naclSelected = false;
        this.wasmSelected = false;
        this.implementContainer();
    }

    private void implementContainer() {
        if (this.naclAvailable) {
            this.naclButton = new Button(this.tvContainer, 32);
            this.naclButton.setText(NACL_LABEL);
            this.naclButton.addSelectionListener(new SelectionListener(){

                private void updateNaclSelection(boolean selected) {
                    TVSupportContainer.this.naclSelected = selected;
                    TVSupportContainer.this.settings.setNaClEnabled(TVSupportContainer.this.naclSelected);
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.updateNaclSelection(TVSupportContainer.this.naclButton.getSelection());
                }

                public void widgetSelected(SelectionEvent arg0) {
                    this.updateNaclSelection(TVSupportContainer.this.naclButton.getSelection());
                }
            });
        }
        if (this.wasmAvailable) {
            this.wasmButton = new Button(this.tvContainer, 32);
            this.wasmButton.setText(WASM_LABEL);
            this.wasmButton.addSelectionListener(new SelectionListener(){

                private void updateWasmSelection(boolean selected) {
                    TVSupportContainer.this.wasmSelected = selected;
                    TVSupportContainer.this.settings.setWASMEnabled(TVSupportContainer.this.wasmSelected);
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.updateWasmSelection(TVSupportContainer.this.wasmButton.getSelection());
                }

                public void widgetSelected(SelectionEvent arg0) {
                    this.updateWasmSelection(TVSupportContainer.this.wasmButton.getSelection());
                }
            });
        }
        this.tvContainer.redraw();
    }

    public boolean isNaclSelected() {
        return this.naclSelected;
    }

    public boolean isWasmSelected() {
        return this.wasmSelected;
    }
}

