/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.tizenwizardadditions;

import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.SWTResourceManager;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.nacl.common.plugin.UiUtils;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;
import org.tizen.web.tv.sec.nacl.supportenabler.NaclToolchainContent;
import org.tizen.web.tv.sec.nacl.tizenwizardadditions.IToolchainContent;
import org.tizen.web.tv.sec.nacl.tizenwizardadditions.IToolchainPageSettings;
import org.tizen.web.tv.sec.nacl.tizenwizardadditions.Messages;

public class ToolchainWizardPage
extends org.tizen.common.ui.wizards.project.template.ToolchainWizardPage {
    private static final String PAGE_TITLE = Messages.ToolchainWizardPage_SELECT_TOOLCHAIN_TEXT;
    private Composite naclComposite;
    private Composite wasmComposite;
    private Label errorLabel;
    private final NaclToolchainContent naclContent = new NaclToolchainContent();
    private final IToolchainContent wasmContent;
    private boolean naclToolchainCompleted = true;
    private boolean wasmToolchainCompleted = true;

    protected ToolchainWizardPage() {
        super(PAGE_TITLE);
        this.naclContent.setEnableToolchainConfirmation((Consumer)new Consumer<Boolean>(){

            @Override
            public void accept(Boolean naclToolchainSettingComplete) {
                ToolchainWizardPage.this.naclToolchainCompleted = naclToolchainSettingComplete;
                ToolchainWizardPage.this.checkToolchainsCompletion();
            }
        });
        this.wasmContent = this.getToolchainContentFromExtension();
        if (this.wasmContent != null) {
            this.wasmContent.setEnableToolchainConfirmation(new Consumer<Boolean>(){

                @Override
                public void accept(Boolean wasmToolchainSettingComplete) {
                    ToolchainWizardPage.this.wasmToolchainCompleted = wasmToolchainSettingComplete;
                    ToolchainWizardPage.this.checkToolchainsCompletion();
                }
            });
        }
    }

    public void checkToolchainsCompletion() {
        this.setPageComplete(this.naclToolchainCompleted && this.wasmToolchainCompleted);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBounds(parent.getBounds());
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.verticalSpacing = 10;
        container.setLayout((Layout)gl_container);
        this.errorLabel = new Label(container, 0);
        this.errorLabel.setForeground(SWTResourceManager.getColor((int)3));
        this.errorLabel.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.naclComposite = new Composite(container, 0);
        this.naclComposite.setBounds(container.getBounds());
        this.naclComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gd_firstComposite = new GridData(4, 128, true, false, 1, 1);
        this.naclComposite.setLayoutData((Object)gd_firstComposite);
        this.naclContent.implementContent(this.naclComposite);
        if (this.wasmContent != null) {
            this.wasmComposite = new Composite(container, 0);
            this.wasmComposite.setLayout((Layout)new GridLayout(1, false));
            GridData gd_secondComposite = new GridData(4, 128, true, true, 1, 1);
            this.wasmComposite.setLayoutData((Object)gd_secondComposite);
            this.wasmContent.implementContent(this.wasmComposite, null);
        }
    }

    public void dispose() {
        try {
            if (this.isPageComplete()) {
                this.naclContent.storeNaClSdkRootDir();
            }
            this.naclContent.cancelVerification();
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            System.err.println("Cancelling toolchain's verification failed");
        }
        super.dispose();
    }

    public String getSelectedNaClToolchain() {
        return this.naclContent.getSelectedToolchain();
    }

    private IToolchainContent getToolchainContentFromExtension() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.tizen.web.tv.sec.nacl.tizenwizardadditions.wizard_toolchain_content");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object obj = element.createExecutableExtension("toolchainContent");
                if (obj instanceof IToolchainContent) {
                    return (IToolchainContent)obj;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    public boolean isCustomNaClToolchainSet() {
        return this.naclContent.isCustomToolchainSet();
    }

    public void performNaClFinish(IProject project) {
        NaclPreferenceActivator.getDefault().getNaclPreferences().setNaClToolchain(project, this.getSelectedNaClToolchain(), this.isCustomNaClToolchainSet());
        try {
            ProjectUtils.toggleTizenProjectNaClNature((IProject)project, null);
        }
        catch (CoreException coreException) {
            Logger.getGlobal().severe("Failed toggling NaCl nature");
        }
    }

    public void performWasmFinish(IProject project) {
        if (this.wasmContent != null) {
            this.wasmContent.performFinish(project, true);
        }
    }

    public void updatePage(IToolchainPageSettings settings) {
        GridData data = (GridData)this.naclComposite.getLayoutData();
        data.exclude = !settings.isNaClEnabled();
        this.naclComposite.setVisible(settings.isNaClEnabled());
        boolean bl = this.naclToolchainCompleted = !settings.isNaClEnabled();
        if (this.wasmContent != null) {
            this.wasmComposite.setVisible(settings.isWASMEnabled());
            this.wasmToolchainCompleted = !settings.isWASMEnabled();
        }
        this.naclComposite.getParent().layout(false);
    }

    public class ToolchainPageErrorChecker
    implements UiUtils.IErrorChecker {
        private final LinkedHashSet<String> errorSet = new LinkedHashSet();

        public boolean checkForError(String errorString, boolean statement) {
            if (statement) {
                this.errorSet.add(errorString);
                ToolchainWizardPage.this.errorLabel.setText(errorString);
                ToolchainWizardPage.this.setPageComplete(false);
                return statement;
            }
            this.errorSet.remove(errorString);
            if (!this.errorSet.isEmpty()) {
                ToolchainWizardPage.this.errorLabel.setText((String)this.errorSet.iterator().next());
                ToolchainWizardPage.this.setPageComplete(false);
                return statement;
            }
            ToolchainWizardPage.this.errorLabel.setText("");
            ToolchainWizardPage.this.setPageComplete(true);
            return statement;
        }
    }
}

