/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.preferences.toolchainmgr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.tizen.web.tv.sec.nacl.common.SystemInfo;

public class DownloadManager {
    private static final int CHUNK_SIZE = 0x100000;
    private static final int PROGRESS_STEP_LENGTH = 1024;

    public static IStatus remove(final File file, final IProgressMonitor monitor) {
        if (file == null) {
            return Status.CANCEL_STATUS;
        }
        int filesCount = 1;
        if (file.isDirectory()) {
            filesCount = file.list().length;
        }
        monitor.beginTask("Removing " + (file.isDirectory() ? "directory " : "file ") + file.getName(), filesCount);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            try {
                if (file.isDirectory()) {
                    Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        private boolean shouldCountWorkForFile(Path currentFile) {
                            Path parent = currentFile.getParent();
                            if (parent != null) {
                                return parent.equals(file.toPath());
                            }
                            return false;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file2);
                            if (this.shouldCountWorkForFile(file2)) {
                                monitor.worked(1);
                            }
                            if (monitor.isCanceled()) {
                                return FileVisitResult.TERMINATE;
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
                            if (this.shouldCountWorkForFile(dir)) {
                                monitor.worked(1);
                            }
                            if (ex == null) {
                                Files.delete(dir);
                                if (monitor.isCanceled()) {
                                    return FileVisitResult.TERMINATE;
                                }
                                return FileVisitResult.CONTINUE;
                            }
                            throw ex;
                        }
                    });
                } else {
                    Files.delete(file.toPath());
                    monitor.worked(1);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                monitor.done();
                IStatus iStatus = Status.CANCEL_STATUS;
                monitor.done();
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    /*
     * Exception decompiling
     */
    public static IStatus downloadFile(URL fileUrl, File targetPath, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 24[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int getNumberOfEntriesInZipFile(String filePath) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (java.util.zip.ZipFile zipFile = new java.util.zip.ZipFile(filePath);){
            return zipFile.size();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static IStatus unzipFile(String filePath, String targetDirectory, IProgressMonitor monitor) throws CoreException {
        try {
            var3_3 = null;
            var4_7 = null;
            try {
                zipFile = new ZipFile(filePath);
                try {
                    itemsToRemove = new ArrayDeque<File>();
                    zipEntries = zipFile.getEntries();
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)DownloadManager.getNumberOfEntriesInZipFile(filePath));
                    progress.setTaskName("Uncompressing " + new File(filePath).getName());
                    while (true) {
                        if (monitor.isCanceled()) {
                            itemsToRemove.forEach((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(java.io.File ), (Ljava/io/File;)V)());
                            return Status.CANCEL_STATUS;
                        }
                        entry = (ZipArchiveEntry)zipEntries.nextElement();
                        progress.subTask(entry.getName());
                        targetFile = new File(String.valueOf(targetDirectory) + File.separator + entry.getName());
                        if (entry.isDirectory()) {
                            targetFile.mkdirs();
                        } else {
                            zipChannel = Channels.newChannel(zipFile.getInputStream(entry));
                            var12_17 = null;
                            var13_19 = null;
                            try {
                                targetStream = new FileOutputStream(targetFile);
                                try {
                                    entrySize = entry.getSize();
                                    targetStream.getChannel().transferFrom(zipChannel, 0L, entrySize != -1L ? entrySize : 0x7FFFFFFFFFFFFFFFL);
                                }
                                finally {
                                    if (targetStream != null) {
                                        targetStream.close();
                                    }
                                }
                            }
                            catch (Throwable var13_20) {
                                if (var12_17 == null) {
                                    var12_17 = var13_20;
                                } else if (var12_17 != var13_20) {
                                    var12_17.addSuppressed(var13_20);
                                }
                                throw var12_17;
                            }
                            unixMode = entry.getUnixMode();
                            if (unixMode != 0 && !SystemInfo.isWindowsOs()) {
                                Files.setPosixFilePermissions(targetFile.toPath(), DownloadManager.createPosixPermissions(unixMode));
                            }
                        }
                        itemsToRemove.addFirst(targetFile);
                        progress.worked(1);
                        break;
                    }
                }
                finally {
                    if (zipEntries.hasMoreElements()) ** continue;
                }
            }
            catch (Throwable var4_8) {
                if (var3_3 == null) {
                    var3_3 = var4_8;
                } else if (var3_3 != var4_8) {
                    var3_3.addSuppressed(var4_8);
                }
                throw var3_3;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.preferences", "File not found: " + e.getLocalizedMessage(), (Throwable)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.preferences", "I/O Error: " + e.getLocalizedMessage(), (Throwable)e));
        }
        return Status.OK_STATUS;
    }

    private static Set<PosixFilePermission> createPosixPermissions(int unixPermissions) {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if ((unixPermissions & 0x100) != 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((unixPermissions & 0x80) != 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((unixPermissions & 0x40) != 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((unixPermissions & 0x20) != 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((unixPermissions & 0x10) != 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((unixPermissions & 8) != 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((unixPermissions & 4) != 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((unixPermissions & 2) != 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((unixPermissions & 1) != 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }

    private static void advanceProgressMonitor(IProgressMonitor monitor, long read, long leftToRead) {
        if (leftToRead > 0L) {
            monitor.subTask(String.valueOf(String.format("%,d", leftToRead / 1024L)) + " kiB left");
            monitor.worked((int)(read / 1024L));
        }
    }

    private static void reportAndRethrow(Exception exception, File fileName) throws CoreException {
        exception.printStackTrace();
        if (exception instanceof MalformedURLException) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.preferences", "Malformed URL: " + exception.getLocalizedMessage(), (Throwable)exception));
        }
        if (exception instanceof IOException) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.preferences", "I/O Error: " + exception.getLocalizedMessage(), (Throwable)exception));
        }
        if (exception instanceof OverlappingFileLockException) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.preferences", "The file " + fileName + " is locked and cannot be written: " + exception.getLocalizedMessage(), (Throwable)exception));
        }
        if (!(exception instanceof CoreException)) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.preferences", "Error: " + exception.getLocalizedMessage(), (Throwable)exception));
        }
    }

    private static long retrieveContentLength(URL fileUrl) throws IOException {
        URLConnection urlConnection = fileUrl.openConnection();
        return urlConnection.getContentLengthLong();
    }

    private static /* synthetic */ void lambda$0(File item) {
        item.delete();
    }
}

