/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.tizen.web.tv.sec.nacl.adapter.launch.Emulator;
import org.tizen.web.tv.sec.nacl.builder.export.WidgetExporter;
import org.tizen.web.tv.sec.nacl.launch.Messages;
import org.xml.sax.SAXException;

public class DeviceLaunchDelegate
extends LaunchConfigurationDelegate {
    public static final int DEFAULT_NACL_GDB_PORT = 4014;
    private IDebugEventSetListener portForwadingListener;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            Emulator emu = new Emulator(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.EMULATOR_INSTANCE", ""));
            File widget = new File(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.WIDGET_PATH", ""));
            emu.install(widget);
            boolean isDebug = mode.equals("debug");
            if (isDebug) {
                int port = Integer.parseInt(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", Integer.toString(4014)));
                this.portForwadingListener = new PortForwardingListener(emu, widget, port, port);
            }
            emu.launch(widget);
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", Messages.Common_launchError, (Throwable)ex));
        }
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject[] projects = new IProject[]{this.getProjectFromConfig(configuration)};
        return projects;
    }

    private IProject getProjectFromConfig(ILaunchConfiguration configuration) throws CoreException {
        String projName = configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", "");
        if (projName.isEmpty()) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean doBuild = configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.GENERATE_WIDGET", false);
        if (doBuild) {
            super.buildForLaunch(configuration, mode, monitor);
            IProject project = this.getProjectFromConfig(configuration);
            String widgetPath = configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.WIDGET_PATH", "");
            if (widgetPath.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", Messages.DeviceLaunchDelegate_widgetPathNotSet));
            }
            WidgetExporter.export((IProject)project, (String)widgetPath, (boolean)mode.equals("debug"));
        }
        return false;
    }

    private static class PortForwardingListener
    implements IDebugEventSetListener {
        private Emulator emu;
        private File widget;
        private int localPort;
        private int remotePort;

        public PortForwardingListener(Emulator emu, File widget, int localPort, int remotePort) throws IOException, SAXException, Exception {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            this.emu = emu;
            this.widget = widget;
            this.localPort = localPort;
            this.remotePort = remotePort;
            this.emu.createForward(widget, localPort, remotePort);
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                if (event.getKind() == 8) {
                    if (!(event.getSource() instanceof IProcess)) {
                        return;
                    }
                    try {
                        this.emu.removeForward(this.widget, this.localPort, this.remotePort);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    return;
                }
                ++n2;
            }
        }
    }
}

