/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.tizen.web.tv.sec.nacl.launch.Messages;

public class LaunchActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tizen.web.tv.sec.nacl.launch";
    private static LaunchActivator plugin;
    private IDebugEventSetListener terminateListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.terminateListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    if (event.getKind() == 8) {
                        ILaunch launch;
                        Object source = event.getSource();
                        if (!(source instanceof IProcess)) {
                            return;
                        }
                        IProcess process = (IProcess)source;
                        if (!process.getLabel().equals(Messages.ChromeLaunchDelegate_chromeProcessLabel)) {
                            return;
                        }
                        String tempDir = process.getAttribute("chrome_user_dir");
                        if (tempDir != null) {
                            try {
                                FileUtils.deleteDirectory((File)new File(tempDir));
                            }
                            catch (IOException ex) {
                                Logger.getGlobal().log(Level.SEVERE, NLS.bind((String)Messages.LaunchActivator_userDirDeletionError, (Object)tempDir), ex);
                            }
                        }
                        if (!(launch = process.getLaunch()).isTerminated()) {
                            try {
                                launch.terminate();
                            }
                            catch (DebugException ex) {
                                Logger.getGlobal().log(Level.SEVERE, Messages.LaunchActivator_launchTerminationError, ex);
                            }
                        }
                    }
                    ++n2;
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.terminateListener);
    }

    public void stop(BundleContext context) throws Exception {
        DebugPlugin.getDefault().removeDebugEventListener(this.terminateListener);
        plugin = null;
        super.stop(context);
    }

    public static LaunchActivator getDefault() {
        return plugin;
    }
}

