/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Shell;
import org.tizen.web.tv.sec.nacl.adapter.launch.Emulator;
import org.tizen.web.tv.sec.nacl.common.plugin.NaClModuleUtils;
import org.tizen.web.tv.sec.nacl.common.plugin.UiUtils;
import org.tizen.web.tv.sec.nacl.launch.DeviceSelectionDialog;
import org.tizen.web.tv.sec.nacl.launch.Messages;
import org.tizen.web.tv.sec.nacl.launch.NaclLaunchShortcut;

public class DeviceLaunchShortcut
extends NaclLaunchShortcut {
    @Override
    protected ILaunchConfigurationType getLaunchConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.tizen.web.tv.sec.nacl.launch.deviceLaunchConfigurationType");
    }

    private IPath generateWidgetPath(IProject tizenProject, IProject naclProject, boolean isDebug) {
        IPath widget = tizenProject != null ? tizenProject.getLocation().append(String.valueOf(tizenProject.getName()) + (isDebug ? "_debug" : "") + ".wgt") : naclProject.getLocation().append(String.valueOf(naclProject.getName()) + ".wgt");
        return widget;
    }

    private ILaunchConfiguration prepareConfiguration(IProject tizenProject, IProject naclProject, boolean isDebug) throws CoreException {
        String emulator;
        IPath widgetPath = this.generateWidgetPath(tizenProject, naclProject, isDebug);
        ILaunchConfigurationType type = this.getLaunchConfigurationType();
        String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(widgetPath.removeFileExtension().lastSegment());
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, name);
        if (tizenProject != null) {
            wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.TIZEN_PROJECT_NAME", tizenProject.getName());
        }
        wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", naclProject.getName());
        wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.WIDGET_PATH", widgetPath.toString());
        wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.GENERATE_WIDGET", true);
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(naclProject);
        if (projectDescription != null) {
            wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.ACTIVE_BUILD_CONFIGURATION_NAME", projectDescription.getActiveConfiguration().getName());
        }
        if ((emulator = this.getEmulatorInstance()) == null || emulator.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", Messages.DeviceLaunchShortcut_noEmulatorError));
        }
        wc.setAttribute("org.tizen.web.tv.sec.nacl.launch.EMULATOR_INSTANCE", emulator);
        return wc.doSave();
    }

    @Override
    protected ILaunchConfiguration createLaunchConfiguration(IProject project, boolean isDebug) throws CoreException {
        if (project == null) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", Messages.DeviceLaunchShortcut_invalidProjectError));
        }
        IProject parentProject = NaClModuleUtils.getTizenProject((IProject)project);
        return this.prepareConfiguration(parentProject, project, isDebug);
    }

    private String getEmulatorInstance() {
        Emulator.EmulatorInfo selected = Emulator.getSelectedEmulator();
        if (selected != null) {
            return selected.serial;
        }
        List emulators = Emulator.list();
        int size = emulators.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return ((Emulator.EmulatorInfo)emulators.get((int)0)).serial;
            }
        }
        Shell shell = UiUtils.getShell();
        if (shell == null) {
            return null;
        }
        DeviceSelectionDialog dialog = new DeviceSelectionDialog(shell);
        return dialog.openDialog();
    }

    @Override
    protected boolean isLaunchCandidateValid(ILaunchConfiguration candidate, IProject project) {
        block3: {
            Emulator.EmulatorInfo selectedEmu;
            block4: {
                if (!candidate.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", "").equals(project.getName())) break block3;
                selectedEmu = Emulator.getSelectedEmulator();
                if (selectedEmu != null) break block4;
                return true;
            }
            try {
                return candidate.getAttribute("org.tizen.web.tv.sec.nacl.launch.EMULATOR_INSTANCE", "").equals(selectedEmu.serial);
            }
            catch (CoreException ex) {
                Logger.getGlobal().log(Level.SEVERE, Messages.NaclLaunchShortcut_attributeError, ex);
            }
        }
        return false;
    }
}

