/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.wasm.builder;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.web.tv.sec.wasm.builder.SourceMapOptionUtils;
import org.tizen.web.tv.sec.wasm.builder.SourceMapServerPool;
import org.tizen.web.tv.sec.wasm.common.plugin.ProjectUtils;

public class SourceMapLaunchListener
implements ILaunchListener {
    private static final Logger logger = Logger.getLogger(SourceMapLaunchListener.class.getPackage().getName());
    private SourceMapServerPool serverPool = new SourceMapServerPool();

    public SourceMapLaunchListener() {
        Arrays.stream(DebugPlugin.getDefault().getLaunchManager().getLaunches()).forEach(this::launchAdded);
    }

    public void launchAdded(ILaunch launch) {
        Arrays.stream(SourceMapLaunchListener.getLaunchingSubprojects(launch)).filter(ProjectUtils::isWasmProject).forEach(project -> this.handleProjectLaunch((IProject)project, launch));
    }

    private static IProject getLaunchingProject(ILaunch launch) {
        try {
            String projectName = launch.getLaunchConfiguration().getAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", "");
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        catch (CoreException exception) {
            logger.warning("Failed to get project: " + (Object)((Object)exception));
            return null;
        }
    }

    private static IProject[] getLaunchingSubprojects(ILaunch launch) {
        IProject project = SourceMapLaunchListener.getLaunchingProject(launch);
        try {
            if (project != null) {
                return project.getReferencedProjects();
            }
        }
        catch (CoreException exception) {
            logger.warning("Failed to get subprojects: " + (Object)((Object)exception));
        }
        return new IProject[0];
    }

    private static boolean shouldHandleProject(IProject project) {
        IOption sourceMapOption = SourceMapOptionUtils.getSourceMapOption(project);
        return SourceMapOptionUtils.getOptionValue(sourceMapOption);
    }

    private void handleProjectLaunch(IProject project, ILaunch launch) {
        if (SourceMapLaunchListener.shouldHandleProject(project)) {
            this.startSourceMapDebugServer(project, launch);
        } else {
            this.serverPool.stopSourceMapServer(project);
        }
    }

    private void startSourceMapDebugServer(IProject project, ILaunch launch) {
        IOption sourceMapOption = SourceMapOptionUtils.getSourceMapOption(project);
        Server server = this.serverPool.startSourceMapDebugServer(project);
        if (server == null) {
            return;
        }
        int port = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
        logger.info("Server listening on port: " + port + " is ready");
        sourceMapOption.setCommand(String.format("--source-map-base http://%s:%d/CurrentBin/", SourceMapLaunchListener.getHostIp(launch, port), port));
        try {
            project.build(10, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            logger.warning("Failed to rebuild the project: " + exception);
        }
    }

    private static String getHostIp(ILaunch launch, int port) {
        String deviceIp = Arrays.stream(SmartDevelopmentBridge.getBridge().getDevices()).filter(device -> SourceMapLaunchListener.isLaunchTarget(device, launch)).map(IDevice::getIp).findFirst().orElse("10.255.255.255");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DatagramSocket socket = new DatagramSocket();){
                socket.connect(InetAddress.getByName(deviceIp), port);
                return socket.getLocalAddress().getHostAddress();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SocketException | UnknownHostException exception) {
            logger.warning("Failed get host IP: " + exception);
            return "0.0.0.0";
        }
    }

    private static boolean isLaunchTarget(IDevice device, ILaunch launch) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        try {
            String deviceName = config.getAttribute("org.tizen.common.CONFIG_ATTR_DEVICE_NAME", "");
            String deviceSerial = config.getAttribute("org.tizen.commonCONFIG_ATTR_DEVICE_SERIAL_NO", "");
            return device.isEmulator() && deviceName.equals(device.getDeviceName()) || deviceSerial.equals(device.getSerialNumber());
        }
        catch (CoreException exception) {
            logger.warning("Failed to get device options: " + (Object)((Object)exception));
            return false;
        }
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }
}

