/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.debug;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.tizen.web.tv.sec.nacl.debug.ChromeDebugMainTab;
import org.tizen.web.tv.sec.nacl.debug.Messages;
import org.tizen.web.tv.sec.nacl.debug.NaclDebugLaunchTab;
import org.tizen.web.tv.sec.nacl.launch.ChromeLaunchShortcut;
import org.tizen.web.tv.sec.nacl.launch.NaclLaunchShortcut;

public class ChromeDebugShortcut
extends ChromeLaunchShortcut {
    private static final String CHROME_DEBUG_LAUNCH_CONFIGURATION = "org.tizen.web.tv.sec.nacl.debug.ChromeDebugLaunchConfiguration";

    protected void launch(IProject project, String mode) {
        NaclLaunchShortcut.BuildConfigData activeConfigData = this.getCurrentBuildConfigData(project);
        if (activeConfigData == null) {
            this.showError(Messages.ChromeDebugShortcut_ActiveBuildConfigGettingFailed, Messages.ChromeDebugShortcut_FailureInToolchainOrActiveBuildConfigGetting);
            return;
        }
        if (activeConfigData.getToolchainType() == NaclLaunchShortcut.BuildConfigData.ToolchainType.PNACL && activeConfigData.isDebug()) {
            super.launch(project, mode);
        } else {
            this.showError(String.valueOf(Messages.ChromeDebugShortcut_CannotDebugInChrome) + activeConfigData.getName() + ".", Messages.ChromeDebugShortcut_ChromeDebuggingSupportedBuildConfig);
        }
    }

    protected ILaunchConfigurationType getLaunchConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(CHROME_DEBUG_LAUNCH_CONFIGURATION);
    }

    protected ILaunchConfiguration createLaunchConfiguration(IProject project, boolean isDebug) throws CoreException {
        ILaunchConfigurationType type = this.getLaunchConfigurationType();
        String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(project.getName());
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, name);
        ChromeDebugMainTab debugMainTab = new ChromeDebugMainTab();
        debugMainTab.setDefaults(wc);
        NaclDebugLaunchTab naclMainTab = new NaclDebugLaunchTab();
        naclMainTab.setDefaults(wc);
        return wc.doSave();
    }
}

