/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.debug;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.tizen.web.tv.sec.nacl.debug.Messages;

public abstract class NaclDebugMainTab
extends AbstractLaunchConfigurationTab {
    private Text nexePath;
    protected static final String[] NEXE_EXTENSIONS = new String[]{"*.nexe"};

    public void createControl(Composite parent) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                NaclDebugMainTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.createControl(parent, listener);
    }

    public void createControl(Composite parent, ModifyListener listener) {
        Composite comp = (Composite)this.getControl();
        this.createNexePathControls(comp, listener);
    }

    private void createNexePathControls(Composite comp, ModifyListener listener) {
        Label label = new Label(comp, 0);
        label.setText(Messages.NaclDebugMainTab_nexePath);
        this.nexePath = new Text(comp, 2052);
        this.nexePath.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.nexePath.addModifyListener(listener);
        Button browseButton = new Button(comp, 0);
        browseButton.setText(Messages.NaclDebugMainTab_browse);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                String widget;
                FileDialog dialog = new FileDialog(NaclDebugMainTab.this.getShell());
                dialog.setFilterExtensions(NEXE_EXTENSIONS);
                String currentPath = NaclDebugMainTab.this.nexePath.getText();
                if (!currentPath.isEmpty()) {
                    Path path = Paths.get(currentPath, new String[0]);
                    if (Files.isRegularFile(path, new LinkOption[0]) || !Files.exists(path, new LinkOption[0])) {
                        path = path.getParent();
                    }
                    if (Files.exists(path, new LinkOption[0])) {
                        dialog.setFilterPath(path.toString());
                    }
                }
                if ((widget = dialog.open()) != null) {
                    NaclDebugMainTab.this.nexePath.setText(widget);
                }
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        try {
            String projectName = config.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", "");
            String nexeRelative = this.genDefaultProgramFileName(projectName, (ILaunchConfiguration)config);
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                Path nexePath = FileSystems.getDefault().getPath(project.getLocation().toString(), nexeRelative);
                config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", nexePath.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setNexePath(String targetName) {
        String newNexePath = this.nexePath.getText();
        newNexePath = targetName.contains("emulator") ? newNexePath.replaceAll("armv7", "i686") : newNexePath.replaceAll("i686", "armv7");
        this.nexePath.setText(newNexePath);
    }

    public abstract void updateNexePath(String var1);

    public abstract String genDefaultProgramFileName(String var1, ILaunchConfiguration var2);

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.nexePath.setText(configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.nexePath.getText());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        try {
            if (!Files.exists(Paths.get(config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", ""), new String[0]), new LinkOption[0])) {
                this.setErrorMessage(Messages.NaclDebugMainTab_noSuchNexe);
                return false;
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(org.tizen.web.tv.sec.nacl.launch.Messages.ChromeMainTab_unknownError);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static void setDefaultValuesForGDB(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.dsf.gdb.AUTO_SOLIB", true);
        config.setAttribute("org.eclipse.cdt.dsf.gdb.AUTO_SOLIB_LIST", new ArrayList());
        config.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_ON_FORK", false);
        config.setAttribute("org.eclipse.cdt.dsf.gdb.DEV", "/dev/ttyS0");
        config.setAttribute("org.eclipse.cdt.dsf.gdb.DEV_SPEED", "115200");
        config.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", ".gdbinit");
        config.setAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", false);
        config.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
        config.setAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
        config.setAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", new ArrayList());
        config.setAttribute("org.eclipse.cdt.dsf.gdb.TRACEPOINT_MODE", "TP_NORMAL_ONLY");
    }
}

