/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.addnaclmodule.mergetools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.tizen.web.tv.sec.nacl.addnaclmodule.NaClModuleBinariesFilter;
import org.tizen.web.tv.sec.nacl.addnaclmodule.NaClModuleValidator;
import org.tizen.web.tv.sec.nacl.addnaclmodule.mergetools.TizenProjectConfigMerger;
import org.tizen.web.tv.sec.nacl.addnaclmodule.mergetools.TprojectFileEditor;
import org.tizen.web.tv.sec.nacl.common.plugin.NaClModuleUtils;

public class NaClModuleInserter {
    private static final String HTML_END_OF_COMMON_NACL_CONTENT_COMMENT = "<!-- !!! END OF COMMON NACL CONTENT !!! -->";
    private static final String HTML_START_OF_COMMON_NACL_CONTENT_COMMENT = "<!-- !!! START OF COMMON NACL CONTENT !!! -->";
    private static final String JS_END_OF_JS_SCRIPT_COMMENT_BEGIN = "/* ******* END OF JS SCRIPT : ";
    private static final String JS_COMMENT_END = " ******* */";
    private static final String JS_START_OF_JS_SCRIPT_COMMENT_BEGIN = "/* ******* START OF JS SCRIPT : ";
    private static final String HTML_NACL_MODULE_SCRIPT_END_COMMENT_BEGIN = "<!-- !!! NACL MODULE SCRIPT END : ";
    private static final String HTML_NACL_MODULE_SCRIPT_START_COMMENT_BEGIN = "<!-- !!! NACL MODULE SCRIPT START : ";
    private static final String HTML_COMMENT_END = " !!! -->";
    private static final String HTML_NACL_MODULE_END_COMMENT_BEGIN = "<!-- !!! NACL MODULE END : ";
    private static final String HTML_NACL_MODULE_START_COMMENT_BEGIN = "<!-- !!! NACL MODULE START : ";
    private static final String JS_FILE_SEPARATOR = "/";
    private static final String HTML_FILE_SEPARATOR = "/";

    public static void insertModule(IProject naclProject, IProject tizenProject) {
        if (NaClModuleUtils.getTizenProject((IProject)naclProject) != tizenProject) {
            Logger.getGlobal().severe("naclProject does not belong to this tizen project");
            return;
        }
        ModuleProjectInjectionData moduleData = new ModuleProjectInjectionData(naclProject);
        TizenProjectInjectionData tizenProjectData = new TizenProjectInjectionData(tizenProject);
        File moduleIndexFile = new File(moduleData.indexHtmlPath);
        File tizenIndexFile = new File(tizenProjectData.indexHtmlPath);
        Document moduleIndexDoc = NaClModuleUtils.parseFile((File)moduleIndexFile);
        Document tizenIndexDoc = NaClModuleUtils.parseFile((File)tizenIndexFile);
        NaClModuleInserter.appendNecessaryMetaTags(tizenIndexDoc);
        String naclBodyContent = NaClModuleInserter.extractNaclBodyContent(moduleData.moduleName, moduleData.modulesDirectoryName, moduleIndexDoc);
        NaClModuleInserter.appendToBodyElement(tizenIndexDoc, naclBodyContent);
        String outputScriptContent = NaClModuleInserter.createMergedJSContent(moduleData);
        String relativePathToMergedJS = NaClModuleInserter.saveMergedJS(moduleData, tizenProjectData, outputScriptContent);
        NaClModuleInserter.appendScriptToHead(relativePathToMergedJS, moduleData.moduleName, tizenIndexDoc);
        String newTizenIndexContent = tizenIndexDoc.toString();
        NaClModuleUtils.saveContentToFile((String)tizenProjectData.indexHtmlPath, (String)newTizenIndexContent);
        NaClModuleInserter.copyResourcesDirectory(naclProject, tizenProject);
        TizenProjectConfigMerger.performInitialMerge(naclProject, tizenProject);
        TprojectFileEditor.excludeNonBinPaths(naclProject, tizenProject, new NaClModuleValidator(), new NaClModuleBinariesFilter(naclProject));
    }

    private static void appendNecessaryMetaTags(Document tizenIndexDoc) {
        if (!tizenIndexDoc.head().html().contains("<meta http-equiv=\"Pragma\" content=\"no-cache\">")) {
            tizenIndexDoc.head().append(HTML_START_OF_COMMON_NACL_CONTENT_COMMENT);
            tizenIndexDoc.head().append("<meta http-equiv=\"Pragma\" content=\"no-cache\">");
            tizenIndexDoc.head().append("<meta http-equiv=\"Expires\" content=\"-1\">");
            tizenIndexDoc.head().append(HTML_END_OF_COMMON_NACL_CONTENT_COMMENT);
        }
    }

    private static String saveMergedJS(ModuleProjectInjectionData moduleData, TizenProjectInjectionData tizenProjectData, String outputScriptContent) {
        String outputScriptDirectoryPath = tizenProjectData.scriptsDirectoryPath;
        if (!Files.exists(Paths.get(outputScriptDirectoryPath, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(Paths.get(outputScriptDirectoryPath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (!Files.isDirectory(Paths.get(outputScriptDirectoryPath, new String[0]), new LinkOption[0])) {
            throw new RuntimeException("there is a scripts file and it is not directory!");
        }
        String absoluteScriptPath = String.valueOf(outputScriptDirectoryPath) + File.separator + moduleData.moduleName + ".js";
        NaClModuleUtils.saveContentToFile((String)absoluteScriptPath, (String)outputScriptContent);
        String relativeScriptPath = absoluteScriptPath.replace(String.valueOf(tizenProjectData.projectBasePath) + File.separator, "").replace(File.separator, "/");
        return relativeScriptPath;
    }

    private static String createMergedJSContent(ModuleProjectInjectionData moduleData) {
        File directory = new File(moduleData.scriptsDirectoryPath);
        LinkedList<File> scripts = new LinkedList<File>();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().matches(".*\\.js")) {
                scripts.add(file);
            }
            ++n2;
        }
        String outputScriptContent = new String();
        outputScriptContent = String.valueOf(outputScriptContent) + "var " + moduleData.moduleName + "_module = function() {" + System.getProperty("line.separator");
        for (File script : scripts) {
            outputScriptContent = String.valueOf(outputScriptContent) + JS_START_OF_JS_SCRIPT_COMMENT_BEGIN + script.getName() + JS_COMMENT_END + System.getProperty("line.separator");
            String scriptContent = null;
            try {
                scriptContent = new String(Files.readAllBytes(Paths.get(script.getAbsolutePath(), new String[0])));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            scriptContent = scriptContent.replaceAll("CurrentBin", String.valueOf(moduleData.modulesDirectoryName) + "/" + moduleData.moduleName + "/" + "CurrentBin");
            scriptContent = scriptContent.replaceAll("document\\.getElementById\\(\"page_title\"\\)\\.innerHTML = demo_name;", "");
            scriptContent = scriptContent.replaceAll(", \"nacl_module\"\\)", ", \"nacl_module\" + '_" + moduleData.moduleName + "')");
            scriptContent = scriptContent.replaceAll("\\.getElementById\\((.*?)\\)", ".getElementById($1 + '_" + moduleData.moduleName + "')");
            outputScriptContent = String.valueOf(outputScriptContent) + scriptContent;
            outputScriptContent = String.valueOf(outputScriptContent) + JS_END_OF_JS_SCRIPT_COMMENT_BEGIN + script.getName() + JS_COMMENT_END + System.getProperty("line.separator");
        }
        outputScriptContent = String.valueOf(outputScriptContent) + "}();" + System.getProperty("line.separator");
        return outputScriptContent;
    }

    private static void copyResourcesDirectory(IProject naclProject, IProject tizenProject) {
        try {
            FileUtils.copyDirectory((File)new File(NaClModuleUtils.getNaClModuleResourcesPath((IProject)naclProject)), (File)new File(NaClModuleUtils.getTizenProjectResourcesPath((IProject)tizenProject)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void appendScriptToHead(String relativePathToMergedJS, String moduleName, Document tizenIndexDoc) {
        tizenIndexDoc.head().append(HTML_NACL_MODULE_SCRIPT_START_COMMENT_BEGIN + moduleName + HTML_COMMENT_END);
        tizenIndexDoc.head().append("<script type=\"text/javascript\" src=\"" + relativePathToMergedJS + "\"></script>");
        tizenIndexDoc.head().append(HTML_NACL_MODULE_SCRIPT_END_COMMENT_BEGIN + moduleName + HTML_COMMENT_END);
    }

    private static void appendToBodyElement(Document tizenIndexDoc, String naclBodyContent) {
        tizenIndexDoc.body().append(naclBodyContent);
    }

    private static String extractNaclBodyContent(String moduleName, String modulesDirectoryName, Document moduleDoc) {
        for (Element e3 : moduleDoc.select("*[id]")) {
            e3.attr("id", String.valueOf(e3.attr("id")) + "_" + moduleName);
        }
        for (Element e1 : moduleDoc.select("*[src]")) {
            if (!e1.attr("src").matches(".*CurrentBin.*")) continue;
            e1.attr("src", String.valueOf(modulesDirectoryName) + "/" + moduleName + "/" + e1.attr("src"));
        }
        Element div = new Element("div");
        div.append(moduleDoc.body().html());
        moduleDoc.body().empty();
        div.appendTo(moduleDoc.body());
        div.before(HTML_NACL_MODULE_START_COMMENT_BEGIN + moduleName + HTML_COMMENT_END);
        div.after(HTML_NACL_MODULE_END_COMMENT_BEGIN + moduleName + HTML_COMMENT_END);
        String content = moduleDoc.body().html();
        return content;
    }

    private static class ModuleProjectInjectionData {
        public final String indexHtmlPath;
        public final String moduleName;
        public final String modulesDirectoryName;
        public final String scriptsDirectoryPath;

        public ModuleProjectInjectionData(IProject naclProject) {
            this.indexHtmlPath = NaClModuleUtils.getNaClModuleIndexHtmlFilePath((IProject)naclProject);
            this.moduleName = NaClModuleUtils.getNaClModuleName((IProject)naclProject);
            this.modulesDirectoryName = "nacl_modules";
            this.scriptsDirectoryPath = NaClModuleUtils.getNaClModuleScriptsPath((IProject)naclProject);
        }
    }

    private static class TizenProjectInjectionData {
        public final String indexHtmlPath;
        public final String projectBasePath;
        public final String scriptsDirectoryPath;

        public TizenProjectInjectionData(IProject tizenProject) {
            this.indexHtmlPath = NaClModuleUtils.getTizenProjectIndexHtmlFilePath((IProject)tizenProject);
            this.projectBasePath = NaClModuleUtils.getTizenProjectBasePath((IProject)tizenProject);
            this.scriptsDirectoryPath = NaClModuleUtils.getTizenProjectNaClModulesScriptsPath((IProject)tizenProject);
        }
    }
}

