/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.addnaclmodule.mergetools;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IProject;
import org.tizen.web.tv.sec.nacl.builder.Utils;
import org.tizen.web.tv.sec.nacl.common.XMLTools;
import org.tizen.web.tv.sec.nacl.common.plugin.NaClModuleUtils;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TizenProjectConfigMerger {
    private static final String TIZEN_PRIVILEGE_TAG = "tizen:privilege";
    private static final String[] TAGS_FOR_INITAL_COPY = new String[]{"tizen:content-security-policy", "tizen:metadata", "access", "tizen:privilege"};
    private static final String NAME_TAG = "name";
    private static final String NOT_USED_BY_NACL_COMMENT = "below privilege is unused by NaCl";
    private static final String XPATH_FORMULA_NOT_USED_BY_NACL_COMMENTS = "//comment()[. = 'below privilege is unused by NaCl']";

    public static void performInitialMerge(IProject naclProject, IProject tizenProject) {
        if (!ProjectUtils.isNaClProject((IProject)naclProject) || !ProjectUtils.isWebTvTizenProject((IProject)tizenProject)) {
            Logger.getGlobal().severe("naclProject or tizenProject is not of expected type (wrong IProject)");
            return;
        }
        File moduleConfigFile = new File(NaClModuleUtils.getNaClModuleConfigFilePath((IProject)naclProject));
        File tizenConfigFile = new File(NaClModuleUtils.getTizenProjectConfigFilePath((IProject)tizenProject));
        Document moduleConfigDoc = XMLTools.parseFile((File)moduleConfigFile);
        Document tizenConfigDoc = XMLTools.parseFile((File)tizenConfigFile);
        LinkedList<NodeList> nodes = new LinkedList<NodeList>();
        String[] stringArray = TAGS_FOR_INITAL_COPY;
        int n = TAGS_FOR_INITAL_COPY.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            nodes.add(moduleConfigDoc.getElementsByTagName(tag));
            ++n2;
        }
        Node widgetNode = tizenConfigDoc.getElementsByTagName("widget").item(0);
        for (NodeList nodeList : nodes) {
            int i = 0;
            while (i < nodeList.getLength()) {
                boolean found = false;
                Node node = tizenConfigDoc.importNode(nodeList.item(i), true);
                NodeList widgetChildrenNodes = widgetNode.getChildNodes();
                int j = 0;
                while (j < widgetChildrenNodes.getLength()) {
                    if (widgetChildrenNodes.item(j).isEqualNode(node)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    widgetNode.appendChild(node);
                }
                ++i;
            }
        }
        XMLTools.saveToFile((Document)tizenConfigDoc, (String)NaClModuleUtils.getTizenProjectConfigFilePath((IProject)tizenProject));
    }

    public static void updateConfig(IProject tizenProject) {
        TizenProjectConfigMerger.updateConfig(tizenProject, false);
    }

    public static void updateConfig(IProject tizenProject, boolean removeUnusedPrivileges) {
        IProject[] naclModules = NaClModuleUtils.getNaClModules((IProject)tizenProject);
        LinkedList<String> naclModulesConfigPaths = new LinkedList<String>();
        IProject[] iProjectArray = naclModules;
        int n = naclModules.length;
        int n2 = 0;
        while (n2 < n) {
            IProject naclModule = iProjectArray[n2];
            naclModulesConfigPaths.add(NaClModuleUtils.getNaClModuleConfigFilePath((IProject)naclModule));
            ++n2;
        }
        String tizenProjectConfigPath = NaClModuleUtils.getTizenProjectConfigFilePath((IProject)tizenProject);
        TizenProjectConfigMerger.updatePrivileges(tizenProjectConfigPath, naclModulesConfigPaths, removeUnusedPrivileges);
    }

    private static void updatePrivileges(String tizenProjectConfigPath, LinkedList<String> naclModulesConfigPaths, boolean removeUnusedPrivileges) {
        HashSet naclModulePrivileges = new HashSet();
        for (String naclModuleConfigPath : naclModulesConfigPaths) {
            try {
                Utils.loadPrivilegesFromConfigXml((String)naclModuleConfigPath, naclModulePrivileges);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
        }
        HashSet tizenProjectPrivileges = new HashSet();
        tizenProjectPrivileges.addAll(naclModulePrivileges);
        try {
            if (!removeUnusedPrivileges) {
                Utils.loadPrivilegesFromConfigXml((String)tizenProjectConfigPath, tizenProjectPrivileges);
            }
            Utils.storePrivilegesToConfigXml((String)tizenProjectConfigPath, tizenProjectPrivileges);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            e.printStackTrace();
            return;
        }
        HashSet<String> unusedByNaClPrivileges = new HashSet<String>();
        unusedByNaClPrivileges.addAll(tizenProjectPrivileges);
        unusedByNaClPrivileges.removeAll(naclModulePrivileges);
        TizenProjectConfigMerger.markNotUsedByNaClPrivileges(tizenProjectConfigPath, unusedByNaClPrivileges, removeUnusedPrivileges);
    }

    private static void markNotUsedByNaClPrivileges(String tizenProjectConfigPath, HashSet<String> unusedByNaClPrivileges, boolean removeUnusedPrivileges) {
        Document tizenProjectDocument = XMLTools.parseFile((File)new File(tizenProjectConfigPath));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList oldNaClCommentNodes = null;
        try {
            oldNaClCommentNodes = (NodeList)xPath.evaluate(XPATH_FORMULA_NOT_USED_BY_NACL_COMMENTS, tizenProjectDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e1) {
            e1.printStackTrace();
            return;
        }
        int i = 0;
        while (i < oldNaClCommentNodes.getLength()) {
            Node node = oldNaClCommentNodes.item(i);
            node.getParentNode().removeChild(node);
            ++i;
        }
        if (!removeUnusedPrivileges) {
            NodeList tizenPrivilegesNodes = tizenProjectDocument.getElementsByTagName(TIZEN_PRIVILEGE_TAG);
            int i2 = 0;
            while (i2 < tizenPrivilegesNodes.getLength()) {
                Node node = tizenPrivilegesNodes.item(i2);
                Node nameTag = node.getAttributes().getNamedItem(NAME_TAG);
                if (nameTag != null && nameTag.getTextContent() != null && unusedByNaClPrivileges.contains(nameTag.getTextContent())) {
                    Comment comment = tizenProjectDocument.createComment(NOT_USED_BY_NACL_COMMENT);
                    node.getParentNode().insertBefore(comment, node);
                }
                ++i2;
            }
        }
        XMLTools.saveToFile((Document)tizenProjectDocument, (String)tizenProjectConfigPath);
    }
}

