/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.addnaclmodule.wizards;

import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.web.tv.sec.nacl.addnaclmodule.wizards.Messages;
import org.tizen.web.tv.sec.nacl.addnaclmodule.wizards.NaclAddModuleWizardPage;
import org.tizen.web.tv.sec.nacl.common.NativeLanguage;
import org.tizen.web.tv.sec.nacl.common.plugin.UiUtils;
import org.tizen.web.tv.sec.nacl.project_wizards.PNaClHelper;
import org.tizen.web.tv.sec.nacl.project_wizards.PluginConfig;
import org.tizen.web.tv.sec.nacl.project_wizards.ProjectData;

public class NaclTemplateWizardPage
extends NaclAddModuleWizardPage {
    private static final String SELECT_AT_LEAST_ONE_TEMPLATE_TEXT = Messages.NaclTemplateWizardPage_SelectAtLeastOneTemplate;
    private static final String LANGUAGE_TEXT = Messages.NaclTemplateWizardPage_Language;
    private static final String CREATE_A_NACL_MODULE_TEXT = String.valueOf(Messages.NaclTemplateWizardPage_SetTheLanguageForTheModule) + Messages.NaclTemplateWizardPage_ChooseIfTheModuleBeCreatedFromSampleTemplateEmpty;
    private static final String SELECT_NACL_MODULE_CONTENT_TEXT = Messages.NaclTemplateWizardPage_SelectNaClModuleContent;
    private static final String SAMPLE_TEXT = Messages.NaclTemplateWizardPage_Sample;
    private static final String TEMPLATE_TEXT = Messages.NaclTemplateWizardPage_Template;
    private static final String EMPTY_NACL_MODULE_TEXT = Messages.NaclTemplateWizardPage_EmptyNaClModule;
    private StyledText readmeStyledText;
    private Button sampleRadioButton;
    private Button templateRadioButton;
    private Button emptyModuleRadioButton;
    private List sampleList;
    private Label label_2;
    private CCombo cmbLanguageSelector;
    private Table templateTable;
    private Label label_3;

    public NaclTemplateWizardPage() {
        super("wizardPage");
        this.setTitle(SELECT_NACL_MODULE_CONTENT_TEXT);
        this.setDescription(CREATE_A_NACL_MODULE_TEXT);
    }

    public Data getData() {
        ProjectData.ProjectType projectType = null;
        projectType = this.sampleRadioButton.getSelection() ? ProjectData.ProjectType.Example : (this.templateRadioButton.getSelection() ? ProjectData.ProjectType.Template : ProjectData.ProjectType.Empty);
        String sampleName = null;
        if (this.sampleList.getSelection().length == 1) {
            sampleName = this.sampleList.getSelection()[0];
        }
        TreeSet<String> interfaces = new TreeSet<String>();
        TableItem[] tableItemArray = this.templateTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                interfaces.add(item.getText());
            }
            ++n2;
        }
        return new Data(projectType.toString(), sampleName, interfaces, this.cmbLanguageSelector.getText());
    }

    private void actionOnLanguageChange(NativeLanguage language) {
        this.actionOnLanguageChange(language.toString());
    }

    private void actionOnLanguageChange(String language) {
        this.sampleList.setItems(this.getSampleNames(NativeLanguage.toEnumValue((String)language)));
        this.sampleList.setSelection(0);
        if (this.sampleRadioButton.getSelection()) {
            this.setSampleDescription(this.sampleList.getItem(this.sampleList.getSelectionIndex()));
        }
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 10;
        gl_container.horizontalSpacing = 20;
        gl_container.marginTop = 10;
        gl_container.marginRight = 20;
        gl_container.marginLeft = 20;
        gl_container.marginHeight = 10;
        container.setLayout((Layout)gl_container);
        this.label_2 = new Label(container, 0);
        this.label_2.setText(LANGUAGE_TEXT);
        this.cmbLanguageSelector = new CCombo(container, 2048);
        this.cmbLanguageSelector.setText(NativeLanguage.CPP.toString());
        this.cmbLanguageSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NaclTemplateWizardPage.this.actionOnLanguageChange(NaclTemplateWizardPage.this.cmbLanguageSelector.getText());
            }
        });
        this.cmbLanguageSelector.setItems(this.getAvailableLanguages());
        this.cmbLanguageSelector.setEditable(false);
        this.label_3 = new Label(container, 258);
        this.label_3.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sampleRadioButton = new Button(container, 16);
        this.sampleRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NaclTemplateWizardPage.this.sampleRadioButton.getSelection()) {
                    NaclTemplateWizardPage.this.sampleList.setEnabled(true);
                    NaclTemplateWizardPage.this.setSampleDescription(NaclTemplateWizardPage.this.sampleList.getItem(NaclTemplateWizardPage.this.sampleList.getSelectionIndex()));
                } else {
                    NaclTemplateWizardPage.this.sampleList.setEnabled(false);
                }
            }
        });
        this.sampleRadioButton.setSelection(true);
        this.sampleRadioButton.setText(SAMPLE_TEXT);
        this.readmeStyledText = new StyledText(container, 2882);
        GridData gd_txtNaclAudioDemo = new GridData(4, 4, true, false, 1, 7);
        gd_txtNaclAudioDemo.widthHint = 371;
        gd_txtNaclAudioDemo.heightHint = 248;
        this.readmeStyledText.setLayoutData((Object)gd_txtNaclAudioDemo);
        this.readmeStyledText.setEditable(false);
        this.sampleList = new List(container, 2560);
        this.sampleList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NaclTemplateWizardPage.this.sampleRadioButton.getSelection()) {
                    NaclTemplateWizardPage.this.setSampleDescription(NaclTemplateWizardPage.this.sampleList.getItem(NaclTemplateWizardPage.this.sampleList.getSelectionIndex()));
                }
            }
        });
        GridData gd_sampleList = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_sampleList.widthHint = 129;
        gd_sampleList.heightHint = 74;
        this.sampleList.setLayoutData((Object)gd_sampleList);
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.templateRadioButton = new Button(container, 16);
        this.templateRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NaclTemplateWizardPage.this.templateRadioButton.getSelection()) {
                    NaclTemplateWizardPage.this.templateTable.setEnabled(true);
                    NaclTemplateWizardPage.this.readmeStyledText.setText(NaclTemplateWizardPage.this.getTemplateDescription());
                    NaclTemplateWizardPage.this.checkForError(SELECT_AT_LEAST_ONE_TEMPLATE_TEXT, !NaclTemplateWizardPage.this.isAnyTemplateItemSelected());
                } else {
                    NaclTemplateWizardPage.this.templateTable.setEnabled(false);
                    NaclTemplateWizardPage.this.checkForError(SELECT_AT_LEAST_ONE_TEMPLATE_TEXT, false);
                }
            }
        });
        this.templateRadioButton.setText(TEMPLATE_TEXT);
        this.templateTable = new Table(container, 68130);
        this.templateTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NaclTemplateWizardPage.this.checkForError(SELECT_AT_LEAST_ONE_TEMPLATE_TEXT, !NaclTemplateWizardPage.this.isAnyTemplateItemSelected());
            }
        });
        this.templateTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.templateTable.setLinesVisible(true);
        String[] stringArray = this.getTemplateNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            TableItem item = new TableItem(this.templateTable, 0);
            item.setText(s);
            ++n2;
        }
        this.templateTable.setEnabled(false);
        Label label_1 = new Label(container, 258);
        label_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.emptyModuleRadioButton = new Button(container, 16);
        this.emptyModuleRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NaclTemplateWizardPage.this.emptyModuleRadioButton.getSelection()) {
                    NaclTemplateWizardPage.this.readmeStyledText.setText(NaclTemplateWizardPage.this.getEmptyProjectDescription());
                }
            }
        });
        GridData gd_btnRadioButton_2 = new GridData(16384, 128, false, true, 1, 1);
        gd_btnRadioButton_2.widthHint = 170;
        this.emptyModuleRadioButton.setLayoutData((Object)gd_btnRadioButton_2);
        this.emptyModuleRadioButton.setText(EMPTY_NACL_MODULE_TEXT);
        this.actionOnLanguageChange(NativeLanguage.CPP);
    }

    private void setSampleDescription(String sampleName) {
        UiUtils.ExampleReadme readme = new UiUtils.ExampleReadme();
        String examplePath = "/templates/examples/" + sampleName;
        PNaClHelper.getReadmeForExample((UiUtils.ExampleReadme)readme, (String)examplePath);
        UiUtils.setReadmeText((StyledText)this.readmeStyledText, (UiUtils.ExampleReadme)readme);
    }

    private String getTemplateDescription() {
        return "";
    }

    private String getEmptyProjectDescription() {
        return "";
    }

    private String[] getTemplateNames() {
        LinkedList<String> templateNames = new LinkedList<String>();
        PluginConfig.ETemplateInterfaces[] eTemplateInterfacesArray = PluginConfig.ETemplateInterfaces.values();
        int n = eTemplateInterfacesArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginConfig.ETemplateInterfaces eInterface = eTemplateInterfacesArray[n2];
            String stringValue = eInterface.toString();
            if (stringValue != null && !stringValue.isEmpty()) {
                templateNames.add(stringValue);
            }
            ++n2;
        }
        return templateNames.toArray(new String[0]);
    }

    private String[] getSampleNames(NativeLanguage language) {
        return PluginConfig.getInstance().getExampleProjects(language);
    }

    private boolean isAnyTemplateItemSelected() {
        boolean isAnySelected = false;
        TableItem[] tableItemArray = this.templateTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                isAnySelected = true;
                break;
            }
            ++n2;
        }
        return isAnySelected;
    }

    private String[] getAvailableLanguages() {
        return new String[]{NativeLanguage.CPP.toString(), NativeLanguage.C.toString()};
    }

    public static class Data {
        public final String language;
        public final String projectType;
        public final String sampleName;
        public final Set<String> selectedInterfaces;

        public Data(String projectType, String sampleName, Set<String> selectedInterfaces, String language) {
            this.language = language;
            this.projectType = projectType;
            this.sampleName = sampleName;
            this.selectedInterfaces = selectedInterfaces;
        }
    }
}

