/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceMappingProvider {
    private final Map<String, String> includesToInterfaces = new HashMap<String, String>();
    private final Map<String, List<String>> interfacesToPrivileges = new HashMap<String, List<String>>();
    private final Multimap<String, String> privilegesToInterfaces = ArrayListMultimap.create();
    private static InterfaceMappingProvider instance = new InterfaceMappingProvider();

    public static InterfaceMappingProvider getInstance() {
        return instance;
    }

    private InterfaceMappingProvider() {
        InputStream is = this.getClass().getResourceAsStream("interfaces_mapping");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    List<Object> privilegeList;
                    String[] split = line.split(";");
                    String include = split[0];
                    String iface = split[1];
                    this.includesToInterfaces.put(include, iface);
                    if (split.length <= 2 || split[2].isEmpty()) continue;
                    String privileges = split[2];
                    if (this.interfacesToPrivileges.containsKey(iface)) {
                        privilegeList = this.interfacesToPrivileges.get(iface);
                    } else {
                        privilegeList = new ArrayList();
                        this.interfacesToPrivileges.put(iface, privilegeList);
                    }
                    String[] stringArray = privileges.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String priv = stringArray[n2];
                        privilegeList.add(priv);
                        this.privilegesToInterfaces.put((Object)priv, (Object)iface);
                        ++n2;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, String> getInterfacesMapping() {
        return this.includesToInterfaces;
    }

    public Collection<String> getInterfaceNames() {
        return this.includesToInterfaces.values();
    }

    public Map<String, List<String>> getPrivilegesMapping() {
        return this.interfacesToPrivileges;
    }

    public Multimap<String, String> getPrivilegesToInterfacesMapping() {
        return this.privilegesToInterfaces;
    }
}

