/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.export;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.web.tv.sec.nacl.builder.export.Messages;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;

class WidgetExportPage
extends WizardPage {
    public static final String TIZEN_WIDGET_EXTENSION = ".wgt";
    private Combo projectSelector;
    private Text widgetPath;
    private String initialSelection;

    protected WidgetExportPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.WidgetExportPage_exportPageTitle);
        this.setDescription(Messages.WidgetExportPage_exportPageDescription);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(3, false);
        comp.setLayout((Layout)layout);
        this.createProjectControl(comp);
        this.createWidgetPathControls(comp);
    }

    public void setInitialSelection(String projectName) {
        this.initialSelection = projectName;
    }

    private void createProjectControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.WidgetExportPage_chooseProject);
        this.projectSelector = new Combo(parent, 2060);
        this.projectSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        IProject[] naclProjects = ProjectUtils.listNaclProjects();
        this.projectSelector.setData((Object)naclProjects);
        int selection = -1;
        int i = 0;
        while (i < naclProjects.length) {
            IProject project = naclProjects[i];
            this.projectSelector.add(project.getName());
            if (project.getName().equals(this.initialSelection)) {
                selection = i;
            }
            ++i;
        }
        this.projectSelector.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent ev) {
                int index = WidgetExportPage.this.projectSelector.getSelectionIndex();
                if (index >= 0) {
                    IProject[] projects = (IProject[])WidgetExportPage.this.projectSelector.getData();
                    WidgetExportPage.this.setDefaultWidgetPath(projects[index]);
                }
                WidgetExportPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent ev) {
                WidgetExportPage.this.getWizard().getContainer().updateButtons();
            }
        });
        if (selection < 0 && this.projectSelector.getItemCount() == 1) {
            selection = 0;
        }
        if (selection >= 0) {
            this.projectSelector.select(selection);
        }
    }

    private void setDefaultWidgetPath(IProject project) {
        IPath projectPath = project.getLocation();
        IPath defaultPath = projectPath.append(String.valueOf(project.getName()) + TIZEN_WIDGET_EXTENSION);
        this.widgetPath.setText(defaultPath.toString());
    }

    private void createWidgetPathControls(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.WidgetExportPage_widgetPath);
        this.widgetPath = new Text(parent, 2052);
        this.widgetPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.widgetPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                WidgetExportPage.this.getWizard().getContainer().updateButtons();
            }
        });
        int selection = this.projectSelector.getSelectionIndex();
        if (selection >= 0) {
            IProject[] projects = (IProject[])this.projectSelector.getData();
            this.setDefaultWidgetPath(projects[selection]);
        }
        Button browseButton = new Button(parent, 8);
        browseButton.setText(Messages.WidgetExportPage_browseLabel);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                String selected;
                String filterPath;
                FileDialog dialog = new FileDialog(WidgetExportPage.this.getShell(), 4096);
                dialog.setText(Messages.WidgetExportPage_chooseTargetWidget);
                dialog.setFilterExtensions(new String[]{"*.wgt"});
                dialog.setOverwrite(true);
                Path start = Paths.get(WidgetExportPage.this.widgetPath.getText(), new String[0]).getParent();
                if (start != null && Files.exists(start, new LinkOption[0])) {
                    filterPath = start.toString();
                } else if (WidgetExportPage.this.projectSelector.getSelectionIndex() >= 0) {
                    IProject project = WidgetExportPage.this.getProject();
                    filterPath = project.getLocation().toString();
                } else {
                    filterPath = null;
                }
                if (filterPath != null) {
                    dialog.setFilterPath(filterPath);
                }
                if ((selected = dialog.open()) != null) {
                    if (!selected.endsWith(WidgetExportPage.TIZEN_WIDGET_EXTENSION)) {
                        selected = String.valueOf(selected) + WidgetExportPage.TIZEN_WIDGET_EXTENSION;
                    }
                    WidgetExportPage.this.widgetPath.setText(selected);
                }
            }
        });
    }

    public boolean isPageComplete() {
        String warningMessage = null;
        if (this.projectSelector.getSelectionIndex() < 0) {
            this.setErrorMessage(Messages.WidgetExportPage_noProjectSelectedError);
            return false;
        }
        if (this.widgetPath.getText().isEmpty()) {
            this.setErrorMessage(Messages.WidgetExportPage_noWidgetError);
            return false;
        }
        if (Files.exists(Paths.get(this.widgetPath.getText(), new String[0]), new LinkOption[0])) {
            warningMessage = Messages.WidgetExportPage_widgetExists;
        }
        this.setMessage(warningMessage, 2);
        this.setErrorMessage(null);
        return true;
    }

    IProject getProject() {
        int selection = this.projectSelector.getSelectionIndex();
        if (selection < 0) {
            return null;
        }
        String projectName = this.projectSelector.getItem(selection);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    String getWidgetPath() {
        String widgetPathStr = this.widgetPath.getText();
        if (widgetPathStr.endsWith(TIZEN_WIDGET_EXTENSION)) {
            return this.widgetPath.getText();
        }
        return String.valueOf(widgetPathStr) + TIZEN_WIDGET_EXTENSION;
    }
}

