/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.toolchain;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.ExternalBuildRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.Preferences;
import org.tizen.web.tv.sec.nacl.builder.toolchain.BundleHelper;
import org.tizen.web.tv.sec.nacl.builder.toolchain.Messages;
import org.tizen.web.tv.sec.nacl.builder.toolchain.NmfUpdater;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;

public class NaclBuildRunner
extends ExternalBuildRunner {
    public boolean invokeBuild(int kind, IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        this.checkPreferences(project);
        if (kind != 15) {
            try {
                File artifact = NmfUpdater.findArtifactName(configuration);
                artifact.delete();
            }
            catch (NaclBuildException e) {
                e.printStackTrace();
            }
        } else {
            IPath urlProjectPath = project.getLocation();
            String destinationPath = "";
            if (urlProjectPath != null) {
                destinationPath = urlProjectPath.toString().concat("/CurrentBin/nacl_clean.py").replaceAll("/", Matcher.quoteReplacement(File.separator));
                String bundlePath = "/nacl_clean.py";
                if (!new File(destinationPath).exists()) {
                    BundleHelper.getInstance().copyFileToProject(bundlePath, destinationPath);
                }
            }
        }
        boolean result = this.invokeExternalBuild(kind, project, configuration, builder, console, markerGenerator, projectBuilder, monitor);
        if (kind != 15) {
            try {
                File file = NmfUpdater.findArtifactName(configuration);
                if (!file.exists()) {
                    throw new NaclBuildException(String.valueOf(Messages.NaclBuildRunner_manifestNotFoundError) + file.getPath());
                }
            }
            catch (SecurityException | NaclBuildException e) {
                throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.builder", Messages.NaclBuildRunner_buildFailedCheckConsoleError, (Throwable)e));
            }
            NmfUpdater.updateManifest(project, configuration, console);
            NaclBuildRunner.symlinkOutput(project, configuration);
        }
        project.refreshLocal(2, monitor);
        return result;
    }

    private void checkPreferences(IProject project) throws CoreException {
        INaclPreferences preferences = NaclPreferenceActivator.getDefault().getNaclPreferences();
        Preferences node = preferences.getProjectPreferences(project);
        if (node != null) {
            boolean custom = node.getBoolean("customPepperPath", false);
            if (custom) {
                return;
            }
            if (preferences.getPepperVersions().isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.builder", Messages.NaclBuildRunner_noPepperToolchainsError));
            }
        }
    }

    public static void symlinkOutput(IProject project, IConfiguration configuration) throws CoreException {
        String outputDir = configuration.getBuilder().getBuildLocation().toString();
        String projectDir = project.getLocation().toString();
        Path linkPath = Paths.get(projectDir, "CurrentBin");
        try {
            if (Files.isSymbolicLink(linkPath)) {
                Files.deleteIfExists(linkPath);
            } else {
                FileUtils.deleteQuietly((File)new File(linkPath.toString()));
            }
            Files.createSymbolicLink(linkPath, Paths.get(outputDir, new String[0]), new FileAttribute[0]);
        }
        catch (SecurityException | UnsupportedOperationException | FileSystemException exception) {
            Logger.getGlobal().log(Level.WARNING, "Failed to create symlink '" + linkPath.toString() + "' to '" + outputDir.toString() + "'. Fallback to copying output folder.");
            try {
                FileUtils.copyDirectory((File)new File(outputDir), (File)new File(linkPath.toString()));
            }
            catch (IOException exCopy) {
                Logger.getGlobal().log(Level.SEVERE, "Failed to copy outoput directory!");
                exCopy.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.builder", Messages.NaclBuildRunner_symlinkCreationError, (Throwable)exCopy));
            }
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.builder", Messages.NaclBuildRunner_symlinkCreationError, (Throwable)ex));
        }
    }

    static class NaclBuildException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NaclBuildException(String msg) {
            super(msg);
        }
    }
}

