/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.toolchain;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.envvar.IProjectEnvironmentVariableSupplier;
import org.eclipse.core.resources.IProject;
import org.osgi.service.prefs.Preferences;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.web.tv.sec.nacl.common.SystemInfo;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;

public class NaclVariableSupplier
implements IProjectEnvironmentVariableSupplier {
    private Map<String, IBuildEnvironmentVariable> envVars = new HashMap<String, IBuildEnvironmentVariable>();
    private static boolean ownNaClEnv = false;

    public IBuildEnvironmentVariable getVariable(String variableName, IManagedProject project, IEnvironmentVariableProvider provider) {
        this.initializeMap(project);
        return this.envVars.get(variableName);
    }

    public IBuildEnvironmentVariable[] getVariables(IManagedProject project, IEnvironmentVariableProvider provider) {
        this.initializeMap(project);
        return this.envVars.values().toArray(new IBuildEnvironmentVariable[0]);
    }

    private void initializeMap(IManagedProject managedProject) {
        StringBuilder pathBuilder = new StringBuilder();
        this.appendWindowsSpecificPath(pathBuilder);
        if (pathBuilder.length() > 0 && pathBuilder.charAt(pathBuilder.length() - 1) != File.pathSeparatorChar) {
            pathBuilder.append(File.pathSeparatorChar);
        }
        String pepperVersion = "";
        INaclPreferences preferences = NaclPreferenceActivator.getDefault().getNaclPreferences();
        IProject project = managedProject.getOwner().getProject();
        Preferences node = preferences.getProjectPreferences(project);
        boolean customPepper = false;
        if (node != null) {
            customPepper = node.getBoolean("customPepperPath", false);
            pepperVersion = node.get("pepperVersion", "");
        }
        Path pepperDir = null;
        if (customPepper) {
            pepperDir = Paths.get(pepperVersion, new String[0]);
        } else {
            Map pepperMap = preferences.getPepperVersions();
            if (pepperVersion.isEmpty() && !pepperMap.isEmpty()) {
                pepperVersion = NaclVariableSupplier.getDefaultPepper(pepperMap);
            }
            if (pepperMap.containsKey(pepperVersion)) {
                pepperDir = (Path)pepperMap.get(pepperVersion);
            }
        }
        if (pepperDir != null) {
            if (ownNaClEnv || !System.getenv().containsKey("NACL_SDK_ROOT")) {
                this.insertVariable("NACL_SDK_ROOT", pepperDir.toString());
                ownNaClEnv = true;
            }
            pathBuilder.append(preferences.getToolchainBinPath(pepperDir, "pnacl").toString());
            pathBuilder.append(File.pathSeparator);
            pathBuilder.append(preferences.getToolchainBinPath(pepperDir, "arm_glibc").toString());
        }
        if (pathBuilder.length() > 0) {
            this.insertVariable("PATH", pathBuilder.toString());
        }
        if (SystemInfo.isWindowsOs()) {
            this.insertVariable("PNACL_TOOLS_POSTFIX", ".bat");
        } else {
            this.insertVariable("PNACL_TOOLS_POSTFIX", "");
        }
    }

    private void appendWindowsSpecificPath(StringBuilder pathBuilder) {
        if (SystemInfo.isWindowsOs()) {
            String msys2Path = String.valueOf(InstallPathConfig.getToolsPath()) + File.separator + "msys2" + File.separator + "usr" + File.separator + "bin";
            String mingwPath = String.valueOf(InstallPathConfig.getToolsPath()) + File.separator + "mingw" + File.separator + "bin";
            if (new File(msys2Path).exists()) {
                pathBuilder.append(msys2Path);
            } else {
                pathBuilder.append(mingwPath);
            }
        }
    }

    public static String getDefaultPepper(Map<String, Path> pepperMap) {
        return pepperMap.isEmpty() ? "" : Collections.max(pepperMap.keySet());
    }

    private void insertVariable(String name, String value) {
        this.envVars.put(name, new NaclVariable(name, value));
    }

    private static class NaclVariable
    implements IBuildEnvironmentVariable {
        private final String name;
        private final String value;

        NaclVariable(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getOperation() {
            return 3;
        }

        public String getDelimiter() {
            return File.pathSeparator;
        }
    }
}

