/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.toolchain;

import java.util.LinkedList;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.web.tv.sec.nacl.common.SystemInfo;

public class TranslatorNameProvider
implements IManagedOutputNameProvider {
    public IPath[] getOutputNames(ITool tool, IPath[] primaryInputNames) {
        String projName = tool.getParentResourceInfo().getParent().getManagedProject().getOwner().getName();
        String configuration = tool.getParentResourceInfo().getParent().getId();
        IOption option = tool.getOptionBySuperClassId("org.tizen.web.tv.sec.nacl.builder.translator.arch");
        this.setAppropriateDefaultArch(configuration, option);
        LinkedList<Path> paths = new LinkedList<Path>();
        String[] architectures = null;
        if (configuration.startsWith("org.tizen.web.tv.sec.nacl.builder.toolchain.debug")) {
            architectures = option.getApplicableValues();
        } else {
            try {
                String senum = option.getSelectedEnum();
                architectures = new String[]{option.getEnumName(senum)};
            }
            catch (BuildException e) {
                throw new RuntimeException(e);
            }
        }
        String[] stringArray = architectures;
        int n = architectures.length;
        int n2 = 0;
        while (n2 < n) {
            String arch = stringArray[n2];
            paths.add(new Path(String.valueOf(projName) + "_" + arch + ".nexe"));
            ++n2;
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    private void setAppropriateDefaultArch(String configId, IOption archOption) {
        if (configId.contains("glibc")) {
            archOption.setDefaultValue((Object)"org.tizen.web.tv.sec.nacl.builder.toolchain.linker.arch.armv7");
        } else if (SystemInfo.is64Bit()) {
            archOption.setDefaultValue((Object)"org.tizen.web.tv.sec.nacl.builder.toolchain.linker.arch.x86-64");
        } else if (SystemInfo.is32Bit()) {
            archOption.setDefaultValue((Object)"org.tizen.web.tv.sec.nacl.builder.toolchain.linker.arch.i686");
        }
    }
}

