/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.tizen.web.tv.sec.nacl.builder.InterfaceMappingProvider;
import org.tizen.web.tv.sec.nacl.builder.privileges.ConfigXmlChangeReporter;
import org.tizen.web.tv.sec.nacl.builder.toolchain.Messages;
import org.tizen.web.tv.sec.nacl.builder.toolchain.PepperInterfacesCollector;
import org.tizen.web.tv.sec.nacl.common.EditXML;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Utils {
    public static final String PERMISSIONS_NODE_NAME = "permissions";
    public static final ObjectMapper JsonObjectMapper = new ObjectMapper();

    public static String getArtifactName(IPath buildPath) throws IOException {
        String artifact = "";
        File makefile = buildPath.append("makefile").toFile();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(makefile));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("all:")) continue;
                artifact = line.split(" ")[1];
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (artifact.isEmpty()) {
            throw new IOException(Messages.NaclBuildRunner_noAllTargetError);
        }
        return artifact;
    }

    public static Set<String> getTizenPrivileges(Set<String> permissions) {
        LinkedHashSet<String> privilegeSet = new LinkedHashSet<String>();
        Map<String, List<String>> privilegeMap = InterfaceMappingProvider.getInstance().getPrivilegesMapping();
        for (String permission : permissions) {
            List<String> privileges = privilegeMap.get(permission);
            if (privileges == null) continue;
            privilegeSet.addAll(privileges);
        }
        return privilegeSet;
    }

    public static Set<String> gatherPermissionsFromSources(IProject project) throws CoreException {
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        ICProject cproject = CoreModel.getDefault().create(project);
        cproject.accept((ICElementVisitor)new PepperInterfacesCollector(InterfaceMappingProvider.getInstance().getInterfacesMapping(), interfaces));
        interfaces.retainAll(InterfaceMappingProvider.getInstance().getInterfaceNames());
        return interfaces;
    }

    public static boolean updateInterfacesFromProjPreferences(Set<String> interfaces, IProject project) {
        ArrayList removedPrivileges;
        ArrayList selectedPrivileges;
        INaclPreferences prefs = NaclPreferenceActivator.getDefault().getNaclPreferences();
        if (prefs.getPrivilegesList(project, selectedPrivileges = new ArrayList(), removedPrivileges = new ArrayList())) {
            Collection privInterfaces;
            Multimap<String, String> privToInterface = InterfaceMappingProvider.getInstance().getPrivilegesToInterfacesMapping();
            for (String priv : selectedPrivileges) {
                privInterfaces = privToInterface.get((Object)priv);
                interfaces.addAll(privInterfaces);
            }
            for (String priv : removedPrivileges) {
                privInterfaces = privToInterface.get((Object)priv);
                interfaces.removeAll(privInterfaces);
            }
            return true;
        }
        return false;
    }

    public static boolean updatePrivilegesFromProjPreferences(Set<String> privileges, IProject project) {
        ArrayList removedPrivileges;
        ArrayList selectedPrivileges;
        INaclPreferences prefs = NaclPreferenceActivator.getDefault().getNaclPreferences();
        if (prefs.getPrivilegesList(project, selectedPrivileges = new ArrayList(), removedPrivileges = new ArrayList())) {
            privileges.addAll(selectedPrivileges);
            privileges.removeAll(removedPrivileges);
            return true;
        }
        return false;
    }

    public static void loadPrivilegesFromConfigXml(String filePath, Collection<String> privileges) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(filePath);
        Element root = document.getDocumentElement();
        NodeList privList = root.getElementsByTagName("tizen:privilege");
        int index = 0;
        while (index < privList.getLength()) {
            Node node = privList.item(index);
            NamedNodeMap attributes = node.getAttributes();
            Node attr = attributes.getNamedItem("name");
            if (attr != null) {
                String privilege = attr.getNodeValue();
                privileges.add(privilege);
            }
            ++index;
        }
    }

    private static void addPrivileges(EditXML document, Collection<String> privileges) {
        for (String privilege : privileges) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", privilege);
            document.add("tizen:privilege", "widget", attributes);
        }
    }

    public static void storePrivilegesToConfigXml(String config, Collection<String> privileges) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        if (!Files.exists(Paths.get(config, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(config);
        }
        EditXML editXML = new EditXML();
        if (editXML.openFile(config, false)) {
            editXML.removeTags("tizen:privilege", null);
            Utils.addPrivileges(editXML, privileges);
            editXML.closeFile();
        }
    }

    public static Set<String> getPermissionsFromNmf(File artifact) {
        JsonNode root;
        TreeSet<String> permissions = new TreeSet<String>();
        try {
            root = JsonObjectMapper.readTree(artifact);
        }
        catch (IOException e) {
            e.printStackTrace();
            return permissions;
        }
        JsonNode permissionsNode = root.get(PERMISSIONS_NODE_NAME);
        if (permissionsNode != null) {
            if (permissionsNode.isArray()) {
                Iterator iterator = ((ArrayNode)permissionsNode).elements();
                while (iterator.hasNext()) {
                    permissions.add(((JsonNode)iterator.next()).asText());
                }
            } else {
                System.err.println("nmf parsing error: found permissions node in the nmf but it is not an array");
            }
        }
        return permissions;
    }

    public static IResourceChangeListener registerChangeListenerForResource(String resourceName, int eventType) {
        ConfigXmlChangeReporter listener = new ConfigXmlChangeReporter(resourceName);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, eventType);
        Logger.getGlobal().info("Listener registered for changes in " + resourceName);
        return listener;
    }

    public static void unregisterChangeListenerForResource(IResourceChangeListener listener) {
        if (listener == null) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkForEnvironmentConflict(AbstractUIPlugin plugin, String envVarName) {
        if (System.getenv().containsKey(envVarName)) {
            try {
                MessageDialog.open((int)4, null, (String)org.tizen.web.tv.sec.nacl.builder.Messages.Utils_ConflictingEnvSettingsDetected, (String)(String.valueOf(org.tizen.web.tv.sec.nacl.builder.Messages.Utils_ThereIsA) + "NACL_SDK_ROOT" + "=" + System.getenv("NACL_SDK_ROOT") + org.tizen.web.tv.sec.nacl.builder.Messages.Utils_DescriptionHowToFixEnvironment), (int)8);
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(org.tizen.web.tv.sec.nacl.builder.Messages.Utils_ThereIsA) + "NACL_SDK_ROOT" + "=" + System.getenv("NACL_SDK_ROOT") + org.tizen.web.tv.sec.nacl.builder.Messages.Utils_DescriptionHowToFixEnvironment);
            }
        }
    }
}

