/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.export;

import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.tizen.web.tv.sec.nacl.builder.export.Messages;
import org.tizen.web.tv.sec.nacl.builder.export.WidgetExporter;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;

public class BuildPackageCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = ProjectUtils.getCurrentProject((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (project == null) {
            Logger.getGlobal().info("Project is null");
        }
        Logger.getGlobal().info("Project: " + project.getName());
        String widgetPath = project.getLocation().append(String.valueOf(project.getName()) + ".wgt").toString();
        Logger.getGlobal().info(widgetPath);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        try {
            WidgetExporter.export(project, widgetPath, false);
        }
        catch (CoreException ex) {
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)Messages.WidgetExportWizard_errorMessage, (String)ex.getLocalizedMessage());
            }
            throw new ExecutionException("Error exporting widget.", (Throwable)ex);
        }
        if (shell != null) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.WidgetExportWizard_successMessage, (String)NLS.bind((String)Messages.WidgetExportWizard_widgetExportedMessage, (Object)widgetPath));
        }
        return null;
    }
}

