/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.export;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.web.tv.sec.nacl.adapter.export.PackagingAdapter;
import org.tizen.web.tv.sec.nacl.builder.Utils;
import org.tizen.web.tv.sec.nacl.common.plugin.NaClModuleUtils;

public abstract class WidgetExporter {
    public static final String PRIVILEGE_TAG = "tizen:privilege";
    public static final String PRIVILEGE_NAME_ATTR = "name";

    public static void export(IProject project, String widgetPath, boolean isDebugMode) throws CoreException {
        try {
            try {
                WidgetExporter.updateConfigXml("config.xml", project, isDebugMode);
                if (!isDebugMode) {
                    WidgetExporter.packTizenWidget(project, widgetPath);
                } else {
                    IProject parent = NaClModuleUtils.getTizenProject((IProject)project);
                    if (parent != null) {
                        HashSet<String> excludeDirs = new HashSet<String>();
                        IProject[] iProjectArray = NaClModuleUtils.getNaClModules((IProject)parent);
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject naclModule = iProjectArray[n2];
                            if (naclModule.getName() != project.getName()) {
                                excludeDirs.add(naclModule.getName());
                            }
                            ++n2;
                        }
                        WidgetExporter.packTizenWidget(project, widgetPath, excludeDirs.toArray(new String[0]));
                    } else {
                        WidgetExporter.packTizenWidget(project, widgetPath);
                    }
                }
            }
            catch (CoreException ex) {
                throw ex;
            }
            catch (Exception ex) {
                Logger.getGlobal().log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.builder", ex.getLocalizedMessage(), (Throwable)ex));
            }
        }
        finally {
            project.refreshLocal(2, null);
        }
    }

    public static void updateConfigXml(String configXmlFileName, IProject project, boolean isDebugMode) {
        try {
            Collection<String> privileges = WidgetExporter.computePrivileges(project);
            if (isDebugMode) {
                privileges.add("http://tizen.org/privilege/appmanager.certificate");
            }
            IFile config = project.getFile(configXmlFileName);
            Utils.storePrivilegesToConfigXml(config.getLocation().toString(), privileges);
            config.refreshLocal(0, null);
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    private static Collection<String> computePrivileges(IProject project) throws IOException {
        IPath current = project.getLocation().append("CurrentBin");
        Set<String> permissions = WidgetExporter.gatherPermissionsFromNmf(current);
        Set<String> privileges = Utils.getTizenPrivileges(permissions);
        Utils.updatePrivilegesFromProjPreferences(privileges, project);
        return privileges;
    }

    private static Set<String> gatherPermissionsFromNmf(IPath buildDir) throws IOException {
        TreeSet<String> permissionList = new TreeSet<String>();
        IPath artifact = buildDir.append(Utils.getArtifactName(buildDir));
        Set<String> readPermissions = Utils.getPermissionsFromNmf(artifact.toFile());
        if (!readPermissions.isEmpty()) {
            permissionList.addAll(readPermissions);
        }
        return permissionList;
    }

    public static void packTizenWidget(IProject project, String widgetPath) throws CoreException {
        WidgetExporter.packTizenWidget(project, widgetPath, new String[0]);
    }

    public static void packTizenWidget(IProject project, String widgetPath, String[] excludeDirs) throws CoreException {
        HashSet excludeDirsSet = new HashSet();
        Collections.addAll(excludeDirsSet, excludeDirs);
        Collections.addAll(excludeDirsSet, "src", "inc");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        Collections.addAll(excludeDirsSet, info.getConfigurationNames());
        PackagingAdapter.packageProject((IProject)project, excludeDirsSet, null, (String)widgetPath);
    }
}

