/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.toolchain;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Set;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.web.tv.sec.nacl.builder.Utils;
import org.tizen.web.tv.sec.nacl.builder.toolchain.Messages;
import org.tizen.web.tv.sec.nacl.builder.toolchain.NaclBuildRunner;

public class NmfUpdater {
    static void updateManifest(IProject project, IConfiguration configuration, IConsole console) throws CoreException {
        try {
            Set<String> permissions = Utils.gatherPermissionsFromSources(project);
            Utils.updateInterfacesFromProjPreferences(permissions, project);
            if (permissions.isEmpty()) {
                return;
            }
            File artifact = NmfUpdater.findArtifactName(configuration);
            JsonNode root = Utils.JsonObjectMapper.readTree(artifact);
            boolean permissionsUpdated = false;
            Set<String> permissionsFromCurrentNmf = Utils.getPermissionsFromNmf(artifact);
            if (!permissionsFromCurrentNmf.isEmpty()) {
                permissions.addAll(permissionsFromCurrentNmf);
                permissionsUpdated = true;
            } else {
                JsonNode permissionsNode = root.get("permissions");
                if (permissionsNode == null) {
                    permissionsNode = ((ObjectNode)root).putArray("permissions");
                }
                for (String permission : permissions) {
                    ((ArrayNode)permissionsNode).add(permission);
                }
                permissionsUpdated = true;
            }
            if (permissionsUpdated) {
                JsonGenerator generator = new JsonFactory().createGenerator(artifact, JsonEncoding.UTF8);
                Utils.JsonObjectMapper.writerWithDefaultPrettyPrinter().writeValue(generator, (Object)root);
            }
        }
        catch (IOException | NaclBuildRunner.NaclBuildException e) {
            PrintWriter errorWriter = new PrintWriter((OutputStream)console.getErrorStream(), true);
            errorWriter.println(e.getMessage());
            errorWriter.close();
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.builder", e.getMessage(), (Throwable)e));
        }
    }

    static File findArtifactName(IConfiguration configuration) throws NaclBuildRunner.NaclBuildException {
        if (!configuration.getArtifactExtension().equals("nmf")) {
            throw new NaclBuildRunner.NaclBuildException(Messages.NaclBuildRunner_buildArtifactTypeError);
        }
        IPath buildPath = configuration.getBuilder().getBuildLocation();
        try {
            String artifact = Utils.getArtifactName(buildPath);
            return buildPath.append(artifact).toFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new NaclBuildRunner.NaclBuildException(ex.getLocalizedMessage());
        }
    }
}

